/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4C8Kpcdsc;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;

class T4C8Kpcds
extends T4CTTIMsg {
    private final short INITOBJECTYPE = (short)-1;
    private ArrayList<T4C8Kpcdsc> t4c8kpcdscs = new ArrayList();
    private short descObjectType = (short)-1;

    T4C8Kpcds(T4CConnection _connection) {
        super(_connection, (byte)0);
    }

    void unmarshal() throws IOException, SQLException {
        this.t4c8kpcdscs.clear();
        this.descObjectType = (short)-1;
        int dsybfl = this.meg.unmarshalUB2();
        this.unmarshalDTYDSYR();
    }

    void unmarshalDTYDSYR() throws IOException, SQLException {
        long databasel_kpcds;
        long schemal_kpcds;
        long typel_kpcds;
        long seql_kpcds;
        long argl_kpcds;
        long coll_kpcds;
        long synl_kpcds;
        long pkgl_kpcds;
        long funcl_kpcds;
        long procl_kpcds;
        long viewl_kpcds;
        long tablel_kpcds;
        long headerl_kpcds = this.meg.unmarshalUB4();
        if (headerl_kpcds > 0L) {
            this.unmarshalDTYDSYH();
        }
        long envl_kpcds = this.meg.unmarshalUB4();
        byte[] env_kpcdsh = null;
        if (envl_kpcds > 0L) {
            env_kpcdsh = this.meg.unmarshalDALC();
        }
        short con_kpcds = this.meg.unmarshalUB1();
        long listl_kpcds = this.meg.unmarshalUB4();
        if (listl_kpcds > 0L) {
            this.unmarshalDTYDSYL();
        }
        if ((tablel_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalDTYDSYT();
        }
        if ((viewl_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalDTYDSYV();
        }
        if ((procl_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalNotImplement("unmarshalDTYDSYP");
        }
        if ((funcl_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalNotImplement("unmarshalDTYDSYF");
        }
        if ((pkgl_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalNotImplement("unmarshalDTYDSYK");
        }
        if ((synl_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalNotImplement("unmarshalDTYDSYY");
        }
        if ((coll_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalDTYDSYC();
        }
        if ((argl_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalNotImplement("unmarshalDTYDSYA");
        }
        if ((seql_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalNotImplement("unmarshalDTYDSYQ");
        }
        if ((typel_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalNotImplement("unmarshalDTYDSYTY");
        }
        if ((schemal_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalNotImplement("unmarshalDTYDSYS");
        }
        if ((databasel_kpcds = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalNotImplement("unmarshalDTYDSYD");
        }
        if (this.connection.getTTCVersion() >= 3) {
            long nvl_kpcds;
            long vtl_kpcds;
            long tal_kpcds;
            long ecl_kpcds;
            long rsl_kpcds;
            long rulel_kpcds = this.meg.unmarshalUB4();
            if (rulel_kpcds > 0L) {
                this.unmarshalNotImplement("unmarshalPiedsru");
            }
            if ((rsl_kpcds = this.meg.unmarshalUB4()) > 0L) {
                this.unmarshalNotImplement("unmarshalPiedsrs");
            }
            if ((ecl_kpcds = this.meg.unmarshalUB4()) > 0L) {
                this.unmarshalNotImplement("unmarshalPiedsec");
            }
            if ((tal_kpcds = this.meg.unmarshalUB4()) > 0L) {
                this.unmarshalNotImplement("unmarshalPiedstl");
            }
            if ((vtl_kpcds = this.meg.unmarshalUB4()) > 0L) {
                this.unmarshalNotImplement("unmarshalPiedsvt");
            }
            if ((nvl_kpcds = this.meg.unmarshalUB4()) > 0L) {
                this.unmarshalNotImplement("unmarshalPiedsnv");
            }
        }
        if (this.connection.getTTCVersion() >= 8) {
            long hrl_kpcds;
            long hierl_kpcds = this.meg.unmarshalUB4();
            if (hierl_kpcds > 0L) {
                this.unmarshalNotImplement("unmarshalPiedsyhr");
            }
            if ((hrl_kpcds = this.meg.unmarshalUB4()) > 0L) {
                this.unmarshalNotImplement("unmarshalPiedsyhc");
            }
        }
    }

    void unmarshalDTYDSYR_R() throws IOException, SQLException {
        short packetsize_kpcds = this.meg.unmarshalUB1();
        this.unmarshalDTYDSYR();
    }

    int getObjectType() {
        return this.descObjectType;
    }

    void unmarshalDTYDSYH() throws IOException, SQLException {
        short packetsize_kpcdsh = this.meg.unmarshalUB1();
        short type_kpcdsh = this.meg.unmarshalUB1();
        if (this.descObjectType == -1) {
            this.descObjectType = type_kpcdsh;
        }
        byte[] time_kpcdsh = this.meg.unmarshalDALC();
        int timel_kpcdsh = time_kpcdsh.length;
        long flag_kpcdsh = this.meg.unmarshalUB4();
        byte[] schema_kpcdsh = this.meg.unmarshalDALC();
        int schemal_kpcdsh = schema_kpcdsh.length;
        byte[] name_kpcdsh = this.meg.unmarshalDALC();
        int namel_kpcdsh = name_kpcdsh.length;
        long id_kpcdsh = this.meg.unmarshalUB4();
    }

    void unmarshalDTYDSYV() throws IOException, SQLException {
        long collstl_kpcdsv;
        short packetsize_kpcdsv = this.meg.unmarshalUB1();
        long objid_kpcdsv = this.meg.unmarshalUB4();
        long refl_kpcdsv = this.meg.unmarshalUB4();
        byte[] ref_kpcdsv = null;
        int[] ret = new int[1];
        if (refl_kpcdsv > 0L) {
            ref_kpcdsv = this.meg.unmarshalCLR((int)refl_kpcdsv, ret);
        }
        if ((collstl_kpcdsv = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalDTYDSYR_R();
        }
        int num_cols_kpcdsv = this.meg.unmarshalUB2();
        byte[] typsch_kpcdsv = this.meg.unmarshalDALC();
        byte[] typnm_kpcdsv = this.meg.unmarshalDALC();
        short typed_kpcdsv = this.meg.unmarshalUB1();
        byte[] xschnm_kpcdsv = this.meg.unmarshalDALC();
        byte[] xelenm_kpcdsv = this.meg.unmarshalDALC();
        byte[] xsqlsch_kpcdsv = this.meg.unmarshalDALC();
        byte[] xsqlnm_kpcdsv = this.meg.unmarshalDALC();
        if (this.connection.getTTCVersion() >= 5) {
            short s = this.meg.unmarshalUB1();
        }
        if (this.connection.getTTCVersion() >= 14) {
            long l = this.meg.unmarshalUB4();
        }
    }

    void unmarshalDTYDSYT() throws IOException, SQLException {
        long kk_kpcdst;
        long collstl_kpcdst;
        short packetsize_kpcdst = this.meg.unmarshalUB1();
        long objid = this.meg.unmarshalUB4();
        long refl_kpcdst = this.meg.unmarshalUB4();
        byte[] ref_kpcdst = null;
        int[] ret = new int[1];
        if (refl_kpcdst > 0L) {
            ref_kpcdst = this.meg.unmarshalCLR((int)refl_kpcdst, ret);
        }
        if ((collstl_kpcdst = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalDTYDSYR_R();
        }
        int num_cols_kpcdst = this.meg.unmarshalUB2();
        int tsn_kpcdst = this.meg.unmarshalSWORD();
        long rdba_kpcdst = this.meg.unmarshalUB4();
        short clustered_kpcdst = this.meg.unmarshalUB1();
        short partitioned_kpcdst = this.meg.unmarshalUB1();
        short index_only_kpcdst = this.meg.unmarshalUB1();
        short temp_kpcdst = this.meg.unmarshalUB1();
        int duration_kpcdst = this.meg.unmarshalUB2();
        byte[] typsch_kpcdst = this.meg.unmarshalDALC();
        byte[] typnm_kpcdst = this.meg.unmarshalDALC();
        short typed_kpcdst = this.meg.unmarshalUB1();
        byte[] xschnm_kpcdst = this.meg.unmarshalDALC();
        byte[] xelenm_kpcdst = this.meg.unmarshalDALC();
        byte[] xsqlsch_kpcdst = this.meg.unmarshalDALC();
        byte[] xsqlnm_kpcdst = this.meg.unmarshalDALC();
        if (this.connection.getTTCVersion() >= 3) {
            short external_kpcdst = this.meg.unmarshalUB1();
            long l = this.meg.unmarshalUB4();
        }
        if (this.connection.getTTCVersion() >= 4 && (kk_kpcdst = this.meg.unmarshalUB4()) > 0L) {
            this.unmarshalDTYEN();
        }
        if (this.connection.getTTCVersion() >= 5) {
            short s = this.meg.unmarshalUB1();
        }
        if (this.connection.getTTCVersion() >= 14) {
            long l = this.meg.unmarshalUB4();
        }
    }

    void unmarshalDTYEN() throws IOException, SQLException {
        short packetsize_kzten = this.meg.unmarshalUB1();
        int kztenflg = this.meg.unmarshalUB2();
        long kztenaln = this.meg.unmarshalUB4();
        byte[] kztenalb = this.meg.unmarshalDALC();
        long kztenhsn = this.meg.unmarshalUB4();
        byte[] kztenhsb = this.meg.unmarshalDALC();
    }

    void unmarshalDTYDSYC() throws IOException, SQLException {
        int n;
        int[] ret = new int[1];
        short packetsize_kpcdsc = this.meg.unmarshalUB1();
        int size_kpcdsc = this.meg.unmarshalUB2();
        int dty_kpcdsc = this.meg.unmarshalUB2();
        byte[] name_kpcdsc = this.meg.unmarshalDALC(ret);
        int namel_kpcdsc = ret[0];
        short precision_kpcdsc = this.meg.unmarshalUB1();
        short scale_kpcdsc = this.meg.unmarshalSB1();
        short isnull_kpcdsc = this.meg.unmarshalUB1();
        byte[] typsch_kpcdsc = this.meg.unmarshalDALC();
        ret[0] = 0;
        byte[] typnm_kpcdsc = this.meg.unmarshalDALC(ret);
        int typnml_kpcdsc = ret[0];
        long refl_kpcdsc = this.meg.unmarshalUB4();
        byte[] ref_kpcdsc = null;
        ret[0] = 0;
        if (refl_kpcdsc > 0L) {
            ref_kpcdsc = this.meg.unmarshalCLR((int)refl_kpcdsc, ret);
        }
        int charsetid_kpcdsc = this.meg.unmarshalUB2();
        short charsetform_kpcdsc = this.meg.unmarshalUB1();
        byte[] xschnm_kpcdsc = this.meg.unmarshalDALC();
        byte[] xelenm_kpcdsc = this.meg.unmarshalDALC();
        byte[] xsqlsch_kpcdsc = this.meg.unmarshalDALC();
        byte[] xsqlnm_kpcdsc = this.meg.unmarshalDALC();
        if (this.connection.getTTCVersion() >= 3) {
            n = this.meg.unmarshalUB2();
        }
        if (this.connection.getTTCVersion() >= 5) {
            n = this.meg.unmarshalUB1();
        }
        if (this.connection.getTTCVersion() >= 8) {
            byte[] dim_name_kpcdsc = this.meg.unmarshalDALC();
            byte[] hr_name_kpcdsc = this.meg.unmarshalDALC();
            byte[] byArray = this.meg.unmarshalDALC();
        }
        if (this.connection.getTTCVersion() >= 14) {
            long dim_name_kpcdsc = this.meg.unmarshalUB4();
        }
        String domainName = null;
        String domainSchema = null;
        if (this.connection.getTTCVersion() >= 17) {
            ret[0] = 0;
            byte[] domname_kpcdsc = this.meg.unmarshalDALC(ret);
            int domnamel_kpcdsc = ret[0];
            domainName = domnamel_kpcdsc == 0 ? null : this.meg.conv.CharBytesToString(domname_kpcdsc, domnamel_kpcdsc);
            ret[0] = 0;
            byte[] domsch_kpcdsc = this.meg.unmarshalDALC(ret);
            int domschl_kpcdsc = ret[0];
            domainSchema = domschl_kpcdsc == 0 ? null : this.meg.conv.CharBytesToString(domsch_kpcdsc, domschl_kpcdsc);
        }
        String columnName = namel_kpcdsc == 0 ? null : this.meg.conv.CharBytesToString(name_kpcdsc, namel_kpcdsc);
        String typeName = typnml_kpcdsc == 0 ? null : this.meg.conv.CharBytesToString(typnm_kpcdsc, typnml_kpcdsc);
        T4C8Kpcdsc newCol = new T4C8Kpcdsc(size_kpcdsc, dty_kpcdsc, columnName, precision_kpcdsc, scale_kpcdsc, isnull_kpcdsc, charsetform_kpcdsc, typeName, domainName, domainSchema);
        this.t4c8kpcdscs.add(newCol);
    }

    T4C8Kpcdsc[] getT4C8Kpcdscs() {
        T4C8Kpcdsc[] a = new T4C8Kpcdsc[this.t4c8kpcdscs.size()];
        this.t4c8kpcdscs.toArray(a);
        this.t4c8kpcdscs.clear();
        return a;
    }

    void unmarshalDTYDSYL() throws IOException, SQLException {
        short packetsize_kpcdsl = this.meg.unmarshalUB1();
        short type_kpcdsl = this.meg.unmarshalUB1();
        int num_kpcdsl = this.meg.unmarshalUB2();
        short packetsize_arraykpcdst = this.meg.unmarshalUB1();
        for (int i = 0; i < num_kpcdsl; ++i) {
            this.unmarshalDTYDSYR();
        }
    }

    void unmarshalNotImplement(String methodName) throws IOException, SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException(methodName).fillInStackTrace();
    }
}

