/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.util.Collections;
import java.util.stream.Collectors;
import org.keycloak.common.Profile;
import org.keycloak.models.GroupModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.services.resources.admin.permissions.GroupPermissionEvaluator;
import org.keycloak.utils.StringUtil;

public class GroupUtils {
    public static GroupRepresentation toGroupHierarchy(GroupPermissionEvaluator groupsEvaluator, GroupModel group, String search, boolean exact, boolean lazy) {
        return GroupUtils.toGroupHierarchy(groupsEvaluator, group, search, exact, true, lazy);
    }

    public static GroupRepresentation toGroupHierarchy(GroupPermissionEvaluator groupsEvaluator, GroupModel group, String search, boolean exact, boolean full, boolean lazy) {
        GroupRepresentation rep = ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)full);
        if (!lazy) {
            rep.setSubGroups(group.getSubGroupsStream().filter(g -> GroupUtils.groupMatchesSearchOrIsPathElement(g, search)).map(subGroup -> ModelToRepresentation.toGroupHierarchy((GroupModel)subGroup, (boolean)full, (String)search, (Boolean)exact)).collect(Collectors.toList()));
        } else {
            rep.setSubGroups(Collections.emptyList());
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ)) {
            GroupUtils.setAccess(groupsEvaluator, group, rep);
        }
        return rep;
    }

    private static void setAccess(GroupPermissionEvaluator groupsEvaluator, GroupModel groupTree, GroupRepresentation rootGroup) {
        if (rootGroup == null) {
            return;
        }
        rootGroup.setAccess(groupsEvaluator.getAccess(groupTree));
        rootGroup.getSubGroups().stream().forEach(subGroup -> {
            GroupModel foundGroupModel = groupTree.getSubGroupsStream().filter(g -> g.getId().equals(subGroup.getId())).findFirst().get();
            GroupUtils.setAccess(groupsEvaluator, foundGroupModel, subGroup);
        });
    }

    private static boolean groupMatchesSearchOrIsPathElement(GroupModel group, String search) {
        if (StringUtil.isBlank((String)search)) {
            return true;
        }
        if (group.getName().contains(search)) {
            return true;
        }
        return group.getSubGroupsStream().findAny().isPresent();
    }
}

