/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.userSession;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.api.annotations.indexing.Basic;
import org.infinispan.api.annotations.indexing.Indexed;
import org.infinispan.protostream.GeneratedSchema;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoDoc;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.storage.hotRod.common.AbstractHotRodEntity;
import org.keycloak.models.map.storage.hotRod.common.CommonPrimitivesProtoSchemaInitializer;
import org.keycloak.models.map.storage.hotRod.common.HotRodStringPair;
import org.keycloak.models.map.storage.hotRod.common.UpdatableHotRodEntityDelegateImpl;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodAuthenticatedClientSessionEntityReference;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodUserSessionEntityDelegate;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodUserSessionEntitySchemaImpl;
import org.keycloak.models.map.userSession.MapUserSessionEntity;

@Indexed
@ProtoDoc(value="schema-version: 1")
public class HotRodUserSessionEntity
extends AbstractHotRodEntity {
    @IgnoreForEntityImplementationGenerator
    public static final int VERSION = 1;
    @Basic(projectable=true)
    @ProtoField(number=1)
    public Integer entityVersion = 1;
    @ProtoField(number=2)
    public String id;
    @Basic(sortable=true)
    @ProtoField(number=3)
    public String realmId;
    @Basic(sortable=true)
    @ProtoField(number=4)
    public String userId;
    @Basic(sortable=true)
    @ProtoField(number=5)
    public String brokerSessionId;
    @Basic(sortable=true)
    @ProtoField(number=6)
    public String brokerUserId;
    @ProtoField(number=7)
    public String loginUsername;
    @ProtoField(number=8)
    public String ipAddress;
    @ProtoField(number=9)
    public String authMethod;
    @ProtoField(number=10)
    public Boolean rememberMe;
    @ProtoField(number=11)
    public Long timestamp;
    @Basic(sortable=true)
    @ProtoField(number=12)
    public Long lastSessionRefresh;
    @ProtoField(number=13)
    public Long expiration;
    @Basic(sortable=true)
    @ProtoField(number=14)
    public Set<HotRodStringPair> notes;
    @ProtoField(number=15)
    public Integer state;
    @Basic(sortable=true)
    @ProtoField(number=16)
    public Set<HotRodAuthenticatedClientSessionEntityReference> authenticatedClientSessions;
    @Basic(sortable=true)
    @ProtoField(number=17)
    public Boolean offline;

    public boolean equals(Object o) {
        return HotRodUserSessionEntityDelegate.entityEquals(this, o);
    }

    public int hashCode() {
        return HotRodUserSessionEntityDelegate.entityHashCode(this);
    }

    public static abstract class AbstractHotRodUserSessionEntityDelegate
    extends UpdatableHotRodEntityDelegateImpl<HotRodUserSessionEntity>
    implements MapUserSessionEntity {
        public String getId() {
            return ((HotRodUserSessionEntity)this.getHotRodEntity()).id;
        }

        public void setId(String id) {
            HotRodUserSessionEntity entity = (HotRodUserSessionEntity)this.getHotRodEntity();
            if (entity.id != null) {
                throw new IllegalStateException("Id cannot be changed");
            }
            entity.id = id;
            entity.updated = entity.updated | id != null;
        }

        public UserSessionModel.SessionPersistenceState getPersistenceState() {
            return UserSessionModel.SessionPersistenceState.PERSISTENT;
        }

        public void setPersistenceState(UserSessionModel.SessionPersistenceState persistenceState) {
            if (persistenceState != null && UserSessionModel.SessionPersistenceState.PERSISTENT != persistenceState) {
                throw new IllegalArgumentException("Transient session should not be stored in the HotRod.");
            }
        }

        @Override
        public boolean isUpdated() {
            return ((HotRodUserSessionEntity)this.getHotRodEntity()).updated || Optional.ofNullable(this.getAuthenticatedClientSessions()).orElseGet(Collections::emptySet).stream().anyMatch(UpdatableEntity::isUpdated);
        }

        @Override
        public void clearUpdatedFlag() {
            ((HotRodUserSessionEntity)this.getHotRodEntity()).updated = false;
            Optional.ofNullable(this.getAuthenticatedClientSessions()).orElseGet(Collections::emptySet).forEach(UpdatableEntity::clearUpdatedFlag);
        }

        public void clearAuthenticatedClientSessions() {
            HotRodUserSessionEntity entity = (HotRodUserSessionEntity)this.getHotRodEntity();
            entity.updated = entity.authenticatedClientSessions != null;
            entity.authenticatedClientSessions = null;
        }
    }

    @AutoProtoSchemaBuilder(includeClasses={HotRodUserSessionEntity.class, HotRodAuthenticatedClientSessionEntityReference.class}, schemaFilePath="proto/", schemaPackageName="kc", dependsOn={CommonPrimitivesProtoSchemaInitializer.class})
    public static interface HotRodUserSessionEntitySchema
    extends GeneratedSchema {
        public static final HotRodUserSessionEntitySchema INSTANCE = new HotRodUserSessionEntitySchemaImpl();
    }
}

