/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.hotRod.userSession;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.common.delegate.SimpleDelegateProvider;
import org.keycloak.models.map.storage.CrudOperations;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorage;
import org.keycloak.models.map.storage.chm.MapModelCriteriaBuilder;
import org.keycloak.models.map.storage.criteria.DefaultModelCriteria;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodAuthenticatedClientSessionEntity;
import org.keycloak.models.map.storage.hotRod.userSession.HotRodAuthenticatedClientSessionEntityDelegateProvider;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntityDelegate;
import org.keycloak.models.map.userSession.MapUserSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntityDelegate;
import org.keycloak.storage.SearchableModelField;

public class HotRodUserSessionMapStorage<K>
extends ConcurrentHashMapStorage<K, MapUserSessionEntity, UserSessionModel, CrudOperations<MapUserSessionEntity, UserSessionModel>> {
    private final ConcurrentHashMapStorage<String, MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel, CrudOperations<MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel>> clientSessionStore;

    public HotRodUserSessionMapStorage(CrudOperations<MapUserSessionEntity, UserSessionModel> map, StringKeyConverter<K> keyConverter, DeepCloner cloner, Map<SearchableModelField<? super UserSessionModel>, MapModelCriteriaBuilder.UpdatePredicatesFunc<K, MapUserSessionEntity, UserSessionModel>> fieldPredicates, ConcurrentHashMapStorage<String, MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel, CrudOperations<MapAuthenticatedClientSessionEntity, AuthenticatedClientSessionModel>> clientSessionStore) {
        super(map, keyConverter, cloner, fieldPredicates);
        this.clientSessionStore = clientSessionStore;
    }

    private MapAuthenticatedClientSessionEntity wrapClientSessionEntityToClientSessionAwareDelegate(final MapAuthenticatedClientSessionEntity d) {
        return new MapAuthenticatedClientSessionEntityDelegate((DelegateProvider)new HotRodAuthenticatedClientSessionEntityDelegateProvider(d){

            @Override
            public MapAuthenticatedClientSessionEntity loadClientSessionFromDatabase() {
                return (MapAuthenticatedClientSessionEntity)HotRodUserSessionMapStorage.this.clientSessionStore.read(d.getId());
            }
        });
    }

    private MapUserSessionEntity wrapUserSessionEntityToClientSessionAwareDelegate(final MapUserSessionEntity entity) {
        if (entity == null) {
            return null;
        }
        return new MapUserSessionEntityDelegate((DelegateProvider)new SimpleDelegateProvider((UpdatableEntity)entity)){

            private boolean filterAndRemoveNotExpired(MapAuthenticatedClientSessionEntity clientSession) {
                if (!HotRodUserSessionMapStorage.this.clientSessionStore.exists(clientSession.getId())) {
                    entity.removeAuthenticatedClientSession(clientSession.getClientId());
                    return false;
                }
                return true;
            }

            public Set<MapAuthenticatedClientSessionEntity> getAuthenticatedClientSessions() {
                Set clientSessions = super.getAuthenticatedClientSessions();
                return clientSessions == null ? null : clientSessions.stream().filter(this::filterAndRemoveNotExpired).map(x$0 -> HotRodUserSessionMapStorage.this.wrapClientSessionEntityToClientSessionAwareDelegate((MapAuthenticatedClientSessionEntity)x$0)).collect(Collectors.toSet());
            }

            public Optional<MapAuthenticatedClientSessionEntity> getAuthenticatedClientSession(String clientUUID) {
                return super.getAuthenticatedClientSession(clientUUID).filter(this::filterAndRemoveNotExpired).map(x$0 -> HotRodUserSessionMapStorage.this.wrapClientSessionEntityToClientSessionAwareDelegate((MapAuthenticatedClientSessionEntity)x$0));
            }

            public void addAuthenticatedClientSession(MapAuthenticatedClientSessionEntity clientSession) {
                super.addAuthenticatedClientSession(clientSession);
                HotRodUserSessionMapStorage.this.clientSessionStore.create((AbstractEntity)clientSession);
            }

            public Boolean removeAuthenticatedClientSession(String clientUUID) {
                Optional<MapAuthenticatedClientSessionEntity> clientSession = this.getAuthenticatedClientSession(clientUUID);
                if (!clientSession.isPresent()) {
                    return false;
                }
                return super.removeAuthenticatedClientSession(clientUUID) != false && HotRodUserSessionMapStorage.this.clientSessionStore.delete(clientSession.get().getId());
            }

            public void clearAuthenticatedClientSessions() {
                Set clientSessions = super.getAuthenticatedClientSessions();
                if (clientSessions != null) {
                    HotRodUserSessionMapStorage.this.clientSessionStore.delete(QueryParameters.withCriteria((DefaultModelCriteria)((DefaultModelCriteria)DefaultModelCriteria.criteria().compare(HotRodAuthenticatedClientSessionEntity.ID, ModelCriteriaBuilder.Operator.IN, new Object[]{clientSessions.stream().map(AbstractEntity::getId)}))));
                }
                super.clearAuthenticatedClientSessions();
            }
        };
    }

    public MapUserSessionEntity read(String sKey) {
        return this.wrapUserSessionEntityToClientSessionAwareDelegate((MapUserSessionEntity)super.read(sKey));
    }

    public Stream<MapUserSessionEntity> read(QueryParameters<UserSessionModel> queryParameters) {
        return super.read(queryParameters).map(this::wrapUserSessionEntityToClientSessionAwareDelegate);
    }

    public MapUserSessionEntity create(MapUserSessionEntity value) {
        return this.wrapUserSessionEntityToClientSessionAwareDelegate((MapUserSessionEntity)super.create((AbstractEntity)value));
    }

    public boolean delete(String key) {
        MapUserSessionEntity uSession = this.read(key);
        Set clientSessions = uSession.getAuthenticatedClientSessions();
        if (clientSessions != null) {
            this.clientSessionStore.delete(QueryParameters.withCriteria((DefaultModelCriteria)((DefaultModelCriteria)DefaultModelCriteria.criteria().compare(HotRodAuthenticatedClientSessionEntity.ID, ModelCriteriaBuilder.Operator.IN, new Object[]{clientSessions.stream().map(AbstractEntity::getId)}))));
        }
        return super.delete(key);
    }

    public long delete(QueryParameters<UserSessionModel> queryParameters) {
        this.clientSessionStore.delete(QueryParameters.withCriteria((DefaultModelCriteria)((DefaultModelCriteria)DefaultModelCriteria.criteria().compare(HotRodAuthenticatedClientSessionEntity.ID, ModelCriteriaBuilder.Operator.IN, new Object[]{this.read(queryParameters).flatMap(userSession -> Optional.ofNullable(userSession.getAuthenticatedClientSessions()).orElse(Collections.emptySet()).stream().map(AbstractEntity::getId))}))));
        return super.delete(queryParameters);
    }
}

