/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.CompletionStageUtil;

class T4C8TTIpro
extends T4CTTIMsg {
    private static final String CLASS_NAME = T4C8TTIpro.class.getName();
    short svrCharSet;
    short svrCharSetElem;
    byte svrFlags;
    byte[] proSvrStr;
    short proSvrVer;
    short oVersion = (short)-1;
    boolean svrInfoAvailable = false;
    byte[] proCliVerTTC8 = new byte[]{6, 5, 4, 3, 2, 1, 0};
    byte[] proCliStrTTC8 = new byte[]{74, 97, 118, 97, 95, 84, 84, 67, 45, 56, 46, 50, 46, 48, 0};
    short NCHAR_CHARSET = 0;
    byte[] runtimeCapabilities = null;

    T4C8TTIpro(T4CConnection _conn) throws SQLException, IOException {
        super(_conn, (byte)1);
    }

    byte[] receive() throws SQLException, IOException {
        int j;
        if (this.meg.unmarshalUB1() != 1) {
            this.connection.net().getSessionAttributes().ano.checkForAnoNegotiationFailure();
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        this.meg.proSvrVer = this.proSvrVer = this.meg.unmarshalUB1();
        switch (this.proSvrVer) {
            case 4: {
                this.oVersion = (short)7230;
                break;
            }
            case 5: {
                this.oVersion = (short)8030;
                break;
            }
            case 6: {
                this.oVersion = (short)8100;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 444).fillInStackTrace();
            }
        }
        this.meg.unmarshalUB1();
        this.proSvrStr = this.meg.unmarshalTEXT(50);
        this.oVersion = this.getOracleVersion();
        this.svrCharSet = (short)this.meg.unmarshalNativeUB2(true);
        this.svrFlags = (byte)this.meg.unmarshalUB1();
        this.svrCharSetElem = (short)this.meg.unmarshalNativeUB2(true);
        if (this.svrCharSetElem > 0) {
            this.meg.unmarshalNBytes(this.svrCharSetElem * 5);
        }
        this.svrInfoAvailable = true;
        if (this.proSvrVer < 5) {
            return null;
        }
        int fdoLength = this.meg.unmarshalNativeUB2(false);
        byte[] fdo = this.meg.unmarshalNBytes(fdoLength);
        int i = 6 + (fdo[5] & 0xFF) + (fdo[6] & 0xFF);
        this.NCHAR_CHARSET = (short)((fdo[i + 3] & 0xFF) << 8);
        this.NCHAR_CHARSET = (short)(this.NCHAR_CHARSET | (short)(fdo[i + 4] & 0xFF));
        if (this.proSvrVer < 6) {
            return null;
        }
        int len = this.meg.unmarshalUB1();
        byte[] sccap = new byte[len];
        for (j = 0; j < len; ++j) {
            sccap[j] = (byte)this.meg.unmarshalUB1();
        }
        len = this.meg.unmarshalUB1();
        if (len > 0) {
            this.runtimeCapabilities = new byte[len];
            for (j = 0; j < len; ++j) {
                this.runtimeCapabilities[j] = (byte)this.meg.unmarshalUB1();
            }
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "receive", "negotiated ttc oVersion={0}, server charset={1}", (String)null, (Throwable)null, (Object)this.oVersion, (Object)this.svrCharSet);
        return sccap;
    }

    final CompletionStage<byte[]> receiveAsync(Executor executor) {
        CompletableFuture<byte[]> receiveFuture = new CompletableFuture<byte[]>();
        this.meg.net.onWriteReady(writeError -> {
            try {
                if (writeError == null) {
                    this.meg.flush();
                    this.meg.net.onReadReady(readError -> {
                        try {
                            if (readError == null) {
                                receiveFuture.complete(this.receive());
                            } else {
                                receiveFuture.completeExceptionally((Throwable)readError);
                            }
                        }
                        catch (Throwable throwable) {
                            receiveFuture.completeExceptionally(throwable);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                writeError = CompletionStageUtil.suppress(throwable, writeError);
            }
            finally {
                if (writeError != null) {
                    receiveFuture.completeExceptionally((Throwable)writeError);
                }
            }
        });
        return receiveFuture;
    }

    short getOracleVersion() {
        return this.oVersion;
    }

    byte[] getServerRuntimeCapabilities() {
        return this.runtimeCapabilities;
    }

    short getCharacterSet() {
        return this.svrCharSet;
    }

    short getncharCHARSET() {
        return this.NCHAR_CHARSET;
    }

    byte getFlags() {
        return this.svrFlags;
    }

    void marshal() throws SQLException, IOException {
        this.marshalTTCcode();
        this.meg.marshalB1Array(this.proCliVerTTC8);
        this.meg.marshalB1Array(this.proCliStrTTC8);
    }

    void printServerInfo() {
        if (this.svrInfoAvailable) {
            int i = 0;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "printServerInfo", "Protocol version={0} oVersion ={1}", (String)null, (Throwable)null, (Object)this.proSvrVer, (Object)this.oVersion);
            StringWriter s = new StringWriter();
            s.write("Protocol string  =");
            while (i < this.proSvrStr.length) {
                s.write((char)this.proSvrStr[i++]);
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "printServerInfo", "{0}\nCharacter Set ID  = {1}\nRemote flags      = {2}\nNumber of Elements in Server's Character Set Graph = {3}", (String)null, (Throwable)null, (Object)s.toString(), (Object)this.svrCharSet, (Object)this.svrFlags, (Object)this.svrCharSetElem);
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "printServerInfo", "Server info Not Available", null, null);
        }
    }
}

