/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.authorization.resource;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.keycloak.authorization.model.Resource;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.authorization.resource.entity.JpaResourceEntity;
import org.keycloak.storage.SearchableModelField;

public class JpaResourceModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaResourceEntity, Resource, JpaResourceModelCriteriaBuilder> {
    public JpaResourceModelCriteriaBuilder() {
        super(JpaResourceModelCriteriaBuilder::new);
    }

    private JpaResourceModelCriteriaBuilder(JpaPredicateFunction<JpaResourceEntity> predicateFunc) {
        super(JpaResourceModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaResourceModelCriteriaBuilder compare(SearchableModelField<? super Resource> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == Resource.SearchableFields.ID || modelField == Resource.SearchableFields.RESOURCE_SERVER_ID) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaResourceModelCriteriaBuilder((cb, query, root) -> {
                        UUID uuid = (UUID)StringKeyConverter.UUIDKey.INSTANCE.fromStringSafe(Objects.toString(value[0], null));
                        if (uuid == null) {
                            return cb.or(new Predicate[0]);
                        }
                        return cb.equal((Expression)root.get(modelField.getName()), (Object)uuid);
                    });
                }
                if (modelField == Resource.SearchableFields.REALM_ID || modelField == Resource.SearchableFields.NAME || modelField == Resource.SearchableFields.TYPE || modelField == Resource.SearchableFields.OWNER) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaResourceModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == Resource.SearchableFields.OWNER_MANAGED_ACCESS) {
                    this.validateValue(value, modelField, op, Boolean.class);
                    return new JpaResourceModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == Resource.SearchableFields.URI) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaResourceModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.join("uris", JoinType.LEFT), value[0]));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case NE: {
                if (modelField == Resource.SearchableFields.OWNER) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaResourceModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]).not());
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case EXISTS: {
                if (modelField == Resource.SearchableFields.URI) {
                    return new JpaResourceModelCriteriaBuilder((cb, query, root) -> cb.isNotNull((Expression)root.join("uris", JoinType.LEFT)));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case ILIKE: {
                if (modelField == Resource.SearchableFields.NAME || modelField == Resource.SearchableFields.TYPE) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaResourceModelCriteriaBuilder((cb, query, root) -> cb.like(cb.lower((Expression)root.get(modelField.getName())), value[0].toString().toLowerCase()));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField == Resource.SearchableFields.ID) {
                    Set<UUID> uuids = this.getUuidsForInOperator(value, modelField);
                    if (uuids.isEmpty()) {
                        return new JpaResourceModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaResourceModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.get("id"));
                        uuids.forEach(uuid -> in.value(uuid));
                        return in;
                    });
                }
                if (modelField == Resource.SearchableFields.OWNER) {
                    Collection<? super Resource> collectionValues = this.getValuesForInOperator(value, modelField);
                    if (collectionValues.isEmpty()) {
                        return new JpaResourceModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaResourceModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.get("owner"));
                        collectionValues.forEach(owner -> {
                            if (!(owner instanceof String)) {
                                throw new CriterionNotSupportedException(modelField, op, owner + " owner is not String.");
                            }
                            in.value((Object)owner.toString());
                        });
                        return in;
                    });
                }
                if (modelField == Resource.SearchableFields.SCOPE_ID) {
                    Set<UUID> scopeUuids = this.getUuidsForInOperator(value, modelField);
                    if (scopeUuids.isEmpty()) {
                        return new JpaResourceModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaResourceModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.join("scopeIds", JoinType.LEFT));
                        scopeUuids.forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                        return in;
                    });
                }
                if (modelField == Resource.SearchableFields.URI) {
                    Collection<? super Resource> collectionValues = this.getValuesForInOperator(value, modelField);
                    if (collectionValues.isEmpty()) {
                        return new JpaResourceModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaResourceModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.join("uris", JoinType.LEFT));
                        collectionValues.forEach(uri -> {
                            if (!(uri instanceof String)) {
                                throw new CriterionNotSupportedException(modelField, op, uri + " uri is not String.");
                            }
                            in.value((Object)uri.toString());
                        });
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

