/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.hostname;

import jakarta.ws.rs.core.UriInfo;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.Resteasy;
import org.keycloak.common.util.UriUtils;
import org.keycloak.config.HostnameOptions;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.urls.HostnameProvider;
import org.keycloak.urls.HostnameProviderFactory;
import org.keycloak.urls.UrlType;
import org.keycloak.utils.StringUtil;

public final class DefaultHostnameProvider
implements HostnameProvider,
HostnameProviderFactory {
    private static final Logger LOGGER = Logger.getLogger(DefaultHostnameProvider.class);
    private static final String REALM_URI_SESSION_ATTRIBUTE = DefaultHostnameProvider.class.getName() + ".realmUrl";
    private static final int DEFAULT_HTTPS_PORT_VALUE = 443;
    private static final int RESTEASY_DEFAULT_PORT_VALUE = -1;
    private String frontEndHostName;
    private String defaultPath;
    private String defaultHttpScheme;
    private int defaultTlsPort;
    private boolean noProxy;
    private String adminHostName;
    private Boolean strictBackChannel;
    private boolean hostnameEnabled;
    private boolean strictHttps;
    private int hostnamePort;
    private URI frontEndBaseUri;
    private URI adminBaseUri;

    public String getScheme(UriInfo originalUriInfo, UrlType urlType) {
        if (UrlType.ADMIN.equals((Object)urlType)) {
            return this.fromBaseUriOrDefault(URI::getScheme, this.adminBaseUri, this.getScheme(originalUriInfo));
        }
        String scheme = this.forNonStrictBackChannel(originalUriInfo, urlType, this::getScheme, arg_0 -> ((DefaultHostnameProvider)this).getScheme(arg_0));
        if (scheme != null) {
            return scheme;
        }
        return this.fromFrontEndUrl(originalUriInfo, URI::getScheme, arg_0 -> ((DefaultHostnameProvider)this).getScheme(arg_0), this.defaultHttpScheme);
    }

    public String getHostname(UriInfo originalUriInfo, UrlType urlType) {
        if (UrlType.ADMIN.equals((Object)urlType)) {
            return this.fromBaseUriOrDefault(URI::getHost, this.adminBaseUri, this.adminHostName == null ? this.getHostname(originalUriInfo) : this.adminHostName);
        }
        String hostname = this.forNonStrictBackChannel(originalUriInfo, urlType, this::getHostname, arg_0 -> ((DefaultHostnameProvider)this).getHostname(arg_0));
        if (hostname != null) {
            return hostname;
        }
        return this.fromFrontEndUrl(originalUriInfo, URI::getHost, arg_0 -> ((DefaultHostnameProvider)this).getHostname(arg_0), this.frontEndHostName);
    }

    public String getContextPath(UriInfo originalUriInfo, UrlType urlType) {
        if (UrlType.ADMIN.equals((Object)urlType)) {
            return this.fromBaseUriOrDefault(URI::getPath, this.adminBaseUri, this.getContextPath(originalUriInfo));
        }
        String path = this.forNonStrictBackChannel(originalUriInfo, urlType, this::getContextPath, arg_0 -> ((DefaultHostnameProvider)this).getContextPath(arg_0));
        if (path != null) {
            return path;
        }
        return this.fromFrontEndUrl(originalUriInfo, URI::getPath, arg_0 -> ((DefaultHostnameProvider)this).getContextPath(arg_0), this.defaultPath);
    }

    public int getPort(UriInfo originalUriInfo, UrlType urlType) {
        if (UrlType.ADMIN.equals((Object)urlType)) {
            return this.fromBaseUriOrDefault(URI::getPort, this.adminBaseUri, this.getRequestPort(originalUriInfo));
        }
        Integer port = this.forNonStrictBackChannel(originalUriInfo, urlType, this::getPort, this::getRequestPort);
        if (port != null) {
            return port;
        }
        if (this.hostnameEnabled && !this.noProxy) {
            return this.fromBaseUriOrDefault(URI::getPort, this.frontEndBaseUri, this.hostnamePort);
        }
        return this.fromFrontEndUrl(originalUriInfo, URI::getPort, this::getPort, this.hostnamePort == -1 ? this.getPort(originalUriInfo) : this.hostnamePort);
    }

    public int getPort(UriInfo originalUriInfo) {
        return this.noProxy && this.strictHttps ? this.defaultTlsPort : this.getRequestPort(originalUriInfo);
    }

    private <T> T forNonStrictBackChannel(UriInfo originalUriInfo, UrlType urlType, BiFunction<UriInfo, UrlType, T> frontEndTypeResolver, Function<UriInfo, T> defaultResolver) {
        if (UrlType.BACKEND.equals((Object)urlType) && !this.strictBackChannel.booleanValue()) {
            if (this.isHostFromFrontEndUrl(originalUriInfo)) {
                return frontEndTypeResolver.apply(originalUriInfo, UrlType.FRONTEND);
            }
            return defaultResolver.apply(originalUriInfo);
        }
        return null;
    }

    private <T> T fromFrontEndUrl(UriInfo originalUriInfo, Function<URI, T> frontEndTypeResolver, Function<UriInfo, T> defaultResolver, T defaultValue) {
        URI frontEndUrl = this.getRealmFrontEndUrl();
        if (frontEndUrl != null) {
            return frontEndTypeResolver.apply(frontEndUrl);
        }
        if (this.frontEndBaseUri != null) {
            return frontEndTypeResolver.apply(this.frontEndBaseUri);
        }
        return defaultValue == null ? defaultResolver.apply(originalUriInfo) : defaultValue;
    }

    private boolean isHostFromFrontEndUrl(UriInfo originalUriInfo) {
        String frontendUrlHost;
        String requestHost = this.getHostname(originalUriInfo);
        if (requestHost.equals(frontendUrlHost = this.getHostname(originalUriInfo, UrlType.FRONTEND))) {
            return true;
        }
        URI realmUrl = this.getRealmFrontEndUrl();
        return realmUrl != null && requestHost.equals(realmUrl.getHost());
    }

    protected URI getRealmFrontEndUrl() {
        String frontendUrl;
        KeycloakSession session = (KeycloakSession)Resteasy.getContextData(KeycloakSession.class);
        RealmModel realm = session.getContext().getRealm();
        if (realm == null) {
            return null;
        }
        String realmUriKey = realm.getId() + REALM_URI_SESSION_ATTRIBUTE;
        URI realmUrl = (URI)session.getAttribute(realmUriKey);
        if (realmUrl == null && StringUtil.isNotBlank((String)(frontendUrl = realm.getAttribute("frontendUrl")))) {
            try {
                UriUtils.checkUrl((SslRequired)SslRequired.NONE, (String)frontendUrl, (String)"frontendUrl");
                realmUrl = URI.create(frontendUrl);
                session.setAttribute(realmUriKey, (Object)realmUrl);
                return realmUrl;
            }
            catch (IllegalArgumentException e) {
                LOGGER.errorf((Throwable)e, "Failed to parse realm frontendUrl '%s'. Falling back to global value.", (Object)frontendUrl);
            }
        }
        return realmUrl;
    }

    public void close() {
    }

    public String getId() {
        return "default";
    }

    public HostnameProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
        String url;
        this.frontEndHostName = config.get("hostname");
        try {
            url = config.get("hostname-url");
            if (url != null) {
                this.frontEndBaseUri = new URL(url).toURI();
            }
        }
        catch (MalformedURLException | URISyntaxException cause) {
            throw new RuntimeException("Invalid base URL for FrontEnd URLs: " + config.get("hostname-url"), cause);
        }
        if (this.frontEndHostName != null && this.frontEndBaseUri != null) {
            throw new RuntimeException("You can not set both '" + HostnameOptions.HOSTNAME.getKey() + "' and '" + HostnameOptions.HOSTNAME_URL.getKey() + "' options");
        }
        if (config.getBoolean("strict", Boolean.valueOf(false)).booleanValue() && this.frontEndHostName == null && this.frontEndBaseUri == null) {
            throw new RuntimeException("Strict hostname resolution configured but no hostname setting provided");
        }
        boolean bl = this.hostnameEnabled = this.frontEndHostName != null || this.frontEndBaseUri != null;
        if (this.frontEndBaseUri == null) {
            this.strictHttps = this.hostnameEnabled && config.getBoolean("strict-https", Boolean.valueOf(false)) != false;
        } else {
            this.frontEndHostName = this.frontEndBaseUri.getHost();
            this.strictHttps = "https".equals(this.frontEndBaseUri.getScheme());
        }
        if (this.strictHttps) {
            this.defaultHttpScheme = "https";
        }
        this.defaultPath = config.get("path", this.frontEndBaseUri == null ? null : this.frontEndBaseUri.getPath());
        this.noProxy = Configuration.getConfigValue("kc.proxy").getValue().equals("false");
        this.defaultTlsPort = Integer.parseInt(Configuration.getConfigValue("kc.https-port").getValue());
        if (this.defaultTlsPort == 443) {
            this.defaultTlsPort = -1;
        }
        this.hostnamePort = this.frontEndBaseUri == null ? Integer.parseInt(Configuration.getConfigValue("kc.hostname-port").getValue()) : this.frontEndBaseUri.getPort();
        this.adminHostName = config.get("admin");
        try {
            url = config.get("admin-url");
            if (url != null) {
                this.adminBaseUri = new URL(url).toURI();
            }
        }
        catch (MalformedURLException | URISyntaxException cause) {
            throw new RuntimeException("Invalid base URL for Admin URLs: " + config.get("admin-url"), cause);
        }
        if (this.adminHostName != null && this.adminBaseUri != null) {
            throw new RuntimeException("You can not set both '" + HostnameOptions.HOSTNAME_ADMIN.getKey() + "' and '" + HostnameOptions.HOSTNAME_ADMIN_URL.getKey() + "' options");
        }
        if (this.adminBaseUri != null) {
            this.adminHostName = this.adminBaseUri.getHost();
        }
        this.strictBackChannel = config.getBoolean("strict-backchannel", Boolean.valueOf(false));
        Object[] objectArray = new Object[9];
        Object object = objectArray[0] = this.frontEndBaseUri == null ? "<unset>" : this.frontEndBaseUri;
        objectArray[1] = this.frontEndHostName == null ? (this.frontEndBaseUri == null ? "<request>" : this.frontEndBaseUri) : this.frontEndHostName;
        objectArray[2] = this.strictHttps;
        objectArray[3] = this.defaultPath == null ? "<request>" : ("".equals(this.defaultPath) ? "/" : this.defaultPath);
        objectArray[4] = this.strictBackChannel;
        Object object2 = objectArray[5] = this.adminBaseUri == null ? "<unset>" : this.adminBaseUri;
        objectArray[6] = this.adminHostName == null ? (this.adminBaseUri == null ? "<request>" : this.adminBaseUri) : this.adminHostName;
        objectArray[7] = String.valueOf(this.hostnamePort);
        objectArray[8] = !this.noProxy;
        LOGGER.infov("Hostname settings: Base URL: {0}, Hostname: {1}, Strict HTTPS: {2}, Path: {3}, Strict BackChannel: {4}, Admin URL: {5}, Admin: {6}, Port: {7}, Proxied: {8}", objectArray);
    }

    private int getRequestPort(UriInfo uriInfo) {
        KeycloakSession session = (KeycloakSession)Resteasy.getContextData(KeycloakSession.class);
        return session.getContext().getHttpRequest().getUri().getBaseUri().getPort();
    }

    private <T> T fromBaseUriOrDefault(Function<URI, T> resolver, URI baseUri, T defaultValue) {
        if (baseUri != null) {
            return resolver.apply(baseUri);
        }
        return defaultValue;
    }
}

