/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.runtime;

import io.quarkus.resteasy.runtime.QuarkusRestPathTemplate;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.vertx.core.http.impl.HttpServerRequestInternal;
import io.vertx.ext.web.RoutingContext;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.util.Set;

@QuarkusRestPathTemplate
@Interceptor
@Priority(value=1010)
public class QuarkusRestPathTemplateInterceptor {
    @Inject
    CurrentVertxRequest request;

    @AroundInvoke
    Object restMethodInvoke(InvocationContext context) throws Exception {
        QuarkusRestPathTemplate annotation = QuarkusRestPathTemplateInterceptor.getAnnotation(context);
        RoutingContext routingContext = null;
        try {
            routingContext = this.request.getCurrent();
        }
        catch (ContextNotActiveException contextNotActiveException) {
            // empty catch block
        }
        if (annotation != null && routingContext != null) {
            ((HttpServerRequestInternal)this.request.getCurrent().request()).context().putLocal((Object)"UrlPathTemplate", (Object)annotation.value());
        }
        return context.proceed();
    }

    static QuarkusRestPathTemplate getAnnotation(InvocationContext context) {
        Set annotations = (Set)context.getContextData().get("io.quarkus.arc.interceptorBindings");
        for (Annotation a : annotations) {
            if (!(a instanceof QuarkusRestPathTemplate)) continue;
            return (QuarkusRestPathTemplate)a;
        }
        return null;
    }
}

