/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.GroupPermissionEvaluator;
import org.keycloak.utils.GroupUtils;

public class GroupsResource {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final AdminPermissionEvaluator auth;

    public GroupsResource(KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth) {
        this.realm = realm;
        this.auth = auth;
        this.session = session;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all groups with fine grained authorisation", description="This endpoint returns a list of groups with fine grained authorisation")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=GroupRepresentation.class, type=SchemaType.ARRAY))})
    public final Stream<GroupRepresentation> listGroups(@QueryParam(value="search") @DefaultValue(value="") String search, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="10") int max, @QueryParam(value="global") @DefaultValue(value="true") boolean global, @QueryParam(value="exact") @DefaultValue(value="false") boolean exact) {
        GroupPermissionEvaluator groupsEvaluator = this.auth.groups();
        groupsEvaluator.requireList();
        Stream stream = global ? this.session.groups().searchForGroupByNameStream(this.realm, search.trim(), Boolean.valueOf(exact), Integer.valueOf(first), Integer.valueOf(max)) : this.realm.getTopLevelGroupsStream().filter(g -> g.getName().contains(search)).skip(first).limit(max);
        boolean canViewGlobal = groupsEvaluator.canView();
        return stream.filter(group -> canViewGlobal || groupsEvaluator.canView(group)).map(group -> GroupUtils.toGroupHierarchy((GroupPermissionEvaluator)groupsEvaluator, (GroupModel)group, (String)search, (boolean)exact, (boolean)"".equals(search)));
    }

    @GET
    @Path(value="/subgroup")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all sub groups with fine grained authorisation and pagination", description="This endpoint returns a list of groups with fine grained authorisation")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=GroupRepresentation.class, type=SchemaType.ARRAY))})
    public final Stream<GroupRepresentation> subgroups(@QueryParam(value="id") String groupId, @QueryParam(value="search") @DefaultValue(value="") String search, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="10") int max) {
        GroupPermissionEvaluator groupsEvaluator = this.auth.groups();
        groupsEvaluator.requireList();
        GroupModel group = this.realm.getGroupById(groupId);
        if (group == null) {
            return Stream.empty();
        }
        return group.getSubGroupsStream().filter(g -> g.getName().contains(search)).map(g -> GroupUtils.toGroupHierarchy((GroupPermissionEvaluator)groupsEvaluator, (GroupModel)g, (String)search, (boolean)false, (boolean)true)).skip(first).limit(max);
    }

    @GET
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Find a specific group with no subgroups", description="This endpoint returns a group by id with no subgroups")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=GroupRepresentation.class, type=SchemaType.OBJECT))})
    public GroupRepresentation findGroupById(@PathParam(value="id") String id) {
        GroupModel group = this.realm.getGroupById(id);
        this.auth.groups().requireView(group);
        GroupRepresentation rep = ModelToRepresentation.toRepresentation((GroupModel)group, (boolean)true);
        rep.setAccess(this.auth.groups().getAccess(group));
        return rep;
    }
}

