/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;

public class NamedQueryHelper {
    private static boolean isCacheable(Map<String, Object> hints, SessionFactoryImplementor sessionFactory) {
        return sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled() && ConfigurationHelper.getBoolean("org.hibernate.cacheable", hints, false);
    }

    private static String determineCacheRegion(Map<String, Object> hints, SessionFactoryImplementor sessionFactory) {
        assert (sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled());
        return ConfigurationHelper.getString("org.hibernate.cacheRegion", hints);
    }

    private static CacheMode determineCacheMode(Map<String, Object> hints, SessionFactoryImplementor sessionFactory) {
        assert (sessionFactory.getSessionFactoryOptions().isQueryCacheEnabled());
        Object setting = hints.get("org.hibernate.cacheMode");
        if (setting != null) {
            if (setting instanceof CacheMode) {
                return (CacheMode)((Object)setting);
            }
            CacheMode cacheMode = CacheMode.interpretExternalSetting(setting.toString());
            if (cacheMode != null) {
                return cacheMode;
            }
        }
        return CacheMode.NORMAL;
    }

    private static FlushMode determineFlushMode(Map<String, Object> hints, SessionFactoryImplementor sessionFactory) {
        Object setting = hints.get("org.hibernate.flushMode");
        if (setting != null) {
            if (setting instanceof FlushMode) {
                return (FlushMode)((Object)setting);
            }
            if (setting instanceof FlushModeType) {
                return FlushModeTypeHelper.getFlushMode((FlushModeType)setting);
            }
            FlushMode mode = FlushMode.interpretExternalSetting(setting.toString());
            if (mode != null) {
                return mode;
            }
        }
        return FlushMode.AUTO;
    }

    private static LockOptions determineLockOptions(Map<String, Object> hints, SessionFactoryImplementor sessionFactory) {
        Object lockModeSetting = hints.get("org.hibernate.lockMode");
        LockMode lockMode = lockModeSetting == null ? LockMode.NONE : (lockModeSetting instanceof LockMode ? (LockMode)((Object)lockModeSetting) : (lockModeSetting instanceof LockModeType ? LockModeTypeHelper.getLockMode((LockModeType)lockModeSetting) : LockMode.fromExternalForm(lockModeSetting.toString())));
        if (lockMode == LockMode.NONE) {
            return LockOptions.NONE;
        }
        return new LockOptions(lockMode);
    }

    private static Integer determineTimeout(Map<String, Object> hints, SessionFactoryImplementor sessionFactory) {
        return null;
    }

    public static abstract class NamedQueryDescriptorBuilder {
        private final String name;
        private final Map<String, Object> hints;
        private Boolean cacheable;
        private String cacheRegion;
        private CacheMode cacheMode;
        private FlushMode flushMode;
        private Boolean readOnly;
        private LockOptions lockOptions;
        private Integer timeout;
        private Integer fetchSize;
        private String comment;

        public NamedQueryDescriptorBuilder(String name, Map<String, Object> hints, SessionFactoryImplementor sessionFactory) {
            this.name = name;
            this.hints = hints;
            this.cacheable = NamedQueryHelper.isCacheable(hints, sessionFactory);
            this.cacheRegion = this.cacheable != false ? NamedQueryHelper.determineCacheRegion(hints, sessionFactory) : null;
            this.cacheMode = this.cacheable != false ? NamedQueryHelper.determineCacheMode(hints, sessionFactory) : null;
            this.flushMode = NamedQueryHelper.determineFlushMode(hints, sessionFactory);
            this.readOnly = ConfigurationHelper.getBoolean("org.hibernate.readOnly", hints, false);
            this.lockOptions = NamedQueryHelper.determineLockOptions(hints, sessionFactory);
            this.timeout = NamedQueryHelper.determineTimeout(hints, sessionFactory);
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Object> getHints() {
            return this.hints;
        }

        public Boolean getCacheable() {
            return this.cacheable;
        }

        public void setCacheable(Boolean cacheable) {
            this.cacheable = cacheable;
        }

        public String getCacheRegion() {
            return this.cacheRegion;
        }

        public void setCacheRegion(String cacheRegion) {
            this.cacheRegion = cacheRegion;
        }

        public CacheMode getCacheMode() {
            return this.cacheMode;
        }

        public void setCacheMode(CacheMode cacheMode) {
            this.cacheMode = cacheMode;
        }

        public FlushMode getFlushMode() {
            return this.flushMode;
        }

        public void setFlushMode(FlushMode flushMode) {
            this.flushMode = flushMode;
        }

        public Boolean getReadOnly() {
            return this.readOnly;
        }

        public void setReadOnly(Boolean readOnly) {
            this.readOnly = readOnly;
        }

        public LockOptions getLockOptions() {
            return this.lockOptions;
        }

        public void setLockOptions(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public Integer getFetchSize() {
            return this.fetchSize;
        }

        public void setFetchSize(Integer fetchSize) {
            this.fetchSize = fetchSize;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

