/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension.authenticator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class HMACGetSecretAuthenticatorInput
implements Serializable {
    private final COSEKey keyAgreement;
    private final byte[] saltEnc;
    private final byte[] saltAuth;

    @JsonCreator
    public HMACGetSecretAuthenticatorInput(@JsonProperty(value="1") @NonNull COSEKey keyAgreement, @JsonProperty(value="2") @NonNull byte[] saltEnc, @JsonProperty(value="3") @NonNull byte[] saltAuth) {
        this.keyAgreement = keyAgreement;
        this.saltEnc = ArrayUtil.clone((byte[])saltEnc);
        this.saltAuth = ArrayUtil.clone((byte[])saltAuth);
    }

    public @NonNull COSEKey getKeyAgreement() {
        return this.keyAgreement;
    }

    public @NonNull byte[] getSaltEnc() {
        return ArrayUtil.clone((byte[])this.saltEnc);
    }

    public @NonNull byte[] getSaltAuth() {
        return ArrayUtil.clone((byte[])this.saltAuth);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HMACGetSecretAuthenticatorInput that = (HMACGetSecretAuthenticatorInput)o;
        return Objects.equals(this.keyAgreement, that.keyAgreement) && Arrays.equals(this.saltEnc, that.saltEnc) && Arrays.equals(this.saltAuth, that.saltAuth);
    }

    public int hashCode() {
        int result = Objects.hash(this.keyAgreement);
        result = 31 * result + Arrays.hashCode(this.saltEnc);
        result = 31 * result + Arrays.hashCode(this.saltAuth);
        return result;
    }
}

