/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.sql.SQLException;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import oracle.jdbc.driver.OracleConfigurationCacheProvider;
import oracle.jdbc.spi.OracleConfigurationJsonPasswordProvider;
import oracle.jdbc.spi.OracleConfigurationProvider;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public abstract class OracleConfigurationJsonProvider
extends OracleConfigurationCacheProvider {
    private static final OracleJsonFactory JSON_FACTORY = new OracleJsonFactory();
    private static final Map<String, OracleConfigurationJsonPasswordProvider> passwordProviders = new HashMap<String, OracleConfigurationJsonPasswordProvider>();
    protected Map<String, String> options;

    public abstract InputStream getJson(String var1) throws SQLException;

    @Override
    public Properties getConnectionProperties(String location) throws SQLException {
        OracleConfigurationCacheProvider.CacheEntry entry = (OracleConfigurationCacheProvider.CacheEntry)this.cachedProperties.get(location);
        if (entry != null && System.currentTimeMillis() < entry.getExpiringTimeMillis()) {
            return entry.getProperties();
        }
        String[] params = location.split("\\?");
        location = params[0];
        this.options = params.length > 1 ? OracleConfigurationProvider.mapOptions(params[1]) : Collections.emptyMap();
        OracleJsonObject json = JSON_FACTORY.createJsonTextValue(this.getJson(location)).asJsonObject();
        if (this.options.containsKey("key")) {
            String key2 = this.options.get("key");
            if (!json.containsKey(key2)) {
                throw new IllegalArgumentException(key2 + " key appears in URL but is missing in JSON.");
            }
            json = ((OracleJsonValue)json.get(key2)).asJsonObject();
        }
        Properties properties = new Properties();
        if (json.containsKey("user")) {
            properties.put("user", json.getString("user"));
        }
        if (!json.containsKey("connect_descriptor")) {
            throw new SQLException("'connect_descriptor' attribute missing in JSON.");
        }
        properties.put("URL", "jdbc:oracle:thin:@" + json.getString("connect_descriptor"));
        if (json.containsKey("jdbc")) {
            OracleJsonObject jdbc = ((OracleJsonValue)json.get("jdbc")).asJsonObject();
            jdbc.forEach((key, value) -> {
                if (value.getOracleJsonType().equals((Object)OracleJsonValue.OracleJsonType.STRING)) {
                    properties.put(key, value.asJsonString().getString());
                } else {
                    properties.put(key, value.toString());
                }
            });
        }
        if (json.containsKey("password")) {
            OracleJsonObject password = ((OracleJsonValue)json.get("password")).asJsonObject();
            String passwordType = password.getString("type");
            OracleConfigurationJsonPasswordProvider provider = null;
            if (passwordProviders.containsKey(passwordType)) {
                provider = passwordProviders.get(passwordType);
            } else {
                provider = OracleConfigurationJsonPasswordProvider.find(passwordType);
                passwordProviders.put(passwordType, provider);
            }
            properties.put("password", new String(provider.getPassword(password)));
        }
        if (json.containsKey("time_to_live")) {
            this.cachedProperties.put(location, new OracleConfigurationCacheProvider.CacheEntry(properties, json.getInt("time_to_live")));
        } else {
            this.cachedProperties.put(location, new OracleConfigurationCacheProvider.CacheEntry(properties));
        }
        return properties;
    }

    static {
        passwordProviders.put("base64", new OracleConfigurationJsonPasswordProvider(){

            @Override
            public String getPasswordType() {
                return "base64";
            }

            @Override
            public char[] getPassword(OracleJsonObject password) {
                return new String(Base64.getDecoder().decode(password.getString("value"))).toCharArray();
            }
        });
    }
}

