/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.aso;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public abstract class DiffieHellman {
    public abstract byte[] getSessionKey(byte[] var1, int var2);

    public abstract byte[] getPublicKey();

    public static final DiffieHellman newInstance(byte[] base, byte[] modulus, short ebits, short mbits, boolean isFipsMode) {
        return new DHJCEWrapper(base, modulus, ebits, mbits, isFipsMode);
    }

    private static class DHJCEWrapper
    extends DiffieHellman {
        private final boolean isFipsMode;
        private BigInteger baseValue = null;
        private BigInteger modulusValue = null;
        private short exponentSizeInBits;
        private short modulusSizeInBits;
        private KeyPair keyPair;

        DHJCEWrapper(byte[] base, byte[] modulus, short ebitsSize, short mbitsSize, boolean isFipsMode) {
            this.isFipsMode = isFipsMode;
            this.baseValue = new BigInteger(1, base);
            this.modulusValue = new BigInteger(1, modulus);
            this.modulusSizeInBits = mbitsSize;
            this.exponentSizeInBits = ebitsSize;
        }

        @Override
        public byte[] getPublicKey() {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DiffieHellman");
                AlgorithmParameterSpec paramSpec = this.isFipsMode ? this.createDSAParameterSpec() : this.createDHParameterSpec();
                keyPairGenerator.initialize(paramSpec);
                this.keyPair = keyPairGenerator.generateKeyPair();
                return ((DHPublicKey)this.keyPair.getPublic()).getY().toByteArray();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public byte[] getSessionKey(byte[] pkey_data, int pkey_size) {
            try {
                DHPublicKeySpec publicKey = new DHPublicKeySpec(new BigInteger(1, pkey_data), this.modulusValue, this.baseValue);
                KeyFactory keyFactory = KeyFactory.getInstance("DiffieHellman");
                PublicKey peersPublicKey = keyFactory.generatePublic(publicKey);
                KeyAgreement keyAgreement = KeyAgreement.getInstance("DiffieHellman");
                keyAgreement.init(this.keyPair.getPrivate());
                keyAgreement.doPhase(peersPublicKey, true);
                return keyAgreement.generateSecret();
            }
            catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
                throw new RuntimeException(e);
            }
        }

        private AlgorithmParameterSpec createDHParameterSpec() {
            return new DHParameterSpec(this.modulusValue, this.baseValue, this.exponentSizeInBits);
        }

        private AlgorithmParameterSpec createDSAParameterSpec() {
            BigInteger subPrime = this.modulusValue.subtract(BigInteger.ONE).divide(BigInteger.valueOf(2L));
            return new DSAParameterSpec(this.modulusValue, subPrime, this.baseValue);
        }
    }
}

