/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import java.net.URI;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Encode;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.models.RealmModel;
import org.keycloak.services.Urls;
import org.keycloak.services.util.ResolveRelative;

public class RedirectUtils {
    private static final Logger logger = Logger.getLogger(RedirectUtils.class);

    @Deprecated
    public static String verifyRealmRedirectUri(KeycloakSession session, String redirectUri) {
        Set<String> validRedirects = RedirectUtils.getValidateRedirectUris(session);
        return RedirectUtils.verifyRedirectUri(session, null, redirectUri, validRedirects, true);
    }

    public static String verifyRedirectUri(KeycloakSession session, String redirectUri, ClientModel client) {
        return RedirectUtils.verifyRedirectUri(session, redirectUri, client, true);
    }

    public static String verifyRedirectUri(KeycloakSession session, String redirectUri, ClientModel client, boolean requireRedirectUri) {
        if (client != null) {
            return RedirectUtils.verifyRedirectUri(session, client.getRootUrl(), redirectUri, client.getRedirectUris(), requireRedirectUri);
        }
        return null;
    }

    public static Set<String> resolveValidRedirects(KeycloakSession session, String rootUrl, Set<String> validRedirects) {
        TreeSet<String> resolveValidRedirects = new TreeSet<String>((s1, s2) -> s1.length() == s2.length() ? s1.compareTo((String)s2) : (s1.length() < s2.length() ? 1 : -1));
        for (String validRedirect : validRedirects) {
            if (validRedirect.startsWith("/")) {
                validRedirect = RedirectUtils.relativeToAbsoluteURI(session, rootUrl, validRedirect);
                logger.debugv("replacing relative valid redirect with: {0}", (Object)validRedirect);
                resolveValidRedirects.add(validRedirect);
                continue;
            }
            resolveValidRedirects.add(validRedirect);
        }
        return resolveValidRedirects;
    }

    @Deprecated
    private static Set<String> getValidateRedirectUris(KeycloakSession session) {
        RealmModel realm = session.getContext().getRealm();
        return session.clients().getAllRedirectUrisOfEnabledClients(realm).entrySet().stream().filter(me -> ((ClientModel)me.getKey()).isEnabled() && "openid-connect".equals(((ClientModel)me.getKey()).getProtocol()) && !((ClientModel)me.getKey()).isBearerOnly() && (((ClientModel)me.getKey()).isStandardFlowEnabled() || ((ClientModel)me.getKey()).isImplicitFlowEnabled())).map(me -> RedirectUtils.resolveValidRedirects(session, ((ClientModel)me.getKey()).getRootUrl(), (Set)me.getValue())).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static String verifyRedirectUri(KeycloakSession session, String rootUrl, String redirectUri, Set<String> validRedirects, boolean requireRedirectUri) {
        KeycloakUriInfo uriInfo = session.getContext().getUri();
        RealmModel realm = session.getContext().getRealm();
        if (redirectUri == null) {
            if (!requireRedirectUri) {
                redirectUri = RedirectUtils.getSingleValidRedirectUri(validRedirects);
            }
            if (redirectUri == null) {
                logger.debug((Object)"No Redirect URI parameter specified");
                return null;
            }
        } else if (validRedirects.isEmpty()) {
            logger.debug((Object)"No Redirect URIs supplied");
            redirectUri = null;
        } else {
            URI originalRedirect = RedirectUtils.toUri(redirectUri);
            if (originalRedirect == null) {
                return null;
            }
            String decodedRedirectUri = RedirectUtils.decodeRedirectUri(redirectUri);
            URI decodedRedirect = RedirectUtils.toUri(decodedRedirectUri);
            if ((decodedRedirectUri = RedirectUtils.getNormalizedRedirectUri(decodedRedirect)) == null) {
                return null;
            }
            String r = decodedRedirectUri;
            Set<String> resolveValidRedirects = RedirectUtils.resolveValidRedirects(session, rootUrl, validRedirects);
            String valid = RedirectUtils.matchesRedirects(resolveValidRedirects, r, true);
            if (valid == null && (r.startsWith("http://localhost") || r.startsWith("http://127.0.0.1")) && r.indexOf(58, "http://localhost".length()) >= 0) {
                int i = r.indexOf(58, "http://localhost".length());
                StringBuilder sb = new StringBuilder();
                sb.append(r.substring(0, i));
                i = r.indexOf(47, i);
                if (i >= 0) {
                    sb.append(r.substring(i));
                }
                r = sb.toString();
                valid = RedirectUtils.matchesRedirects(resolveValidRedirects, r, true);
            }
            redirectUri = RedirectUtils.getNormalizedRedirectUri(originalRedirect);
            if (valid == null) {
                valid = RedirectUtils.matchesRedirects(resolveValidRedirects, redirectUri, false);
            }
            if (valid != null && redirectUri.startsWith("/")) {
                redirectUri = RedirectUtils.relativeToAbsoluteURI(session, rootUrl, redirectUri);
            }
            String scheme = decodedRedirect.getScheme();
            if (!(valid == null || scheme == null || valid.startsWith(scheme + ":") || "http".equalsIgnoreCase(scheme) || "https".equalsIgnoreCase(scheme))) {
                logger.debugf("Invalid URI because scheme is not allowed: %s", (Object)redirectUri);
                valid = null;
            }
            String string = redirectUri = valid != null ? redirectUri : null;
        }
        if ("urn:ietf:wg:oauth:2.0:oob".equals(redirectUri)) {
            return Urls.realmInstalledAppUrnCallback(uriInfo.getBaseUri(), realm.getName()).toString();
        }
        return redirectUri;
    }

    private static URI toUri(String redirectUri) {
        URI uri = null;
        if (redirectUri != null) {
            try {
                uri = URI.create(redirectUri);
            }
            catch (IllegalArgumentException cause) {
                logger.debug((Object)"Invalid redirect uri", (Throwable)cause);
            }
            catch (Exception cause) {
                logger.debug((Object)"Unexpected error when parsing redirect uri", (Throwable)cause);
            }
        }
        return uri;
    }

    private static String getNormalizedRedirectUri(URI uri) {
        String redirectUri = null;
        if (uri != null) {
            redirectUri = uri.normalize().toString();
            redirectUri = RedirectUtils.lowerCaseHostname(redirectUri);
        }
        return redirectUri;
    }

    private static String decodeRedirectUri(String redirectUri) {
        if (redirectUri == null) {
            return null;
        }
        int MAX_DECODING_COUNT = 5;
        try {
            KeycloakUriBuilder uriBuilder = KeycloakUriBuilder.fromUri((String)redirectUri, (boolean)false).preserveDefaultPort();
            String origQuery = uriBuilder.getQuery();
            String origFragment = uriBuilder.getFragment();
            String encodedRedirectUri = uriBuilder.replaceQuery(null).fragment(null).buildAsString(new Object[0]);
            String decodedRedirectUri = null;
            for (int i = 0; i < MAX_DECODING_COUNT; ++i) {
                decodedRedirectUri = Encode.decode((String)encodedRedirectUri);
                if (decodedRedirectUri.equals(encodedRedirectUri)) {
                    return KeycloakUriBuilder.fromUri((String)decodedRedirectUri, (boolean)false).preserveDefaultPort().replaceQuery(origQuery).fragment(origFragment).buildAsString(new Object[0]);
                }
                encodedRedirectUri = decodedRedirectUri;
            }
        }
        catch (IllegalArgumentException iae) {
            logger.debugf("Illegal redirect URI used: %s, Details: %s", (Object)redirectUri, (Object)iae.getMessage());
        }
        logger.debugf("Was not able to decode redirect URI: %s", (Object)redirectUri);
        return null;
    }

    private static String lowerCaseHostname(String redirectUri) {
        int n = redirectUri.indexOf(47, 7);
        if (n == -1) {
            return redirectUri.toLowerCase();
        }
        return redirectUri.substring(0, n).toLowerCase() + redirectUri.substring(n);
    }

    private static String relativeToAbsoluteURI(KeycloakSession session, String rootUrl, String relative) {
        if (rootUrl != null) {
            rootUrl = ResolveRelative.resolveRootUrl(session, rootUrl);
        }
        if (rootUrl == null || rootUrl.isEmpty()) {
            rootUrl = UriUtils.getOrigin((URI)session.getContext().getUri().getBaseUri());
        }
        StringBuilder sb = new StringBuilder();
        sb.append(rootUrl);
        sb.append(relative);
        return sb.toString();
    }

    private static String matchesRedirects(Set<String> validRedirects, String redirect, boolean allowWildcards) {
        logger.tracef("matchesRedirects: redirect URL to check: %s, allow wildcards: %b, Configured valid redirect URLs: %s", (Object)redirect, (Object)allowWildcards, validRedirects);
        for (String validRedirect : validRedirects) {
            if (validRedirect.endsWith("*") && !validRedirect.contains("?") && allowWildcards) {
                int length;
                String r = redirect.contains("?") ? redirect.substring(0, redirect.indexOf("?")) : redirect;
                if (r.startsWith(validRedirect = validRedirect.substring(0, length = validRedirect.length() - 1))) {
                    return validRedirect;
                }
                if (length - 1 > 0 && validRedirect.charAt(length - 1) == '/') {
                    --length;
                }
                if (!(validRedirect = validRedirect.substring(0, length)).equals(r)) continue;
                return validRedirect;
            }
            if (!validRedirect.equals(redirect)) continue;
            return validRedirect;
        }
        return null;
    }

    private static String getSingleValidRedirectUri(Collection<String> validRedirects) {
        if (validRedirects.size() != 1) {
            return null;
        }
        String validRedirect = validRedirects.iterator().next();
        return RedirectUtils.validateRedirectUriWildcard(validRedirect);
    }

    public static String validateRedirectUriWildcard(String redirectUri) {
        if (redirectUri == null) {
            return null;
        }
        int idx = redirectUri.indexOf("/*");
        if (idx > -1) {
            redirectUri = redirectUri.substring(0, idx);
        }
        return redirectUri;
    }

    private static String getFirstValidRedirectUri(Collection<String> validRedirects) {
        String redirectUri = validRedirects.stream().findFirst().orElse(null);
        return redirectUri != null ? RedirectUtils.validateRedirectUriWildcard(redirectUri) : null;
    }

    public static String getFirstValidRedirectUri(KeycloakSession session, String rootUrl, Set<String> validRedirects) {
        return RedirectUtils.getFirstValidRedirectUri(RedirectUtils.resolveValidRedirects(session, rootUrl, validRedirects));
    }
}

