/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.group.delegate;

import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.UUID;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.delegate.DelegateProvider;
import org.keycloak.models.map.group.MapGroupEntity;
import org.keycloak.models.map.group.MapGroupEntityFields;
import org.keycloak.models.map.storage.jpa.JpaDelegateProvider;
import org.keycloak.models.map.storage.jpa.group.entity.JpaGroupEntity;

public class JpaGroupDelegateProvider
extends JpaDelegateProvider<JpaGroupEntity>
implements DelegateProvider<MapGroupEntity> {
    private final EntityManager em;

    public JpaGroupDelegateProvider(JpaGroupEntity delegate, EntityManager em) {
        super(delegate);
        this.em = em;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapGroupEntity getDelegate(boolean isRead, Enum<? extends EntityField<MapGroupEntity>> field, Object ... parameters) {
        if (((JpaGroupEntity)this.getDelegate()).isMetadataInitialized()) {
            return (MapGroupEntity)this.getDelegate();
        }
        if (isRead) {
            if (!(field instanceof MapGroupEntityFields)) throw new IllegalStateException("Not a valid group field: " + field);
            switch ((MapGroupEntityFields)field) {
                case ID: 
                case REALM_ID: 
                case NAME: 
                case PARENT_ID: {
                    return (MapGroupEntity)this.getDelegate();
                }
                case ATTRIBUTES: {
                    CriteriaBuilder cb = this.em.getCriteriaBuilder();
                    CriteriaQuery query = cb.createQuery(JpaGroupEntity.class);
                    Root root = query.from(JpaGroupEntity.class);
                    root.fetch("attributes", JoinType.LEFT);
                    query.select((Selection)root).where((Expression)cb.equal((Expression)root.get("id"), (Object)UUID.fromString(((JpaGroupEntity)this.getDelegate()).getId())));
                    this.setDelegate((JpaGroupEntity)this.em.createQuery(query).getSingleResult());
                    return (MapGroupEntity)this.getDelegate();
                }
                default: {
                    this.setDelegate((JpaGroupEntity)this.em.find(JpaGroupEntity.class, (Object)UUID.fromString(((JpaGroupEntity)this.getDelegate()).getId())));
                    return (MapGroupEntity)this.getDelegate();
                }
            }
        } else {
            this.setDelegate((JpaGroupEntity)this.em.find(JpaGroupEntity.class, (Object)UUID.fromString(((JpaGroupEntity)this.getDelegate()).getId())));
        }
        return (MapGroupEntity)this.getDelegate();
    }
}

