/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common.delegate;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.common.delegate.EntityFieldDelegate;
import org.keycloak.models.map.common.delegate.LazilyInitialized;
import org.keycloak.models.map.storage.tree.TreeStorageNodeInstance;
import org.keycloak.models.map.storage.tree.TreeStorageNodePrescription;

public class PerFieldDelegateProvider<V extends AbstractEntity>
implements EntityFieldDelegate<V> {
    private final TreeStorageNodeInstance<V> node;
    private final V entity;
    private final LazilyInitialized<V> lowerEntity;
    private final Collector<Map.Entry, ?, Map<Object, Object>> ENTRY_TO_HASH_MAP_OVERRIDING_KEYS_COLLECTOR = Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, HashMap::new);

    public PerFieldDelegateProvider(TreeStorageNodeInstance<V> node, V entity, Supplier<V> fallbackProvider) {
        this.node = node;
        this.entity = entity;
        this.lowerEntity = new LazilyInitialized<V>(fallbackProvider);
    }

    public PerFieldDelegateProvider(TreeStorageNodeInstance.WithEntity nodeWithEntity, Supplier<V> fallbackProvider) {
        this(nodeWithEntity.getNode(), nodeWithEntity.getEntity(), fallbackProvider);
    }

    private V getEntityFromDescendantNode() {
        AbstractEntity res = (AbstractEntity)this.lowerEntity.get();
        Objects.requireNonNull(res, () -> "Descendant entity not found for node " + this.node);
        return (V)res;
    }

    @Override
    public <K, EF extends Enum<? extends EntityField<V>>> Object mapRemove(EF field, K key) {
        Objects.requireNonNull(key, "Key must not be null");
        boolean needsSetEntity = false;
        boolean needsSetLowerEntity = false;
        switch (this.node.isCacheFor((EntityField)((Object)field), key)) {
            case FULLY: {
                needsSetEntity = true;
                break;
            }
            case NOT_CONTAINED: {
                needsSetLowerEntity = true;
            }
        }
        switch (this.node.isPrimarySourceFor(field, key)) {
            case FULLY: {
                needsSetEntity = true;
                needsSetLowerEntity = false;
                break;
            }
            case NOT_CONTAINED: {
                needsSetLowerEntity = true;
            }
        }
        Object res = null;
        if (needsSetEntity) {
            res = ((EntityField)((Object)field)).mapRemove(this.entity, key);
        }
        if (needsSetLowerEntity) {
            res = ((EntityField)((Object)field)).mapRemove(this.getEntityFromDescendantNode(), key);
        }
        return res;
    }

    @Override
    public <K, T, EF extends Enum<? extends EntityField<V>>> void mapPut(EF field, K key, T value) {
        Objects.requireNonNull(key, "Key must not be null");
        boolean needsSetEntity = false;
        boolean needsSetLowerEntity = false;
        switch (this.node.isCacheFor((EntityField)((Object)field), key)) {
            case FULLY: {
                needsSetEntity = true;
                break;
            }
            case NOT_CONTAINED: {
                needsSetLowerEntity = true;
            }
        }
        switch (this.node.isPrimarySourceFor(field, key)) {
            case FULLY: {
                needsSetEntity = true;
                needsSetLowerEntity = false;
                break;
            }
            case NOT_CONTAINED: {
                needsSetLowerEntity = true;
            }
        }
        if (needsSetEntity) {
            ((EntityField)((Object)field)).mapPut(this.entity, key, value);
        }
        if (needsSetLowerEntity) {
            ((EntityField)((Object)field)).mapPut(this.getEntityFromDescendantNode(), key, value);
        }
    }

    @Override
    public <K, EF extends Enum<? extends EntityField<V>>> Object mapGet(EF field, K key) {
        Objects.requireNonNull(key, "Key must not be null");
        switch (this.node.isCacheFor((EntityField)((Object)field), key).max(() -> this.node.isPrimarySourceFor(field, key))) {
            case FULLY: {
                return ((EntityField)((Object)field)).mapGet(this.entity, key);
            }
            case NOT_CONTAINED: {
                return ((EntityField)((Object)field)).mapGet(this.getEntityFromDescendantNode(), key);
            }
        }
        throw new IllegalStateException("Field is not determined: " + field);
    }

    @Override
    public <T, EF extends Enum<? extends EntityField<V>>> Object collectionRemove(EF field, T value) {
        boolean needsSetEntity = false;
        boolean needsSetLowerEntity = false;
        switch (this.node.isCacheFor((EntityField)((Object)field), value)) {
            case FULLY: {
                needsSetEntity = true;
                break;
            }
            case NOT_CONTAINED: {
                needsSetLowerEntity = true;
            }
        }
        switch (this.node.isPrimarySourceFor(field, value)) {
            case FULLY: {
                needsSetEntity = true;
                needsSetLowerEntity = false;
                break;
            }
            case NOT_CONTAINED: {
                needsSetLowerEntity = true;
            }
        }
        Object res = null;
        if (needsSetEntity) {
            res = ((EntityField)((Object)field)).collectionRemove(this.entity, value);
        }
        if (needsSetLowerEntity) {
            res = ((EntityField)((Object)field)).collectionRemove(this.getEntityFromDescendantNode(), value);
        }
        return res;
    }

    @Override
    public <T, EF extends Enum<? extends EntityField<V>>> void collectionAdd(EF field, T value) {
        boolean needsSetEntity = false;
        boolean needsSetLowerEntity = false;
        switch (this.node.isCacheFor((EntityField)((Object)field), null)) {
            case FULLY: {
                needsSetEntity = true;
                break;
            }
            case NOT_CONTAINED: {
                needsSetLowerEntity = true;
            }
        }
        switch (this.node.isPrimarySourceFor(field, null)) {
            case FULLY: {
                needsSetEntity = true;
                needsSetLowerEntity = false;
                break;
            }
            case NOT_CONTAINED: {
                needsSetLowerEntity = true;
            }
        }
        if (needsSetEntity) {
            ((EntityField)((Object)field)).collectionAdd(this.entity, value);
        }
        if (needsSetLowerEntity) {
            ((EntityField)((Object)field)).collectionAdd(this.getEntityFromDescendantNode(), value);
        }
    }

    @Override
    public <EF extends Enum<? extends EntityField<V>>> Object get(EF field) {
        switch (this.node.isCacheFor((EntityField)((Object)field), null).max(() -> this.node.isPrimarySourceFor(field, null))) {
            case FULLY: {
                return ((EntityField)((Object)field)).get(this.entity);
            }
            case NOT_CONTAINED: {
                return ((EntityField)((Object)field)).get(this.getEntityFromDescendantNode());
            }
        }
        if (((EntityField)((Object)field)).getMapKeyClass() == Void.class) {
            throw new IllegalStateException("Field " + field + " expected to be a map but is " + ((EntityField)((Object)field)).getFieldClass());
        }
        Map m1 = (Map)((EntityField)((Object)field)).get(this.entity);
        Map m2 = (Map)((EntityField)((Object)field)).get(this.getEntityFromDescendantNode());
        if (m1 == null) {
            return m2 == null ? null : new HashMap(m2);
        }
        Predicate<Map.Entry> isInNode = me -> this.node.isCacheFor((EntityField)((Object)field), me.getKey()).max(() -> this.node.isPrimarySourceFor(field, me.getKey())) == TreeStorageNodePrescription.FieldContainedStatus.FULLY;
        Stream<Map.Entry> s = m1.entrySet().stream().filter(isInNode);
        if (m2 == null) {
            return s.collect(this.ENTRY_TO_HASH_MAP_OVERRIDING_KEYS_COLLECTOR);
        }
        return Stream.concat(s, m2.entrySet().stream().filter(isInNode.negate())).collect(this.ENTRY_TO_HASH_MAP_OVERRIDING_KEYS_COLLECTOR);
    }

    @Override
    public <T, EF extends Enum<? extends EntityField<V>>> void set(EF field, T value) {
        boolean needsSetEntity = false;
        boolean needsSetLowerEntity = false;
        switch (this.node.isCacheFor((EntityField)((Object)field), null)) {
            case FULLY: {
                needsSetEntity = true;
                break;
            }
            case PARTIALLY: {
                needsSetEntity = true;
                needsSetLowerEntity = true;
            }
        }
        switch (this.node.isPrimarySourceFor(field, null)) {
            case FULLY: {
                needsSetEntity = true;
                needsSetLowerEntity = false;
                break;
            }
            case PARTIALLY: {
                needsSetEntity = true;
                needsSetLowerEntity = true;
                break;
            }
            case NOT_CONTAINED: {
                needsSetLowerEntity = true;
            }
        }
        if (needsSetEntity) {
            ((EntityField)((Object)field)).set(this.entity, value);
        }
        if (needsSetLowerEntity) {
            ((EntityField)((Object)field)).set(this.getEntityFromDescendantNode(), value);
        }
    }

    @Override
    public boolean isUpdated() {
        return this.entity instanceof UpdatableEntity ? ((UpdatableEntity)this.entity).isUpdated() : false;
    }
}

