/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import io.smallrye.config.ConfigValue;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.keycloak.config.MultiOption;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.DefaultFactory;
import org.keycloak.quarkus.runtime.cli.ExecutionExceptionHandler;
import org.keycloak.quarkus.runtime.cli.Help;
import org.keycloak.quarkus.runtime.cli.HelpFactory;
import org.keycloak.quarkus.runtime.cli.PropertyMapperParameterConsumer;
import org.keycloak.quarkus.runtime.cli.ShortErrorMessageHandler;
import org.keycloak.quarkus.runtime.cli.SubCommandListRenderer;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.cli.command.Main;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.PersistedConfigSource;
import org.keycloak.quarkus.runtime.configuration.QuarkusPropertiesConfigSource;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import org.keycloak.utils.StringUtil;
import picocli.CommandLine;

public final class Picocli {
    public static final String ARG_PREFIX = "--";
    public static final String ARG_SHORT_PREFIX = "-";
    public static final String NO_PARAM_LABEL = "none";
    private static final String ARG_KEY_VALUE_SEPARATOR = "=";

    private Picocli() {
    }

    public static void parseAndRun(List<String> cliArgs) {
        CommandLine cmd = Picocli.createCommandLine(cliArgs);
        if (Environment.isRebuildCheck()) {
            int exitCode = Picocli.runReAugmentationIfNeeded(cliArgs, cmd);
            Picocli.exitOnFailure(exitCode, cmd);
            return;
        }
        int exitCode = cmd.execute(cliArgs.toArray(new String[0]));
        Picocli.exitOnFailure(exitCode, cmd);
    }

    private static void exitOnFailure(int exitCode, CommandLine cmd) {
        if (exitCode != cmd.getCommandSpec().exitCodeOnSuccess() && !Environment.isTestLaunchMode() || Environment.isRebuildCheck()) {
            System.exit(exitCode);
        }
    }

    private static int runReAugmentationIfNeeded(List<String> cliArgs, CommandLine cmd) {
        String profile;
        int exitCode = 0;
        if (Picocli.shouldSkipRebuild(cliArgs)) {
            return exitCode;
        }
        if (cliArgs.contains("start-dev") && (profile = Environment.getProfile()) == null) {
            Environment.forceDevProfile();
        }
        if (Picocli.requiresReAugmentation(Picocli.getCurrentCommandSpec(cliArgs, cmd.getCommandSpec()))) {
            exitCode = Picocli.runReAugmentation(cliArgs, cmd);
        }
        return exitCode;
    }

    private static boolean shouldSkipRebuild(List<String> cliArgs) {
        return cliArgs.contains("--help") || cliArgs.contains("-h") || cliArgs.contains("--help-all") || cliArgs.contains("show-config");
    }

    public static boolean requiresReAugmentation(CommandLine cmdCommand) {
        if (cmdCommand == null) {
            return false;
        }
        if (Picocli.hasConfigChanges(cmdCommand)) {
            return ConfigArgsConfigSource.getAllCliArgs().contains("start-dev") || !"dev".equals(Configuration.getConfig().getOptionalValue("kc.profile", String.class).orElse(null));
        }
        return Picocli.hasProviderChanges();
    }

    private static List<String> getSanitizedRuntimeCliOptions() {
        final ArrayList<String> properties = new ArrayList<String>();
        ConfigArgsConfigSource.parseConfigArgs(new BiConsumer<String, String>(){

            @Override
            public void accept(String key, String value) {
                PropertyMapper mapper = PropertyMappers.getMapper(key);
                if (mapper != null && mapper.isBuildTime()) {
                    return;
                }
                properties.add(key + Picocli.ARG_KEY_VALUE_SEPARATOR + PropertyMappers.formatValue(key, value));
            }
        });
        return properties;
    }

    private static int runReAugmentation(List<String> cliArgs, CommandLine cmd) {
        if (!Environment.isDevMode() && cmd != null) {
            cmd.getOut().println("Changes detected in configuration. Updating the server image.");
            Picocli.checkChangesInBuildOptionsDuringAutoBuild();
        }
        ArrayList<String> configArgsList = new ArrayList<String>(cliArgs);
        configArgsList.replaceAll(arg -> Picocli.replaceCommandWithBuild(Picocli.getCurrentCommandSpec(cliArgs, cmd.getCommandSpec()).getCommandName(), arg));
        configArgsList.removeIf(Picocli::isRuntimeOption);
        int exitCode = cmd.execute(configArgsList.toArray(new String[0]));
        if (!Environment.isDevMode() && exitCode == cmd.getCommandSpec().exitCodeOnSuccess()) {
            cmd.getOut().printf("Next time you run the server, just run:%n%n\t%s %s %s %s%n%n", Environment.getCommand(), Picocli.getCurrentCommandSpec(cliArgs, cmd.getCommandSpec()).getCommandName(), "--optimized", String.join((CharSequence)" ", Picocli.getSanitizedRuntimeCliOptions()));
        }
        return exitCode;
    }

    private static boolean hasProviderChanges() {
        Map persistedProps = PersistedConfigSource.getInstance().getProperties();
        Map<String, File> deployedProviders = Environment.getProviderFiles();
        if (persistedProps.isEmpty()) {
            return !deployedProviders.isEmpty();
        }
        Set providerKeys = persistedProps.keySet().stream().filter(Picocli::isProviderKey).collect(Collectors.toSet());
        if (deployedProviders.size() != providerKeys.size()) {
            return true;
        }
        for (String key : providerKeys) {
            String fileName = key.substring("kc.provider.file".length() + 1, key.lastIndexOf(46));
            if (!deployedProviders.containsKey(fileName)) {
                return true;
            }
            File file = deployedProviders.get(fileName);
            String lastModified = (String)persistedProps.get(key);
            if (lastModified.equals(String.valueOf(file.lastModified()))) continue;
            return true;
        }
        return false;
    }

    private static boolean hasConfigChanges(CommandLine cmdCommand) {
        Optional persistedConfigSource;
        Map<String, String> foundQuarkusBuildProperties;
        Optional quarkusPropertiesConfigSource;
        Optional<String> currentProfile = Optional.ofNullable(Environment.getProfile());
        Optional<String> persistedProfile = Configuration.getBuildTimeProperty("kc.profile");
        if (!persistedProfile.orElse("").equals(currentProfile.orElse(""))) {
            return true;
        }
        for (String propertyName : Configuration.getConfig().getPropertyNames()) {
            ConfigValue configValue;
            if (!PropertyMappers.isBuildTimeProperty(propertyName) || (configValue = Configuration.getConfig().getConfigValue(propertyName)) == null || configValue.getConfigSourceName() == null) continue;
            if (propertyName.startsWith("%")) {
                propertyName = propertyName.substring(propertyName.indexOf(46) + 1);
            }
            String persistedValue = Configuration.getBuildTimeProperty(propertyName).orElse("");
            String runtimeValue = Configuration.getRuntimeProperty(propertyName).orElse(null);
            if (cmdCommand.getCommand() instanceof AbstractCommand) {
                AbstractCommand abstractCommand = (AbstractCommand)cmdCommand.getCommand();
                PropertyMapper mapper = PropertyMappers.getMapper(propertyName);
                if (mapper != null && !abstractCommand.getOptionCategories().contains(mapper.getCategory())) continue;
            }
            if (runtimeValue == null && StringUtil.isNotBlank((String)persistedValue)) {
                PropertyMapper mapper = PropertyMappers.getMapper(propertyName);
                if (mapper != null && persistedValue.equals(mapper.getDefaultValue().map(Object::toString).orElse(null))) continue;
                return true;
            }
            if (persistedValue.equals(runtimeValue)) continue;
            return true;
        }
        if (QuarkusPropertiesConfigSource.getConfigurationFile() != null && (quarkusPropertiesConfigSource = Configuration.getConfig().getConfigSource("QuarkusProperties")).isPresent() && !(foundQuarkusBuildProperties = Picocli.findSupportedRawQuarkusBuildProperties(((ConfigSource)quarkusPropertiesConfigSource.get()).getProperties().entrySet())).isEmpty() && (persistedConfigSource = Configuration.getConfig().getConfigSource("PersistedConfigSource")).isPresent()) {
            for (String key : foundQuarkusBuildProperties.keySet()) {
                if (!Picocli.notContainsKey((ConfigSource)persistedConfigSource.get(), key)) continue;
                return true;
            }
            return Picocli.hasAtLeastOneChangedBuildProperty(foundQuarkusBuildProperties, ((ConfigSource)persistedConfigSource.get()).getProperties().entrySet());
        }
        return false;
    }

    private static boolean hasAtLeastOneChangedBuildProperty(Map<String, String> foundQuarkusBuildProperties, Set<Map.Entry<String, String>> persistedEntries) {
        for (Map.Entry<String, String> persistedEntry : persistedEntries) {
            if (!foundQuarkusBuildProperties.containsKey(persistedEntry.getKey())) continue;
            return Picocli.isChangedValue(foundQuarkusBuildProperties, persistedEntry);
        }
        return false;
    }

    private static boolean notContainsKey(ConfigSource persistedConfigSource, String key) {
        return !persistedConfigSource.getProperties().containsKey(key);
    }

    private static Map<String, String> findSupportedRawQuarkusBuildProperties(Set<Map.Entry<String, String>> entries) {
        Pattern buildTimePattern = Pattern.compile("^quarkus\\.datasource\\.[A-Za-z0-9\\-_]+\\.(db-kind|jdbc\\.driver|jdbc\\.transactions|jdbc\\.enable-metrics)$");
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : entries) {
            if (!buildTimePattern.matcher(entry.getKey()).matches()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static boolean isChangedValue(Map<String, String> foundQuarkusBuildProps, Map.Entry<String, String> persistedEntry) {
        return !foundQuarkusBuildProps.get(persistedEntry.getKey()).equals(persistedEntry.getValue());
    }

    private static boolean isProviderKey(String key) {
        return key.startsWith("kc.provider.file");
    }

    public static CommandLine createCommandLine(List<String> cliArgs) {
        CommandLine.Model.CommandSpec spec = CommandLine.Model.CommandSpec.forAnnotatedObject((Object)new Main(), (CommandLine.IFactory)new DefaultFactory()).name(Environment.getCommand());
        for (CommandLine subCommand : spec.subcommands().values()) {
            CommandLine.Model.CommandSpec subCommandSpec = subCommand.getCommandSpec();
            subCommandSpec.addOption(((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String[])Help.OPTION_NAMES).usageHelp(true).description(new String[]{"This help message."})).build());
        }
        Picocli.addCommandOptions(cliArgs, Picocli.getCurrentCommandSpec(cliArgs, spec));
        if (Environment.isRebuildCheck()) {
            Picocli.addCommandOptions(cliArgs, (CommandLine)spec.subcommands().get("build"));
        }
        CommandLine cmd = new CommandLine((Object)spec);
        cmd.setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new ExecutionExceptionHandler());
        cmd.setParameterExceptionHandler((CommandLine.IParameterExceptionHandler)new ShortErrorMessageHandler());
        cmd.setHelpFactory((CommandLine.IHelpFactory)new HelpFactory());
        cmd.getHelpSectionMap().put("commandList", new SubCommandListRenderer());
        cmd.setErr(new PrintWriter(System.err, true));
        return cmd;
    }

    private static void addCommandOptions(List<String> cliArgs, CommandLine command) {
        if (command != null) {
            boolean includeBuildTime = false;
            boolean includeRuntime = false;
            if (command.getCommand() instanceof AbstractCommand) {
                AbstractCommand abstractCommand = (AbstractCommand)command.getCommand();
                includeRuntime = abstractCommand.includeRuntime();
                includeBuildTime = abstractCommand.includeBuildTime();
            }
            if (!includeBuildTime && !includeRuntime) {
                return;
            }
            if (includeRuntime && !includeBuildTime && !"show-config".equals(command.getCommandName())) {
                includeBuildTime = Environment.isRebuilt() || !cliArgs.contains("--optimized");
            } else if (includeBuildTime && !includeRuntime) {
                includeRuntime = Environment.isRebuildCheck();
            }
            Picocli.addOptionsToCli(command, includeBuildTime, includeRuntime);
        }
    }

    private static CommandLine getCurrentCommandSpec(List<String> cliArgs, CommandLine.Model.CommandSpec spec) {
        for (String arg : cliArgs) {
            CommandLine command = (CommandLine)spec.subcommands().get(arg);
            if (command == null) continue;
            return command;
        }
        return null;
    }

    private static void addOptionsToCli(CommandLine commandLine, boolean includeBuildTime, boolean includeRuntime) {
        EnumMap<OptionCategory, List<PropertyMapper>> mappers = new EnumMap<OptionCategory, List<PropertyMapper>>(OptionCategory.class);
        if (includeRuntime) {
            mappers.putAll(PropertyMappers.getRuntimeMappers());
        }
        if (includeBuildTime) {
            for (Map.Entry<OptionCategory, List<PropertyMapper>> entry : PropertyMappers.getBuildTimeMappers().entrySet()) {
                ArrayList result = new ArrayList(mappers.getOrDefault(entry.getKey(), Collections.emptyList()));
                result.addAll(entry.getValue());
                mappers.put(entry.getKey(), result);
            }
        }
        Picocli.addMappedOptionsToArgGroups(commandLine, mappers);
    }

    private static void addMappedOptionsToArgGroups(CommandLine commandLine, Map<OptionCategory, List<PropertyMapper>> propertyMappers) {
        CommandLine.Model.CommandSpec cSpec = commandLine.getCommandSpec();
        for (OptionCategory category : ((AbstractCommand)commandLine.getCommand()).getOptionCategories()) {
            List<PropertyMapper> mappersInCategory = propertyMappers.get(category);
            if (mappersInCategory == null) continue;
            CommandLine.Model.ArgGroupSpec.Builder argGroupBuilder = CommandLine.Model.ArgGroupSpec.builder().heading(category.getHeading() + ":").order(category.getOrder()).validate(false);
            for (final PropertyMapper mapper : mappersInCategory) {
                String name = mapper.getCliFormat();
                String description = mapper.getDescription();
                if (description == null || cSpec.optionsMap().containsKey(name) || name.endsWith(Configuration.OPTION_PART_SEPARATOR)) continue;
                CommandLine.Model.OptionSpec.Builder optBuilder = (CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)((CommandLine.Model.OptionSpec.Builder)CommandLine.Model.OptionSpec.builder((String)name, (String[])new String[0]).description(new String[]{description})).paramLabel(mapper.getParamLabel())).completionCandidates((Iterable)new Iterable<String>(){

                    @Override
                    public Iterator<String> iterator() {
                        return mapper.getExpectedValues().iterator();
                    }
                })).parameterConsumer(PropertyMapperParameterConsumer.INSTANCE)).hidden(mapper.isHidden());
                if (mapper.getDefaultValue().isPresent()) {
                    optBuilder.defaultValue(mapper.getDefaultValue().get().toString());
                }
                if (mapper.getType() != null) {
                    optBuilder.type(mapper.getType());
                    if (mapper.getOption() instanceof MultiOption) {
                        optBuilder.auxiliaryTypes(new Class[]{((MultiOption)mapper.getOption()).getAuxiliaryType()});
                    }
                } else {
                    optBuilder.type(String.class);
                }
                argGroupBuilder.addArg((CommandLine.Model.ArgSpec)optBuilder.build());
            }
            if (argGroupBuilder.args().isEmpty()) continue;
            cSpec.addArgGroup(argGroupBuilder.build());
        }
    }

    public static void println(CommandLine cmd, String message) {
        cmd.getOut().println(message);
    }

    public static List<String> parseArgs(String[] rawArgs) {
        if (rawArgs.length == 0) {
            return List.of();
        }
        ConfigArgsConfigSource.setCliArgs(rawArgs);
        ArrayList<String> args = new ArrayList<String>(List.of(rawArgs));
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            String arg = (String)iterator.next();
            if (arg.startsWith("--spi") || arg.startsWith("-D")) {
                String next;
                iterator.remove();
                if (!arg.contains(ARG_KEY_VALUE_SEPARATOR) && !(next = (String)iterator.next()).startsWith(ARG_PREFIX)) {
                    iterator.remove();
                }
            }
            if (Environment.isRebuildCheck() || !arg.startsWith("-b") && !arg.startsWith("--auto-build")) continue;
            System.out.println("WARNING: The '--auto-build' option for 'start' command is DEPRECATED and no longer needed. When executing the 'start' command, a new server image is automatically built based on the configuration. If you want to disable this behavior and achieve an optimal startup time, use the '--optimized' option instead.");
        }
        return args;
    }

    private static String replaceCommandWithBuild(String commandName, String arg) {
        if (arg.equals(commandName)) {
            return "build";
        }
        return arg;
    }

    private static boolean isRuntimeOption(String arg) {
        if ("--auto-build".equals(arg) || "-b".equals(arg)) {
            return true;
        }
        return arg.startsWith("--import-realm");
    }

    private static void checkChangesInBuildOptionsDuringAutoBuild() {
        if (Configuration.isOptimized()) {
            List buildOptions = StreamSupport.stream(Configuration.getPropertyNames(true).spliterator(), false).sorted().map(PropertyMappers::getMapper).filter(Objects::nonNull).collect(Collectors.toList());
            if (buildOptions.isEmpty()) {
                return;
            }
            StringBuilder options = new StringBuilder();
            for (PropertyMapper mapper : buildOptions) {
                String currentValue;
                String newValue = Optional.ofNullable(Configuration.getCurrentBuiltTimeProperty(mapper.getFrom())).map(ConfigValue::getValue).orElse("<unset>");
                if (newValue.equals(currentValue = Configuration.getRawPersistedProperty(mapper.getFrom()).get())) continue;
                String name = mapper.getOption().getKey();
                options.append("\n\t- ").append(name).append(ARG_KEY_VALUE_SEPARATOR).append(currentValue).append(" > ").append(name).append(ARG_KEY_VALUE_SEPARATOR).append(newValue);
            }
            if (options.length() > 0) {
                System.out.println(CommandLine.Help.Ansi.AUTO.string("@|bold,red " + "The previous optimized build will be overridden with the following build options:" + options + "\nTo avoid that, run the 'build' command again and then start the optimized server instance using the '--optimized' flag." + "|@"));
            }
        }
    }
}

