/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4C8TTIrxh;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTTIrxd;

class T4CTTIiov
extends T4CTTIMsg {
    private static final String CLASS_NAME = T4CTTIiov.class.getName();
    T4C8TTIrxh rxh;
    T4CTTIrxd rxd;
    short bindtype = 0;
    byte[] iovector;
    int bindcnt = 0;
    int inbinds = 0;
    int outbinds = 0;
    static final byte BV_IN_V = 32;
    static final byte BV_OUT_V = 16;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CTTIiov(T4CConnection _conn, T4C8TTIrxh _rxh, T4CTTIrxd _rxd) throws SQLException, IOException {
        super(_conn, (byte)0);
        this.rxh = _rxh;
        this.rxd = _rxd;
    }

    void init() throws SQLException, IOException {
    }

    Accessor[] processRXD(Accessor[] outBindAccessors, int number_of_bind_positions, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bindIndicatorSubRange, DBConversion conversion, byte[] tmpBindsByteArray, byte[] ioVector, InputStream[][] parameterStream, OracleStatement oracleStatement, byte[] ibtBindBytes, char[] ibtBindChars, short[] ibtBindIndicators) throws SQLException, IOException {
        if (ioVector != null) {
            for (int i = 0; i < ioVector.length; ++i) {
                if ((ioVector[i] & 0x10) != 0 && (outBindAccessors == null || outBindAccessors.length <= i || outBindAccessors[i] == null)) {
                    int type;
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "processRXD", "The OUT paramter at index {0} was not registered with registerOutParamter. All the OUT paramters of a PL/SQL procedure need to be registered.", (String)null, (Throwable)null, (Object)i);
                    int subRangeOffset = bindIndicatorSubRange + 5 + 10 * i;
                    int external_type = type = bindIndicators[subRangeOffset + 0] & 0xFFFF;
                    if (type == 9) {
                        type = 1;
                    }
                    Accessor acc = oracleStatement.allocateAccessor(type, type, i, 0, (short)0, null, false);
                    acc.rowSpaceIndicator = null;
                    if (outBindAccessors == null) {
                        outBindAccessors = new Accessor[i + 1];
                        outBindAccessors[i] = acc;
                        continue;
                    }
                    if (outBindAccessors.length <= i) {
                        Accessor[] outBindAccessorsNew = new Accessor[i + 1];
                        outBindAccessorsNew[i] = acc;
                        for (int ii = 0; ii < outBindAccessors.length; ++ii) {
                            if (outBindAccessors[ii] == null) continue;
                            outBindAccessorsNew[ii] = outBindAccessors[ii];
                        }
                        outBindAccessors = outBindAccessorsNew;
                        continue;
                    }
                    outBindAccessors[i] = acc;
                    continue;
                }
                if ((ioVector[i] & 0x10) != 0 || outBindAccessors == null || i >= outBindAccessors.length || outBindAccessors[i] == null) continue;
                outBindAccessors[i].isUseLess = true;
            }
        }
        return outBindAccessors;
    }

    void unmarshalV10(int numberOfBindPositions) throws IOException, SQLException {
        this.rxh.unmarshalV10(this.rxd);
        this.bindcnt = this.rxh.numRqsts;
        this.iovector = new byte[numberOfBindPositions];
        for (int i = 0; i < this.iovector.length; ++i) {
            this.bindtype = this.meg.unmarshalUB1();
            if (this.bindtype == 0) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalV10", "bindtype == 0", null, null);
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalV10", "bindtype = {0}", (String)null, (Throwable)null, (Object)this.bindtype);
            if ((this.bindtype & 0x20) > 0) {
                int n = i;
                this.iovector[n] = (byte)(this.iovector[n] | 0x20);
                ++this.inbinds;
            }
            if ((this.bindtype & 0x10) <= 0) continue;
            int n = i;
            this.iovector[n] = (byte)(this.iovector[n] | 0x10);
            ++this.outbinds;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalV10", "inbinds = {0}", (String)null, (Throwable)null, (Object)this.inbinds);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalV10", "outbinds = {0}", (String)null, (Throwable)null, (Object)this.outbinds);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "unmarshalV10", "return", null, null);
    }

    byte[] getIOVector() {
        return this.iovector;
    }

    boolean isIOVectorEmpty() {
        return this.iovector.length == 0;
    }
}

