/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.group;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Predicate;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.keycloak.models.GroupModel;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.group.entity.JpaGroupEntity;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;
import org.keycloak.storage.SearchableModelField;

public class JpaGroupModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaGroupEntity, GroupModel, JpaGroupModelCriteriaBuilder> {
    public JpaGroupModelCriteriaBuilder() {
        super(JpaGroupModelCriteriaBuilder::new);
    }

    private JpaGroupModelCriteriaBuilder(JpaPredicateFunction<JpaGroupEntity> predicateFunc) {
        super(JpaGroupModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaGroupModelCriteriaBuilder compare(SearchableModelField<? super GroupModel> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == GroupModel.SearchableFields.REALM_ID || modelField == GroupModel.SearchableFields.NAME) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaGroupModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == GroupModel.SearchableFields.PARENT_ID) {
                    if (value.length == 1 && Objects.isNull(value[0])) {
                        return new JpaGroupModelCriteriaBuilder((cb, query, root) -> cb.isNull((Expression)root.get("parentId")));
                    }
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaGroupModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get("parentId"), value[0]));
                }
                if (modelField == GroupModel.SearchableFields.ASSIGNED_ROLE) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaGroupModelCriteriaBuilder((cb, query, root) -> cb.isTrue(cb.function("@>", Boolean.TYPE, new Expression[]{cb.function("->", JsonbType.class, new Expression[]{root.get("metadata"), cb.literal((Object)"fGrantedRoles")}), cb.literal((Object)this.convertToJson(value[0]))})));
                }
                if (modelField == GroupModel.SearchableFields.ATTRIBUTE) {
                    this.validateValue(value, modelField, op, String.class, String.class);
                    return new JpaGroupModelCriteriaBuilder((cb, query, root) -> {
                        Join join = root.join("attributes", JoinType.LEFT);
                        return cb.and(new Predicate[]{cb.equal((Expression)join.get("name"), value[0]), this.hashExpression(cb, join, "value_hash", value[1]), cb.equal((Expression)join.get("value"), value[1])});
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField == GroupModel.SearchableFields.ID) {
                    Set<UUID> uuids = this.getUuidsForInOperator(value, modelField);
                    if (uuids.isEmpty()) {
                        return new JpaGroupModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaGroupModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.get("id"));
                        uuids.forEach(uuid -> in.value(uuid));
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case ILIKE: {
                if (modelField == GroupModel.SearchableFields.NAME) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaGroupModelCriteriaBuilder((cb, query, root) -> cb.like(cb.lower((Expression)root.get(modelField.getName())), value[0].toString().toLowerCase()));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case NOT_EXISTS: {
                if (modelField == GroupModel.SearchableFields.PARENT_ID) {
                    return new JpaGroupModelCriteriaBuilder((cb, query, root) -> cb.isNull((Expression)root.get("parentId")));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

