/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.events;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import java.util.Set;
import org.infinispan.commons.marshall.Externalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.marshall.SerializeWith;
import org.keycloak.models.GroupModel;
import org.keycloak.models.cache.infinispan.RealmCacheManager;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;

@SerializeWith(value=ExternalizerImpl.class)
public class GroupRemovedEvent
extends InvalidationEvent
implements RealmCacheInvalidationEvent {
    private String groupId;
    private String parentId;
    private String realmId;

    public static GroupRemovedEvent create(GroupModel group, String realmId) {
        GroupRemovedEvent event = new GroupRemovedEvent();
        event.realmId = realmId;
        event.groupId = group.getId();
        event.parentId = group.getParentId();
        return event;
    }

    @Override
    public String getId() {
        return this.groupId;
    }

    public String toString() {
        return String.format("GroupRemovedEvent [ realmId=%s, groupId=%s, parentId=%s ]", this.realmId, this.groupId, this.parentId);
    }

    @Override
    public void addInvalidations(RealmCacheManager realmCache, Set<String> invalidations) {
        realmCache.groupQueriesInvalidations(this.realmId, invalidations);
        realmCache.groupNameInvalidations(this.groupId, invalidations);
        if (this.parentId != null) {
            invalidations.add(this.parentId);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GroupRemovedEvent that = (GroupRemovedEvent)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.parentId, that.parentId) && Objects.equals(this.realmId, that.realmId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.groupId, this.parentId, this.realmId);
    }

    public static class ExternalizerImpl
    implements Externalizer<GroupRemovedEvent> {
        private static final int VERSION_1 = 1;

        public void writeObject(ObjectOutput output, GroupRemovedEvent obj) throws IOException {
            output.writeByte(1);
            MarshallUtil.marshallString((String)obj.realmId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.groupId, (ObjectOutput)output);
            MarshallUtil.marshallString((String)obj.parentId, (ObjectOutput)output);
        }

        public GroupRemovedEvent readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            switch (input.readByte()) {
                case 1: {
                    return this.readObjectVersion1(input);
                }
            }
            throw new IOException("Unknown version");
        }

        public GroupRemovedEvent readObjectVersion1(ObjectInput input) throws IOException, ClassNotFoundException {
            GroupRemovedEvent res = new GroupRemovedEvent();
            res.realmId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.groupId = MarshallUtil.unmarshallString((ObjectInput)input);
            res.parentId = MarshallUtil.unmarshallString((ObjectInput)input);
            return res;
        }
    }
}

