/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.deployment;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.undertow.deployment.GeneratedWebResourceBuildItem;
import io.quarkus.undertow.deployment.KnownPathsBuildItem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UndertowStaticResourcesBuildStep {
    protected static final String META_INF_RESOURCES_SLASH = "META-INF/resources/";
    protected static final String META_INF_RESOURCES = "META-INF/resources";

    @BuildStep
    void handleGeneratedWebResources(Capabilities capabilities, BuildProducer<GeneratedResourceBuildItem> generatedResources, List<GeneratedWebResourceBuildItem> generatedWebResources) throws Exception {
        if (!capabilities.isPresent("io.quarkus.servlet")) {
            return;
        }
        for (GeneratedWebResourceBuildItem genResource : generatedWebResources) {
            generatedResources.produce((BuildItem)new GeneratedResourceBuildItem(META_INF_RESOURCES_SLASH + genResource.getName(), genResource.getClassData()));
        }
    }

    @BuildStep
    void scanStaticResources(Capabilities capabilities, ApplicationArchivesBuildItem applicationArchivesBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResources, BuildProducer<KnownPathsBuildItem> knownPathsBuilds, List<GeneratedWebResourceBuildItem> generatedWebResources, LaunchModeBuildItem launchModeBuildItem) throws Exception {
        if (!capabilities.isPresent("io.quarkus.servlet")) {
            return;
        }
        HashSet<String> knownFiles = new HashSet<String>();
        HashSet<String> knownDirectories = new HashSet<String>();
        for (ApplicationArchive i : applicationArchivesBuildItem.getAllApplicationArchives()) {
            i.accept(tree -> {
                Path resource = tree.getPath(META_INF_RESOURCES);
                if (resource != null && Files.exists(resource, new LinkOption[0])) {
                    this.collectKnownPaths(resource, knownFiles, knownDirectories);
                }
            });
        }
        for (ClassPathElement e : QuarkusClassLoader.getElements((String)META_INF_RESOURCES, (boolean)false)) {
            if (!e.isRuntime()) continue;
            e.apply(tree -> {
                this.collectKnownPaths(tree.getPath(META_INF_RESOURCES), knownFiles, knownDirectories);
                return null;
            });
        }
        for (GeneratedWebResourceBuildItem genResource : generatedWebResources) {
            String sub = genResource.getName();
            if (sub.startsWith("/")) {
                sub = sub.substring(1);
            }
            if (sub.isEmpty()) continue;
            knownFiles.add(sub);
            for (int i = 0; i < sub.length(); ++i) {
                if (sub.charAt(i) != '/') continue;
                knownDirectories.add(sub.substring(0, i));
            }
        }
        if (launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            knownPathsBuilds.produce((BuildItem)new KnownPathsBuildItem(Collections.emptySet(), Collections.emptySet()));
        } else {
            knownPathsBuilds.produce((BuildItem)new KnownPathsBuildItem(knownFiles, knownDirectories));
        }
    }

    private void collectKnownPaths(final Path resource, final Set<String> knownFiles, final Set<String> knownDirectories) {
        try {
            Files.walkFileTree(resource, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    knownFiles.add(resource.relativize(file).toString());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path file, BasicFileAttributes attrs) throws IOException {
                    knownDirectories.add(resource.relativize(file).toString());
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @BuildStep
    void nativeImageResources(Capabilities capabilities, KnownPathsBuildItem paths, BuildProducer<NativeImageResourceBuildItem> nativeImage) {
        if (!capabilities.isPresent("io.quarkus.servlet")) {
            return;
        }
        for (String i : paths.knownFiles) {
            nativeImage.produce((BuildItem)new NativeImageResourceBuildItem(new String[]{META_INF_RESOURCES_SLASH + i}));
        }
    }
}

