/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.resource.jdbc.spi.JdbcObserver;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.service.ServiceRegistry;

public class JdbcSessionContextImpl
implements JdbcSessionContext {
    private final SessionFactoryImplementor sessionFactory;
    private final StatementInspector statementInspector;
    private final PhysicalConnectionHandlingMode connectionHandlingMode;
    private final JdbcServices jdbcServices;
    private final BatchBuilder batchBuilder;
    private final transient JdbcObserver jdbcObserver;

    public JdbcSessionContextImpl(SessionFactoryImplementor sessionFactory, StatementInspector statementInspector, PhysicalConnectionHandlingMode connectionHandlingMode, JdbcServices jdbcServices, BatchBuilder batchBuilder, JdbcObserver jdbcObserver) {
        this.sessionFactory = sessionFactory;
        this.statementInspector = statementInspector;
        this.connectionHandlingMode = connectionHandlingMode;
        this.jdbcServices = jdbcServices;
        this.batchBuilder = batchBuilder;
        this.jdbcObserver = jdbcObserver;
        if (statementInspector == null) {
            throw new IllegalArgumentException("StatementInspector cannot be null");
        }
    }

    @Override
    public boolean isScrollableResultSetsEnabled() {
        return this.settings().isScrollableResultSetsEnabled();
    }

    @Override
    public boolean isGetGeneratedKeysEnabled() {
        return this.settings().isGetGeneratedKeysEnabled();
    }

    @Override
    @Deprecated
    public int getFetchSize() {
        return this.settings().getJdbcFetchSize();
    }

    @Override
    public Integer getFetchSizeOrNull() {
        return this.settings().getJdbcFetchSize();
    }

    @Override
    public JpaCompliance getJpaCompliance() {
        return this.settings().getJpaCompliance();
    }

    @Override
    public boolean isPreferUserTransaction() {
        return this.settings().isPreferUserTransaction();
    }

    @Override
    public boolean isJtaTrackByThread() {
        return this.settings().isJtaTrackByThread();
    }

    @Override
    public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
        return this.connectionHandlingMode;
    }

    @Override
    public boolean doesConnectionProviderDisableAutoCommit() {
        return this.settings().doesConnectionProviderDisableAutoCommit();
    }

    @Override
    public StatementInspector getStatementInspector() {
        return this.statementInspector;
    }

    @Override
    @Deprecated
    public JdbcObserver getObserver() {
        return this.jdbcObserver;
    }

    @Override
    @Deprecated
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    @Deprecated
    public ServiceRegistry getServiceRegistry() {
        return this.sessionFactory.getServiceRegistry();
    }

    private SessionFactoryOptions settings() {
        return this.sessionFactory.getSessionFactoryOptions();
    }

    @Override
    public JdbcServices getJdbcServices() {
        return this.jdbcServices;
    }

    @Override
    public BatchBuilder getBatchBuilder() {
        return this.batchBuilder;
    }

    @Override
    public boolean isActive() {
        return !this.sessionFactory.isClosed();
    }
}

