/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy.impl;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.utils.PairwiseSubMapperUtils;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.clientregistration.ClientRegistrationContext;
import org.keycloak.services.clientregistration.ClientRegistrationProvider;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyException;

public class TrustedHostClientRegistrationPolicy
implements ClientRegistrationPolicy {
    private static final Logger logger = Logger.getLogger(TrustedHostClientRegistrationPolicy.class);
    private final KeycloakSession session;
    private final ComponentModel componentModel;

    public TrustedHostClientRegistrationPolicy(KeycloakSession session, ComponentModel componentModel) {
        this.session = session;
        this.componentModel = componentModel;
    }

    @Override
    public void beforeRegister(ClientRegistrationContext context) throws ClientRegistrationPolicyException {
        this.verifyHost();
        this.verifyClientUrls(context);
    }

    @Override
    public void afterRegister(ClientRegistrationContext context, ClientModel clientModel) {
    }

    @Override
    public void beforeUpdate(ClientRegistrationContext context, ClientModel clientModel) throws ClientRegistrationPolicyException {
        this.verifyHost();
        this.verifyClientUrls(context);
    }

    @Override
    public void afterUpdate(ClientRegistrationContext context, ClientModel clientModel) {
    }

    @Override
    public void beforeView(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
        this.verifyHost();
    }

    @Override
    public void beforeDelete(ClientRegistrationProvider provider, ClientModel clientModel) throws ClientRegistrationPolicyException {
        this.verifyHost();
    }

    protected void verifyHost() throws ClientRegistrationPolicyException {
        boolean hostMustMatch = this.isHostMustMatch();
        if (!hostMustMatch) {
            return;
        }
        String hostAddress = this.session.getContext().getConnection().getRemoteAddr();
        logger.debugf("Verifying remote host : %s", (Object)hostAddress);
        List<String> trustedHosts = this.getTrustedHosts();
        List<String> trustedDomains = this.getTrustedDomains();
        String verifiedHost = this.verifyHostInTrustedHosts(hostAddress, trustedHosts);
        if (verifiedHost != null) {
            return;
        }
        verifiedHost = this.verifyHostInTrustedDomains(hostAddress, trustedDomains);
        if (verifiedHost != null) {
            return;
        }
        ServicesLogger.LOGGER.failedToVerifyRemoteHost(hostAddress);
        throw new ClientRegistrationPolicyException("Host not trusted.");
    }

    protected List<String> getTrustedHosts() {
        List trustedHostsConfig = this.componentModel.getConfig().getList((Object)"trusted-hosts");
        return trustedHostsConfig.stream().filter(hostname -> !hostname.startsWith("*.")).collect(Collectors.toList());
    }

    protected List<String> getTrustedDomains() {
        List trustedHostsConfig = this.componentModel.getConfig().getList((Object)"trusted-hosts");
        LinkedList<String> domains = new LinkedList<String>();
        for (String hostname : trustedHostsConfig) {
            if (!hostname.startsWith("*.")) continue;
            hostname = hostname.substring(2);
            domains.add(hostname);
        }
        return domains;
    }

    protected String verifyHostInTrustedHosts(String hostAddress, List<String> trustedHosts) {
        for (String confHostName : trustedHosts) {
            try {
                String hostIPAddress = InetAddress.getByName(confHostName).getHostAddress();
                logger.tracef("Trying host '%s' of address '%s'", (Object)confHostName, (Object)hostIPAddress);
                if (!hostIPAddress.equals(hostAddress)) continue;
                logger.debugf("Successfully verified host : %s", (Object)confHostName);
                return confHostName;
            }
            catch (UnknownHostException uhe) {
                logger.debugf((Throwable)uhe, "Unknown host from realm configuration: %s", (Object)confHostName);
            }
        }
        return null;
    }

    protected String verifyHostInTrustedDomains(String hostAddress, List<String> trustedDomains) {
        if (!trustedDomains.isEmpty()) {
            try {
                String hostname = InetAddress.getByName(hostAddress).getHostName();
                logger.debugf("Trying verify request from address '%s' of host '%s' by domains", (Object)hostAddress, (Object)hostname);
                for (String confDomain : trustedDomains) {
                    if (!hostname.endsWith(confDomain)) continue;
                    logger.debugf("Successfully verified host '%s' by trusted domain '%s'", (Object)hostname, (Object)confDomain);
                    return hostname;
                }
            }
            catch (UnknownHostException uhe) {
                logger.debugf((Throwable)uhe, "Request of address '%s' came from unknown host. Skip verification by domains", (Object)hostAddress);
            }
        }
        return null;
    }

    protected void verifyClientUrls(ClientRegistrationContext context) throws ClientRegistrationPolicyException {
        boolean redirectUriMustMatch = this.isClientUrisMustMatch();
        if (!redirectUriMustMatch) {
            return;
        }
        List<String> trustedHosts = this.getTrustedHosts();
        List<String> trustedDomains = this.getTrustedDomains();
        ClientRepresentation client = context.getClient();
        String rootUrl = client.getRootUrl();
        String baseUrl = client.getBaseUrl();
        String adminUrl = client.getAdminUrl();
        List redirectUris = client.getRedirectUris();
        baseUrl = TrustedHostClientRegistrationPolicy.relativeToAbsoluteURI(rootUrl, baseUrl);
        adminUrl = TrustedHostClientRegistrationPolicy.relativeToAbsoluteURI(rootUrl, adminUrl);
        Set<String> resolvedRedirects = PairwiseSubMapperUtils.resolveValidRedirectUris(rootUrl, redirectUris);
        if (rootUrl != null) {
            this.checkURLTrusted(rootUrl, trustedHosts, trustedDomains);
        }
        if (baseUrl != null) {
            this.checkURLTrusted(baseUrl, trustedHosts, trustedDomains);
        }
        if (adminUrl != null) {
            this.checkURLTrusted(adminUrl, trustedHosts, trustedDomains);
        }
        for (String redirect : resolvedRedirects) {
            this.checkURITrusted(redirect, trustedHosts, trustedDomains);
        }
    }

    protected void checkURLTrusted(String url, List<String> trustedHosts, List<String> trustedDomains) throws ClientRegistrationPolicyException {
        try {
            String host = new URL(url).getHost();
            if (this.checkHostTrusted(host, trustedHosts, trustedDomains)) {
                return;
            }
        }
        catch (MalformedURLException mfe) {
            logger.debugf((Throwable)mfe, "URL '%s' is malformed", (Object)url);
            throw new ClientRegistrationPolicyException("URL is malformed");
        }
        ServicesLogger.LOGGER.urlDoesntMatch(url);
        throw new ClientRegistrationPolicyException("URL doesn't match any trusted host or trusted domain");
    }

    protected void checkURITrusted(String uri, List<String> trustedHosts, List<String> trustedDomains) throws ClientRegistrationPolicyException {
        try {
            String host = new URI(uri).getHost();
            if (this.checkHostTrusted(host, trustedHosts, trustedDomains)) {
                return;
            }
        }
        catch (URISyntaxException use) {
            logger.debugf((Throwable)use, "URI '%s' is malformed", (Object)uri);
            throw new ClientRegistrationPolicyException("URI is malformed");
        }
        ServicesLogger.LOGGER.uriDoesntMatch(uri);
        throw new ClientRegistrationPolicyException("URI doesn't match any trusted host or trusted domain");
    }

    private boolean checkHostTrusted(String host, List<String> trustedHosts, List<String> trustedDomains) {
        for (String trustedHost : trustedHosts) {
            if (!host.equals(trustedHost)) continue;
            return true;
        }
        for (String trustedDomain : trustedDomains) {
            if (!host.endsWith(trustedDomain)) continue;
            return true;
        }
        return false;
    }

    private static String relativeToAbsoluteURI(String rootUrl, String relative) {
        if (relative == null) {
            return null;
        }
        if (!relative.startsWith("/")) {
            return relative;
        }
        if (rootUrl == null || rootUrl.isEmpty()) {
            return null;
        }
        return rootUrl + relative;
    }

    boolean isHostMustMatch() {
        return this.parseBoolean("host-sending-registration-request-must-match");
    }

    boolean isClientUrisMustMatch() {
        return this.parseBoolean("client-uris-must-match");
    }

    private boolean parseBoolean(String propertyKey) {
        String val = (String)this.componentModel.getConfig().getFirst((Object)propertyKey);
        return val == null || Boolean.parseBoolean(val);
    }
}

