/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.vault.AbstractVaultProvider;
import org.keycloak.vault.DefaultVaultRawSecret;
import org.keycloak.vault.VaultKeyResolver;
import org.keycloak.vault.VaultNotFoundException;
import org.keycloak.vault.VaultRawSecret;

public class FilesKeystoreVaultProvider
extends AbstractVaultProvider {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final Path keystorePath;
    private final String keystorePass;
    private final String keystoreType;

    public FilesKeystoreVaultProvider(@Nonnull Path keystorePath, @Nonnull String keystorePass, @Nonnull String keystoreType, @Nonnull String realmName, @Nonnull List<VaultKeyResolver> resolvers) {
        super(realmName, resolvers);
        this.keystorePath = keystorePath;
        this.keystorePass = keystorePass;
        this.keystoreType = keystoreType;
        logger.debugf("KeystoreVaultProvider will operate in %s directory", (Object)keystorePath.toAbsolutePath());
    }

    @Override
    protected VaultRawSecret obtainSecretInternal(String alias) {
        Key key;
        try {
            if (!Files.exists(this.keystorePath.toRealPath(new LinkOption[0]), new LinkOption[0])) {
                throw new VaultNotFoundException("The keystore file for Keycloak Vault was not found");
            }
            KeyStore ks = KeyStore.getInstance(this.keystoreType);
            ks.load(Files.newInputStream(this.keystorePath.toRealPath(new LinkOption[0]), new OpenOption[0]), this.keystorePass.toCharArray());
            key = ks.getKey(alias, this.keystorePass.toCharArray());
            if (key == null) {
                logger.warnf("Cannot find secret %s in %s", (Object)alias, (Object)this.keystorePath);
                return DefaultVaultRawSecret.forBuffer(Optional.empty());
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
            throw new RuntimeException(e);
        }
        return DefaultVaultRawSecret.forBuffer(Optional.of(ByteBuffer.wrap(new String(key.getEncoded()).getBytes())));
    }

    public void close() {
    }
}

