/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.dev;

import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.LockOptions;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedQueryDefinition;
import org.hibernate.boot.spi.AbstractNamedQueryDefinition;

public class HibernateOrmDevInfo {
    private final Map<String, PersistenceUnit> persistenceUnits = Collections.synchronizedMap(new TreeMap(new PersistenceUnitUtil.PersistenceUnitNameComparator()));

    public Collection<PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnits.values();
    }

    void add(PersistenceUnit persistenceUnitInfo) {
        this.persistenceUnits.put(persistenceUnitInfo.getName(), persistenceUnitInfo);
    }

    public int getNumberOfNamedQueries() {
        return this.persistenceUnits.values().stream().map(PersistenceUnit::getAllNamedQueries).mapToInt(List::size).reduce(Integer::sum).orElse(0);
    }

    public int getNumberOfEntities() {
        return this.persistenceUnits.values().stream().map(PersistenceUnit::getManagedEntities).mapToInt(List::size).reduce(Integer::sum).orElse(0);
    }

    public static class Query {
        private final String name;
        private final String query;
        private final boolean cacheable;
        private final String lockMode;
        private final String type;

        public Query(NamedHqlQueryDefinition queryDefinition) {
            this.name = queryDefinition.getRegistrationName();
            this.query = queryDefinition.getHqlString();
            this.cacheable = Query.extractIsCacheable((NamedQueryDefinition)queryDefinition);
            this.lockMode = Query.extractLockOptions((NamedQueryDefinition)queryDefinition);
            this.type = "JPQL";
        }

        public Query(NamedNativeQueryDefinition nativeQueryDefinition) {
            this.name = nativeQueryDefinition.getRegistrationName();
            this.query = nativeQueryDefinition.getSqlQueryString();
            this.cacheable = Query.extractIsCacheable((NamedQueryDefinition)nativeQueryDefinition);
            this.lockMode = Query.extractLockOptions((NamedQueryDefinition)nativeQueryDefinition);
            this.type = "native";
        }

        public String getName() {
            return this.name;
        }

        public String getQuery() {
            return this.query;
        }

        public boolean isCacheable() {
            return this.cacheable;
        }

        public String getLockMode() {
            return this.lockMode;
        }

        public String getType() {
            return this.type;
        }

        private static boolean extractIsCacheable(NamedQueryDefinition definition) {
            AbstractNamedQueryDefinition def;
            return definition instanceof AbstractNamedQueryDefinition && (def = (AbstractNamedQueryDefinition)definition).getCacheable() == Boolean.TRUE;
        }

        private static String extractLockOptions(NamedQueryDefinition definition) {
            AbstractNamedQueryDefinition def;
            LockOptions lockOptions;
            if (definition instanceof AbstractNamedQueryDefinition && (lockOptions = (def = (AbstractNamedQueryDefinition)definition).getLockOptions()) != null && lockOptions.getLockMode() != null) {
                return lockOptions.getLockMode().name();
            }
            return "";
        }
    }

    public static class Entity {
        private final String className;
        private final String tableName;

        public Entity(String className, String tableName) {
            this.className = className;
            this.tableName = tableName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    public static class PersistenceUnit {
        private final String name;
        private final List<Entity> managedEntities;
        private final List<Query> namedQueries;
        private final List<Query> namedNativeQueries;
        private final String createDDL;
        private final String dropDDL;

        public PersistenceUnit(String name, List<Entity> managedEntities, List<Query> namedQueries, List<Query> namedNativeQueries, String createDDL, String dropDDL) {
            this.name = name;
            this.managedEntities = managedEntities;
            this.namedQueries = namedQueries;
            this.namedNativeQueries = namedNativeQueries;
            this.createDDL = createDDL;
            this.dropDDL = dropDDL;
        }

        public String getName() {
            return this.name;
        }

        public List<Entity> getManagedEntities() {
            return this.managedEntities;
        }

        public List<Query> getNamedQueries() {
            return this.namedQueries;
        }

        public List<Query> getNamedNativeQueries() {
            return this.namedNativeQueries;
        }

        public List<Query> getAllNamedQueries() {
            ArrayList<Query> allQueries = new ArrayList<Query>();
            allQueries.addAll(this.namedQueries);
            allQueries.addAll(this.namedNativeQueries);
            return allQueries;
        }

        public String getCreateDDL() {
            return this.createDDL;
        }

        public String getDropDDL() {
            return this.dropDDL;
        }
    }
}

