/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.context.Flag;
import org.infinispan.stream.CacheCollectors;
import org.infinispan.util.function.SerializableSupplier;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.Profile;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanUtil;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ModelException;
import org.keycloak.models.OfflineUserSessionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.AuthenticatedClientSessionAdapter;
import org.keycloak.models.sessions.infinispan.CacheDecorators;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionStore;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveUserSessionsEvent;
import org.keycloak.models.sessions.infinispan.events.SessionEventsSenderTransaction;
import org.keycloak.models.sessions.infinispan.remotestore.RemoteCacheInvoker;
import org.keycloak.models.sessions.infinispan.stream.Mappers;
import org.keycloak.models.sessions.infinispan.stream.SessionPredicate;
import org.keycloak.models.sessions.infinispan.stream.UserSessionPredicate;
import org.keycloak.models.sessions.infinispan.util.FuturesHelper;
import org.keycloak.models.sessions.infinispan.util.InfinispanKeyGenerator;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.utils.StreamsUtil;

public class InfinispanUserSessionProvider
implements UserSessionProvider {
    private static final Logger log = Logger.getLogger(InfinispanUserSessionProvider.class);
    protected final KeycloakSession session;
    protected final Cache<String, SessionEntityWrapper<UserSessionEntity>> sessionCache;
    protected final Cache<String, SessionEntityWrapper<UserSessionEntity>> offlineSessionCache;
    protected final Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionCache;
    protected final Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> offlineClientSessionCache;
    protected final InfinispanChangelogBasedTransaction<String, UserSessionEntity> sessionTx;
    protected final InfinispanChangelogBasedTransaction<String, UserSessionEntity> offlineSessionTx;
    protected final InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionTx;
    protected final InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> offlineClientSessionTx;
    protected final SessionEventsSenderTransaction clusterEventsSenderTx;
    protected final CrossDCLastSessionRefreshStore lastSessionRefreshStore;
    protected final CrossDCLastSessionRefreshStore offlineLastSessionRefreshStore;
    protected final PersisterLastSessionRefreshStore persisterLastSessionRefreshStore;
    protected final RemoteCacheInvoker remoteCacheInvoker;
    protected final InfinispanKeyGenerator keyGenerator;
    protected final boolean loadOfflineSessionsFromDatabase;

    public InfinispanUserSessionProvider(KeycloakSession session, RemoteCacheInvoker remoteCacheInvoker, CrossDCLastSessionRefreshStore lastSessionRefreshStore, CrossDCLastSessionRefreshStore offlineLastSessionRefreshStore, PersisterLastSessionRefreshStore persisterLastSessionRefreshStore, InfinispanKeyGenerator keyGenerator, Cache<String, SessionEntityWrapper<UserSessionEntity>> sessionCache, Cache<String, SessionEntityWrapper<UserSessionEntity>> offlineSessionCache, Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionCache, Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> offlineClientSessionCache, boolean loadOfflineSessionsFromDatabase) {
        this.session = session;
        this.sessionCache = sessionCache;
        this.clientSessionCache = clientSessionCache;
        this.offlineSessionCache = offlineSessionCache;
        this.offlineClientSessionCache = offlineClientSessionCache;
        this.sessionTx = new InfinispanChangelogBasedTransaction<String, UserSessionEntity>(session, sessionCache, remoteCacheInvoker, SessionTimeouts::getUserSessionLifespanMs, SessionTimeouts::getUserSessionMaxIdleMs);
        this.offlineSessionTx = new InfinispanChangelogBasedTransaction<String, UserSessionEntity>(session, offlineSessionCache, remoteCacheInvoker, SessionTimeouts::getOfflineSessionLifespanMs, SessionTimeouts::getOfflineSessionMaxIdleMs);
        this.clientSessionTx = new InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity>(session, clientSessionCache, remoteCacheInvoker, SessionTimeouts::getClientSessionLifespanMs, SessionTimeouts::getClientSessionMaxIdleMs);
        this.offlineClientSessionTx = new InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity>(session, offlineClientSessionCache, remoteCacheInvoker, SessionTimeouts::getOfflineClientSessionLifespanMs, SessionTimeouts::getOfflineClientSessionMaxIdleMs);
        this.clusterEventsSenderTx = new SessionEventsSenderTransaction(session);
        this.lastSessionRefreshStore = lastSessionRefreshStore;
        this.offlineLastSessionRefreshStore = offlineLastSessionRefreshStore;
        this.persisterLastSessionRefreshStore = persisterLastSessionRefreshStore;
        this.remoteCacheInvoker = remoteCacheInvoker;
        this.keyGenerator = keyGenerator;
        this.loadOfflineSessionsFromDatabase = loadOfflineSessionsFromDatabase;
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.clusterEventsSenderTx);
        session.getTransactionManager().enlistAfterCompletion(this.sessionTx);
        session.getTransactionManager().enlistAfterCompletion(this.offlineSessionTx);
        session.getTransactionManager().enlistAfterCompletion(this.clientSessionTx);
        session.getTransactionManager().enlistAfterCompletion(this.offlineClientSessionTx);
    }

    protected Cache<String, SessionEntityWrapper<UserSessionEntity>> getCache(boolean offline) {
        return offline ? this.offlineSessionCache : this.sessionCache;
    }

    protected InfinispanChangelogBasedTransaction<String, UserSessionEntity> getTransaction(boolean offline) {
        return offline ? this.offlineSessionTx : this.sessionTx;
    }

    protected Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> getClientSessionCache(boolean offline) {
        return offline ? this.offlineClientSessionCache : this.clientSessionCache;
    }

    protected InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> getClientSessionTransaction(boolean offline) {
        return offline ? this.offlineClientSessionTx : this.clientSessionTx;
    }

    protected CrossDCLastSessionRefreshStore getLastSessionRefreshStore() {
        return this.lastSessionRefreshStore;
    }

    protected CrossDCLastSessionRefreshStore getOfflineLastSessionRefreshStore() {
        return this.offlineLastSessionRefreshStore;
    }

    protected PersisterLastSessionRefreshStore getPersisterLastSessionRefreshStore() {
        return this.persisterLastSessionRefreshStore;
    }

    public KeycloakSession getKeycloakSession() {
        return this.session;
    }

    public AuthenticatedClientSessionModel createClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession) {
        UUID clientSessionId = this.keyGenerator.generateKeyUUID(this.session, this.clientSessionCache);
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity(clientSessionId);
        entity.setRealmId(realm.getId());
        entity.setClientId(client.getId());
        entity.setTimestamp(Time.currentTime());
        entity.getNotes().put("startedAt", String.valueOf(entity.getTimestamp()));
        entity.getNotes().put("userSessionStartedAt", String.valueOf(userSession.getStarted()));
        if (userSession.isRememberMe()) {
            entity.getNotes().put("userSessionRememberMe", "true");
        }
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(false);
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(false);
        AuthenticatedClientSessionAdapter adapter = new AuthenticatedClientSessionAdapter(this.session, this, entity, client, userSession, clientSessionUpdateTx, false);
        UserSessionModel.SessionPersistenceState persistenceState = userSession.getPersistenceState() != null ? userSession.getPersistenceState() : UserSessionModel.SessionPersistenceState.PERSISTENT;
        SessionUpdateTask createClientSessionTask = Tasks.addIfAbsentSync();
        clientSessionUpdateTx.addTask(clientSessionId, createClientSessionTask, entity, persistenceState);
        RegisterClientSessionTask registerClientSessionTask = new RegisterClientSessionTask(client.getId(), clientSessionId);
        userSessionUpdateTx.addTask(userSession.getId(), registerClientSessionTask);
        return adapter;
    }

    public UserSessionModel createUserSession(String id, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId, UserSessionModel.SessionPersistenceState persistenceState) {
        if (id == null) {
            id = this.keyGenerator.generateKeyString(this.session, this.sessionCache);
        }
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(id);
        this.updateSessionEntity(entity, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId);
        SessionUpdateTask createSessionTask = Tasks.addIfAbsentSync();
        this.sessionTx.addTask(id, createSessionTask, entity, persistenceState);
        UserSessionAdapter adapter = user instanceof LightweightUserAdapter ? this.wrap(realm, entity, false, user) : this.wrap(realm, entity, false);
        adapter.setPersistenceState(persistenceState);
        return adapter;
    }

    void updateSessionEntity(UserSessionEntity entity, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        entity.setRealmId(realm.getId());
        entity.setUser(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        entity.setBrokerSessionId(brokerSessionId);
        entity.setBrokerUserId(brokerUserId);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        return this.getUserSession(realm, id, false);
    }

    protected UserSessionAdapter getUserSession(RealmModel realm, String id, boolean offline) {
        UserSessionEntity userSessionEntityFromCache = this.getUserSessionEntity(realm, id, offline);
        if (userSessionEntityFromCache != null) {
            return this.wrap(realm, userSessionEntityFromCache, offline);
        }
        if (!offline) {
            return null;
        }
        UserSessionEntity userSessionEntityFromPersistenceProvider = this.getUserSessionEntityFromPersistenceProvider(realm, id, offline);
        if (userSessionEntityFromPersistenceProvider != null) {
            return this.wrap(realm, userSessionEntityFromPersistenceProvider, offline);
        }
        return null;
    }

    private UserSessionEntity getUserSessionEntityFromPersistenceProvider(RealmModel realm, String sessionId, boolean offline) {
        log.debugf("Offline user-session not found in infinispan, attempting UserSessionPersisterProvider lookup for sessionId=%s", (Object)sessionId);
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        UserSessionModel persistentUserSession = persister.loadUserSession(realm, sessionId, offline);
        if (persistentUserSession == null) {
            log.debugf("Offline user-session not found in UserSessionPersisterProvider for sessionId=%s", (Object)sessionId);
            return null;
        }
        UserSessionEntity sessionEntity = this.importUserSession(realm, offline, persistentUserSession);
        if (sessionEntity == null) {
            persister.removeUserSession(sessionId, offline);
        }
        return sessionEntity;
    }

    private UserSessionEntity getUserSessionEntityFromCacheOrImportIfNecessary(RealmModel realm, boolean offline, UserSessionModel persistentUserSession) {
        UserSessionEntity userSessionEntity = this.getUserSessionEntity(realm, persistentUserSession.getId(), offline);
        if (userSessionEntity != null) {
            return userSessionEntity;
        }
        return this.importUserSession(realm, offline, persistentUserSession);
    }

    private UserSessionEntity importUserSession(RealmModel realm, boolean offline, UserSessionModel persistentUserSession) {
        String sessionId = persistentUserSession.getId();
        log.debugf("Attempting to import user-session for sessionId=%s offline=%s", (Object)sessionId, (Object)offline);
        this.session.sessions().importUserSessions(Collections.singleton(persistentUserSession), offline);
        log.debugf("user-session imported, trying another lookup for sessionId=%s offline=%s", (Object)sessionId, (Object)offline);
        UserSessionEntity ispnUserSessionEntity = this.getUserSessionEntity(realm, sessionId, offline);
        if (ispnUserSessionEntity != null) {
            log.debugf("user-session found after import for sessionId=%s offline=%s", (Object)sessionId, (Object)offline);
            return ispnUserSessionEntity;
        }
        log.debugf("user-session could not be found after import for sessionId=%s offline=%s", (Object)sessionId, (Object)offline);
        return null;
    }

    private UserSessionEntity getUserSessionEntity(RealmModel realm, String id, boolean offline) {
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> tx = this.getTransaction(offline);
        SessionEntityWrapper<UserSessionEntity> entityWrapper = tx.get(id);
        if (entityWrapper == null) {
            return null;
        }
        UserSessionEntity entity = entityWrapper.getEntity();
        if (!entity.getRealmId().equals(realm.getId())) {
            return null;
        }
        return entity;
    }

    private Stream<UserSessionModel> getUserSessionsFromPersistenceProviderStream(RealmModel realm, UserModel user, boolean offline) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        return persister.loadUserSessionsStream(realm, user, offline, Integer.valueOf(0), null).map(persistentUserSession -> this.getUserSessionEntityFromCacheOrImportIfNecessary(realm, offline, (UserSessionModel)persistentUserSession)).filter(Objects::nonNull).map(userSessionEntity -> this.wrap(realm, (UserSessionEntity)userSessionEntity, offline));
    }

    protected Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, UserSessionPredicate predicate, boolean offline) {
        if (offline && this.loadOfflineSessionsFromDatabase) {
            UserModel user;
            UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
            if (predicate.getUserId() != null && (user = this.session.users().getUserById(realm, predicate.getUserId())) != null) {
                return persister.loadUserSessionsStream(realm, user, true, Integer.valueOf(0), null);
            }
            if (predicate.getBrokerUserId() != null) {
                String[] idpAliasSessionId = predicate.getBrokerUserId().split("\\.");
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("keycloak.session.realm.users.query.idp_alias", idpAliasSessionId[0]);
                attributes.put("keycloak.session.realm.users.query.idp_user_id", idpAliasSessionId[1]);
                UserProvider userProvider = (UserProvider)this.session.getProvider(UserProvider.class);
                UserModel userModel = userProvider.searchForUserStream(realm, attributes, Integer.valueOf(0), null).findFirst().orElse(null);
                return userModel != null ? persister.loadUserSessionsStream(realm, userModel, true, Integer.valueOf(0), null) : Stream.empty();
            }
            if (predicate.getBrokerSessionId() != null) {
                throw new ModelException("Dynamic database lookup for offline user-sessions by broker session ID is currently only supported for preloaded sessions. Set preloadOfflineSessionsFromDatabase option to \"true\" in userSessions SPI in infinispan provider to enable the lookup.");
            }
        }
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        cache = CacheDecorators.skipCacheLoadersIfRemoteStoreIsEnabled(cache);
        return StreamSupport.stream(cache.entrySet().stream().filter((Predicate)predicate).spliterator(), false).map(Mappers.userSessionEntity()).map(entity -> this.wrap(realm, (UserSessionEntity)entity, offline)).filter(Objects::nonNull).map(Function.identity());
    }

    public AuthenticatedClientSessionAdapter getClientSession(UserSessionModel userSession, ClientModel client, String clientSessionId, boolean offline) {
        if (clientSessionId == null) {
            return null;
        }
        AuthenticatedClientSessionEntity clientSessionEntityFromCache = this.getClientSessionEntity(UUID.fromString(clientSessionId), offline);
        if (clientSessionEntityFromCache != null) {
            return this.wrap(userSession, client, clientSessionEntityFromCache, offline);
        }
        if (offline) {
            log.debugf("Offline client session is not found in cache, try to load from db, userSession [%s] clientSessionId [%s] clientId [%s]", (Object)userSession.getId(), (Object)clientSessionId, (Object)client.getClientId());
            return this.getClientSessionEntityFromPersistenceProvider(userSession, client, true);
        }
        return null;
    }

    private AuthenticatedClientSessionAdapter getClientSessionEntityFromPersistenceProvider(UserSessionModel userSession, ClientModel client, boolean offline) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        AuthenticatedClientSessionModel clientSession = persister.loadClientSession(this.session.getContext().getRealm(), client, userSession, offline);
        if (clientSession == null) {
            return null;
        }
        AuthenticatedClientSessionAdapter clientAdapter = this.importClientSession((UserSessionAdapter)userSession, clientSession, this.getTransaction(offline), this.getClientSessionTransaction(offline), offline, true);
        if (clientAdapter == null) {
            persister.removeClientSession(userSession.getId(), client.getId(), offline);
        }
        return clientAdapter;
    }

    private AuthenticatedClientSessionEntity getClientSessionEntity(UUID id, boolean offline) {
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> tx = this.getClientSessionTransaction(offline);
        SessionEntityWrapper<AuthenticatedClientSessionEntity> entityWrapper = tx.get(id);
        return entityWrapper == null ? null : entityWrapper.getEntity();
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, UserModel user) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).user(user.getId()), false);
    }

    public Stream<UserSessionModel> getUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerUserId(brokerUserId), false);
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerSessionId(brokerSessionId), false).findFirst().orElse(null);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client) {
        return this.getUserSessionsStream(realm, client, -1, -1);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults) {
        return this.getUserSessionsStream(realm, client, firstResult, maxResults, false);
    }

    protected Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults, boolean offline) {
        if (offline && this.loadOfflineSessionsFromDatabase) {
            UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
            return persister.loadUserSessionsStream(realm, client, true, firstResult, maxResults);
        }
        UserSessionPredicate predicate = UserSessionPredicate.create(realm.getId()).client(client.getId());
        return StreamsUtil.paginatedStream(this.getUserSessionsStream(realm, predicate, offline).sorted(Comparator.comparing(UserSessionModel::getLastSessionRefresh)), (Integer)firstResult, (Integer)maxResults);
    }

    public UserSessionModel getUserSessionWithPredicate(RealmModel realm, String id, boolean offline, Predicate<UserSessionModel> predicate) {
        UserSessionAdapter userSession = this.getUserSession(realm, id, offline);
        if (userSession == null) {
            return null;
        }
        if (predicate.test(userSession)) {
            log.debugf("getUserSessionWithPredicate(%s): found in local cache", (Object)id);
            return userSession;
        }
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        RemoteCache remoteCache = InfinispanUtil.getRemoteCache(cache);
        if (remoteCache != null) {
            SessionEntityWrapper remoteSessionEntityWrapper = (SessionEntityWrapper)remoteCache.get((Object)id);
            if (remoteSessionEntityWrapper != null) {
                UserSessionEntity remoteSessionEntity = (UserSessionEntity)remoteSessionEntityWrapper.getEntity();
                log.debugf("getUserSessionWithPredicate(%s): remote cache contains session entity %s", (Object)id, (Object)remoteSessionEntity);
                UserSessionAdapter remoteSessionAdapter = this.wrap(realm, remoteSessionEntity, offline);
                if (predicate.test(remoteSessionAdapter)) {
                    InfinispanChangelogBasedTransaction<String, UserSessionEntity> tx = this.getTransaction(offline);
                    SessionEntityWrapper sessionWrapper = remoteSessionEntity.mergeRemoteEntityWithLocalEntity(tx.get(id));
                    cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD, Flag.IGNORE_RETURN_VALUES}).replace((Object)id, (Object)sessionWrapper);
                    tx.reloadEntityInCurrentTransaction(realm, id, sessionWrapper);
                    return this.getUserSessionWithPredicate(realm, id, offline, predicate);
                }
                log.debugf("getUserSessionWithPredicate(%s): found, but predicate doesn't pass", (Object)id);
                return null;
            }
            log.debugf("getUserSessionWithPredicate(%s): not found", (Object)id);
            this.removeUserSession(realm, userSession);
            return null;
        }
        log.debugf("getUserSessionWithPredicate(%s): remote cache not available", (Object)id);
        return null;
    }

    public long getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, false);
    }

    public Map<String, Long> getActiveClientSessionStats(RealmModel realm, boolean offline) {
        if (offline && this.loadOfflineSessionsFromDatabase) {
            UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
            return persister.getUserSessionsCountsByClients(realm, true);
        }
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        cache = CacheDecorators.skipCacheLoadersIfRemoteStoreIsEnabled(cache);
        return (Map)cache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId())).map(Mappers.authClientSessionSetMapper()).flatMap(Mappers::toStream).collect(CacheCollectors.serializableCollector((SerializableSupplier & Serializable)() -> Collectors.groupingBy(Function.identity(), Collectors.counting())));
    }

    protected long getUserSessionsCount(RealmModel realm, ClientModel client, boolean offline) {
        if (offline && this.loadOfflineSessionsFromDatabase) {
            UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
            return persister.getUserSessionsCount(realm, client, true);
        }
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).client(client.getId()), offline).count();
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        UserSessionEntity entity = this.getUserSessionEntity(realm, session, false);
        if (entity != null) {
            this.removeUserSession(entity, false);
        }
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, false);
    }

    protected void removeUserSessions(RealmModel realm, UserModel user, boolean offline) {
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        cache = CacheDecorators.skipCacheLoadersIfRemoteStoreIsEnabled(cache);
        for (UserSessionEntity userSessionEntity : cache.entrySet().stream().filter((Predicate)UserSessionPredicate.create(realm.getId()).user(user.getId())).map(Mappers.userSessionEntity())) {
            this.removeUserSession(userSessionEntity, offline);
        }
    }

    public void removeAllExpired() {
        this.session.realms().getRealmsStream().forEach(this::removeExpired);
    }

    public void removeExpired(RealmModel realm) {
        ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).removeExpired(realm);
    }

    public void removeUserSessions(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RemoveUserSessionsEvent.createEvent(RemoveUserSessionsEvent.class, "REMOVE_USER_SESSIONS_EVENT", this.session, realm.getId(), true), ClusterProvider.DCNotify.LOCAL_DC_ONLY);
    }

    protected void onRemoveUserSessionsEvent(String realmId) {
        this.removeLocalUserSessions(realmId, false);
    }

    public void removeLocalUserSessions(String realmId, boolean offline) {
        final FuturesHelper futures = new FuturesHelper();
        Cache<String, SessionEntityWrapper<UserSessionEntity>> cache = this.getCache(offline);
        final AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCache = CacheDecorators.localCache(cache);
        Cache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionCache = this.getClientSessionCache(offline);
        final AdvancedCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> localClientSessionCache = CacheDecorators.localCache(clientSessionCache);
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCacheStoreIgnore = CacheDecorators.skipCacheLoadersIfRemoteStoreIsEnabled(localCache);
        final AtomicInteger userSessionsSize = new AtomicInteger();
        localCacheStoreIgnore.entrySet().stream().filter((Predicate)SessionPredicate.create(realmId)).map(Mappers.userSessionEntity()).forEach((Consumer)new Consumer<UserSessionEntity>(){

            @Override
            public void accept(UserSessionEntity userSessionEntity) {
                userSessionsSize.incrementAndGet();
                CompletableFuture future = localCache.removeAsync((Object)userSessionEntity.getId());
                futures.addTask(future);
                userSessionEntity.getAuthenticatedClientSessions().forEach((clientUUID, clientSessionId) -> {
                    CompletableFuture f = localClientSessionCache.removeAsync(clientSessionId);
                    futures.addTask(f);
                });
            }
        });
        futures.waitForAllToFinish();
        log.debugf("Removed %d sessions in realm %s. Offline: %b", (Object)userSessionsSize.get(), (Object)realmId, (Object)offline);
    }

    public void onRealmRemoved(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RealmRemovedSessionEvent.createEvent(RealmRemovedSessionEvent.class, "REALM_REMOVED_EVENT_SESSIONS", this.session, realm.getId(), true), ClusterProvider.DCNotify.LOCAL_DC_ONLY);
        UserSessionPersisterProvider sessionsPersister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (sessionsPersister != null) {
            sessionsPersister.onRealmRemoved(realm);
        }
    }

    protected void onRealmRemovedEvent(String realmId) {
        this.removeLocalUserSessions(realmId, true);
        this.removeLocalUserSessions(realmId, false);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        UserSessionPersisterProvider sessionsPersister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (sessionsPersister != null) {
            sessionsPersister.onClientRemoved(realm, client);
        }
    }

    protected void onClientRemovedEvent(String realmId, String clientUuid) {
    }

    protected void onUserRemoved(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, true);
        this.removeUserSessions(realm, user, false);
        UserSessionPersisterProvider persisterProvider = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (persisterProvider != null) {
            persisterProvider.onUserRemoved(realm, user);
        }
    }

    public void close() {
    }

    public int getStartupTime(RealmModel realm) {
        return ((ClusterProvider)this.session.getProvider(ClusterProvider.class)).getClusterStartupTime();
    }

    protected void removeUserSession(UserSessionEntity sessionEntity, boolean offline) {
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(offline);
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(offline);
        sessionEntity.getAuthenticatedClientSessions().forEach((clientUUID, clientSessionId) -> clientSessionUpdateTx.addTask((UUID)clientSessionId, Tasks.removeSync()));
        SessionUpdateTask removeTask = Tasks.removeSync();
        userSessionUpdateTx.addTask(sessionEntity.getId(), removeTask);
    }

    UserSessionAdapter wrap(RealmModel realm, UserSessionEntity entity, boolean offline, UserModel user) {
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(offline);
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(offline);
        if (entity == null) {
            return null;
        }
        return new UserSessionAdapter(this.session, user, this, userSessionUpdateTx, clientSessionUpdateTx, realm, entity, offline);
    }

    UserSessionAdapter wrap(RealmModel realm, UserSessionEntity entity, boolean offline) {
        UserModel user = null;
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.TRANSIENT_USERS) && entity.getNotes().containsKey("keycloak.userModel")) {
            LightweightUserAdapter lua = LightweightUserAdapter.fromString((KeycloakSession)this.session, (RealmModel)realm, (String)entity.getNotes().get("keycloak.userModel"));
            UserSessionAdapter us = this.wrap(realm, entity, offline, (UserModel)lua);
            lua.setUpdateHandler(lua1 -> {
                if (lua == lua1) {
                    us.setNote("keycloak.userModel", lua1.serialize());
                }
            });
            return us;
        }
        user = this.session.users().getUserById(realm, entity.getUser());
        if (user == null) {
            return null;
        }
        return this.wrap(realm, entity, offline, user);
    }

    AuthenticatedClientSessionAdapter wrap(UserSessionModel userSession, ClientModel client, AuthenticatedClientSessionEntity entity, boolean offline) {
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(offline);
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(offline);
        return entity != null ? new AuthenticatedClientSessionAdapter(this.session, this, entity, client, userSession, clientSessionUpdateTx, offline) : null;
    }

    UserSessionEntity getUserSessionEntity(RealmModel realm, UserSessionModel userSession, boolean offline) {
        if (userSession instanceof UserSessionAdapter) {
            if (!userSession.getRealm().equals(realm)) {
                return null;
            }
            return ((UserSessionAdapter)userSession).getEntity();
        }
        return this.getUserSessionEntity(realm, userSession.getId(), offline);
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        UserSessionAdapter offlineUserSession = this.importUserSession(userSession, true);
        int currentTime = Time.currentTime();
        offlineUserSession.getEntity().setStarted(currentTime);
        offlineUserSession.getEntity().setLastSessionRefresh(currentTime);
        ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).createUserSession(userSession, true);
        return offlineUserSession;
    }

    public UserSessionAdapter getOfflineUserSession(RealmModel realm, String userSessionId) {
        return this.getUserSession(realm, userSessionId, true);
    }

    public UserSessionModel getOfflineUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerSessionId(brokerSessionId), true).findFirst().orElse(null);
    }

    public Stream<UserSessionModel> getOfflineUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerUserId(brokerUserId), true);
    }

    public void removeOfflineUserSession(RealmModel realm, UserSessionModel userSession) {
        UserSessionEntity userSessionEntity = this.getUserSessionEntity(realm, userSession, true);
        if (userSessionEntity != null) {
            this.removeUserSession(userSessionEntity, true);
        }
        ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).removeUserSession(userSession.getId(), true);
    }

    public AuthenticatedClientSessionModel createOfflineClientSession(AuthenticatedClientSessionModel clientSession, UserSessionModel offlineUserSession) {
        UserSessionAdapter userSessionAdapter = offlineUserSession instanceof UserSessionAdapter ? (UserSessionAdapter)offlineUserSession : this.getOfflineUserSession(offlineUserSession.getRealm(), offlineUserSession.getId());
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(true);
        InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx = this.getClientSessionTransaction(true);
        AuthenticatedClientSessionAdapter offlineClientSession = this.importClientSession(userSessionAdapter, clientSession, userSessionUpdateTx, clientSessionUpdateTx, true, false);
        offlineClientSession.setTimestamp(Time.currentTime());
        offlineClientSession.getNotes().put("startedAt", String.valueOf(offlineClientSession.getTimestamp()));
        offlineClientSession.getNotes().put("userSessionStartedAt", String.valueOf(offlineUserSession.getStarted()));
        ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).createClientSession(clientSession, true);
        return offlineClientSession;
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, UserModel user) {
        if (this.loadOfflineSessionsFromDatabase) {
            return this.getUserSessionsFromPersistenceProviderStream(realm, user, true);
        }
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).user(user.getId()), true);
    }

    public long getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, true);
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, ClientModel client, Integer first, Integer max) {
        return this.getUserSessionsStream(realm, client, first, max, true);
    }

    public void importUserSessions(Collection<UserSessionModel> persistentUserSessions, boolean offline) {
        boolean importWithExpiration;
        if (persistentUserSessions == null || persistentUserSessions.isEmpty()) {
            return;
        }
        HashMap clientSessionsById = new HashMap();
        Map sessionsById = persistentUserSessions.stream().map(persistentUserSession -> {
            UserSessionEntity userSessionEntityToImport = this.createUserSessionEntityInstance((UserSessionModel)persistentUserSession);
            for (Map.Entry entry : persistentUserSession.getAuthenticatedClientSessions().entrySet()) {
                String clientUUID = (String)entry.getKey();
                AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)entry.getValue();
                AuthenticatedClientSessionEntity clientSessionToImport = this.createAuthenticatedClientSessionInstance(clientSession, userSessionEntityToImport.getRealmId(), clientUUID, offline);
                clientSessionToImport.setTimestamp(userSessionEntityToImport.getLastSessionRefresh());
                clientSessionsById.put(clientSessionToImport.getId(), new SessionEntityWrapper<AuthenticatedClientSessionEntity>(clientSessionToImport));
                AuthenticatedClientSessionStore clientSessions = userSessionEntityToImport.getAuthenticatedClientSessions();
                clientSessions.put(clientUUID, clientSessionToImport.getId());
            }
            return userSessionEntityToImport;
        }).map(SessionEntityWrapper::new).collect(Collectors.toMap(sessionEntityWrapper -> ((UserSessionEntity)sessionEntityWrapper.getEntity()).getId(), Function.identity()));
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> cache = CacheDecorators.skipCacheLoadersIfRemoteStoreIsEnabled(this.getCache(offline));
        boolean bl = importWithExpiration = sessionsById.size() == 1;
        if (importWithExpiration) {
            this.importSessionsWithExpiration(sessionsById, (BasicCache)cache, (SessionFunction)(offline ? SessionTimeouts::getOfflineSessionLifespanMs : SessionTimeouts::getUserSessionLifespanMs), (SessionFunction)(offline ? SessionTimeouts::getOfflineSessionMaxIdleMs : SessionTimeouts::getUserSessionMaxIdleMs));
        } else {
            Retry.executeWithBackoff(iteration -> cache.putAll(sessionsById), (int)10, (int)10);
        }
        RemoteCache remoteCache = InfinispanUtil.getRemoteCache(cache);
        if (remoteCache != null) {
            Map sessionsByIdForTransport = sessionsById.values().stream().map(SessionEntityWrapper::forTransport).collect(Collectors.toMap(sessionEntityWrapper -> ((UserSessionEntity)sessionEntityWrapper.getEntity()).getId(), Function.identity()));
            if (importWithExpiration) {
                this.importSessionsWithExpiration(sessionsByIdForTransport, (BasicCache)remoteCache, offline ? SessionTimeouts::getOfflineSessionLifespanMs : SessionTimeouts::getUserSessionLifespanMs, offline ? SessionTimeouts::getOfflineSessionMaxIdleMs : SessionTimeouts::getUserSessionMaxIdleMs);
            } else {
                Retry.executeWithBackoff(iteration -> {
                    try {
                        remoteCache.putAll(sessionsByIdForTransport);
                    }
                    catch (HotRodClientException re) {
                        if (log.isDebugEnabled()) {
                            log.debugf((Throwable)re, "Failed to put import %d sessions to remoteCache. Iteration '%s'. Will try to retry the task", sessionsByIdForTransport.size(), iteration);
                        }
                        throw re;
                    }
                }, (int)10, (int)10);
            }
        }
        AdvancedCache<UUID, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessCache = CacheDecorators.skipCacheLoadersIfRemoteStoreIsEnabled(offline ? this.offlineClientSessionCache : this.clientSessionCache);
        if (importWithExpiration) {
            this.importSessionsWithExpiration(clientSessionsById, (BasicCache)clientSessCache, (SessionFunction)(offline ? SessionTimeouts::getOfflineClientSessionLifespanMs : SessionTimeouts::getClientSessionLifespanMs), (SessionFunction)(offline ? SessionTimeouts::getOfflineClientSessionMaxIdleMs : SessionTimeouts::getClientSessionMaxIdleMs));
        } else {
            Retry.executeWithBackoff(iteration -> clientSessCache.putAll(clientSessionsById), (int)10, (int)10);
        }
        RemoteCache remoteCacheClientSessions = InfinispanUtil.getRemoteCache(clientSessCache);
        if (remoteCacheClientSessions != null) {
            Map sessionsByIdForTransport = clientSessionsById.values().stream().map(SessionEntityWrapper::forTransport).collect(Collectors.toMap(sessionEntityWrapper -> ((AuthenticatedClientSessionEntity)sessionEntityWrapper.getEntity()).getId(), Function.identity()));
            if (importWithExpiration) {
                this.importSessionsWithExpiration(sessionsByIdForTransport, (BasicCache)remoteCacheClientSessions, offline ? SessionTimeouts::getOfflineClientSessionLifespanMs : SessionTimeouts::getClientSessionLifespanMs, offline ? SessionTimeouts::getOfflineClientSessionMaxIdleMs : SessionTimeouts::getClientSessionMaxIdleMs);
            } else {
                Retry.executeWithBackoff(iteration -> {
                    try {
                        remoteCacheClientSessions.putAll(sessionsByIdForTransport);
                    }
                    catch (HotRodClientException re) {
                        if (log.isDebugEnabled()) {
                            log.debugf((Throwable)re, "Failed to put import %d client sessions to remoteCache. Iteration '%s'. Will try to retry the task", sessionsByIdForTransport.size(), iteration);
                        }
                        throw re;
                    }
                }, (int)10, (int)10);
            }
        }
    }

    private <T extends SessionEntity> void importSessionsWithExpiration(Map<? extends Object, SessionEntityWrapper<T>> sessionsById, BasicCache cache, SessionFunction<T> lifespanMsCalculator, SessionFunction<T> maxIdleTimeMsCalculator) {
        sessionsById.forEach((id, sessionEntityWrapper) -> {
            Object sessionEntity = sessionEntityWrapper.getEntity();
            RealmModel currentRealm = this.session.realms().getRealm(((SessionEntity)sessionEntity).getRealmId());
            ClientModel client = sessionEntityWrapper.getClientIfNeeded(currentRealm);
            long lifespan = lifespanMsCalculator.apply(currentRealm, client, sessionEntity);
            long maxIdle = maxIdleTimeMsCalculator.apply(currentRealm, client, sessionEntity);
            if (lifespan != -2L && maxIdle != -2L) {
                if (cache instanceof RemoteCache) {
                    Retry.executeWithBackoff(iteration -> {
                        try {
                            cache.put(id, sessionEntityWrapper, lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS);
                        }
                        catch (HotRodClientException re) {
                            if (log.isDebugEnabled()) {
                                log.debugf((Throwable)re, "Failed to put import %d sessions to remoteCache. Iteration '%s'. Will try to retry the task", sessionsById.size(), iteration);
                            }
                            throw re;
                        }
                    }, (int)10, (int)10);
                } else {
                    cache.put(id, sessionEntityWrapper, lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS);
                }
            }
        });
    }

    protected UserSessionAdapter importUserSession(UserSessionModel userSession, boolean offline) {
        UserSessionEntity entity = this.createUserSessionEntityInstance(userSession);
        InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx = this.getTransaction(offline);
        SessionUpdateTask importTask = Tasks.addIfAbsentSync();
        userSessionUpdateTx.addTask(userSession.getId(), importTask, entity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        UserSessionAdapter importedSession = this.wrap(userSession.getRealm(), entity, offline);
        return importedSession;
    }

    private UserSessionEntity createUserSessionEntityInstance(UserSessionModel userSession) {
        UserSessionEntity entity = new UserSessionEntity();
        entity.setId(userSession.getId());
        entity.setRealmId(userSession.getRealm().getId());
        entity.setAuthMethod(userSession.getAuthMethod());
        entity.setBrokerSessionId(userSession.getBrokerSessionId());
        entity.setBrokerUserId(userSession.getBrokerUserId());
        entity.setIpAddress(userSession.getIpAddress());
        entity.setNotes(userSession.getNotes() == null ? new ConcurrentHashMap() : userSession.getNotes());
        entity.setAuthenticatedClientSessions(new AuthenticatedClientSessionStore());
        entity.setRememberMe(userSession.isRememberMe());
        entity.setState(userSession.getState());
        if (userSession instanceof OfflineUserSessionModel) {
            OfflineUserSessionModel oline = (OfflineUserSessionModel)userSession;
            entity.setUser(oline.getUserId());
        } else {
            entity.setLoginUsername(userSession.getLoginUsername());
            entity.setUser(userSession.getUser().getId());
        }
        entity.setStarted(userSession.getStarted());
        entity.setLastSessionRefresh(userSession.getLastSessionRefresh());
        return entity;
    }

    private AuthenticatedClientSessionAdapter importClientSession(UserSessionAdapter sessionToImportInto, AuthenticatedClientSessionModel clientSession, InfinispanChangelogBasedTransaction<String, UserSessionEntity> userSessionUpdateTx, InfinispanChangelogBasedTransaction<UUID, AuthenticatedClientSessionEntity> clientSessionUpdateTx, boolean offline, boolean checkExpiration) {
        AuthenticatedClientSessionEntity entity = this.createAuthenticatedClientSessionInstance(clientSession, sessionToImportInto.getRealm().getId(), clientSession.getClient().getId(), offline);
        entity.setTimestamp(sessionToImportInto.getLastSessionRefresh());
        if (checkExpiration) {
            SessionFunction<AuthenticatedClientSessionEntity> idleTimeoutChecker;
            SessionFunction<AuthenticatedClientSessionEntity> lifespanChecker = offline ? SessionTimeouts::getOfflineClientSessionLifespanMs : SessionTimeouts::getClientSessionLifespanMs;
            SessionFunction<AuthenticatedClientSessionEntity> sessionFunction = idleTimeoutChecker = offline ? SessionTimeouts::getOfflineClientSessionMaxIdleMs : SessionTimeouts::getClientSessionMaxIdleMs;
            if (idleTimeoutChecker.apply(sessionToImportInto.getRealm(), clientSession.getClient(), entity) == -2L || lifespanChecker.apply(sessionToImportInto.getRealm(), clientSession.getClient(), entity) == -2L) {
                return null;
            }
        }
        UUID clientSessionId = entity.getId();
        SessionUpdateTask createClientSessionTask = Tasks.addIfAbsentSync();
        clientSessionUpdateTx.addTask(entity.getId(), createClientSessionTask, entity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        AuthenticatedClientSessionStore clientSessions = sessionToImportInto.getEntity().getAuthenticatedClientSessions();
        clientSessions.put(clientSession.getClient().getId(), clientSessionId);
        RegisterClientSessionTask registerClientSessionTask = new RegisterClientSessionTask(clientSession.getClient().getId(), clientSessionId);
        userSessionUpdateTx.addTask(sessionToImportInto.getId(), registerClientSessionTask);
        return new AuthenticatedClientSessionAdapter(this.session, this, entity, clientSession.getClient(), sessionToImportInto, clientSessionUpdateTx, offline);
    }

    private AuthenticatedClientSessionEntity createAuthenticatedClientSessionInstance(AuthenticatedClientSessionModel clientSession, String realmId, String clientId, boolean offline) {
        UUID clientSessionId = this.keyGenerator.generateKeyUUID(this.session, this.getClientSessionCache(offline));
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity(clientSessionId);
        entity.setRealmId(realmId);
        entity.setClientId(clientId);
        entity.setAction(clientSession.getAction());
        entity.setAuthMethod(clientSession.getProtocol());
        entity.setNotes(clientSession.getNotes() == null ? new ConcurrentHashMap() : clientSession.getNotes());
        entity.setRedirectUri(clientSession.getRedirectUri());
        entity.setTimestamp(clientSession.getTimestamp());
        return entity;
    }

    private static class RegisterClientSessionTask
    implements SessionUpdateTask<UserSessionEntity> {
        private final String clientUuid;
        private final UUID clientSessionId;

        public RegisterClientSessionTask(String clientUuid, UUID clientSessionId) {
            this.clientUuid = clientUuid;
            this.clientSessionId = clientSessionId;
        }

        @Override
        public void runUpdate(UserSessionEntity session) {
            AuthenticatedClientSessionStore clientSessions = session.getAuthenticatedClientSessions();
            clientSessions.put(this.clientUuid, this.clientSessionId);
        }

        @Override
        public SessionUpdateTask.CacheOperation getOperation(UserSessionEntity session) {
            return SessionUpdateTask.CacheOperation.REPLACE;
        }

        @Override
        public SessionUpdateTask.CrossDCMessageStatus getCrossDCMessageStatus(SessionEntityWrapper<UserSessionEntity> sessionWrapper) {
            return SessionUpdateTask.CrossDCMessageStatus.SYNC;
        }
    }
}

