/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.services.health;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.health.DataSourceHealthCheck;
import io.quarkus.smallrye.health.runtime.QuarkusAsyncHealthCheckFactory;
import io.smallrye.health.api.AsyncHealthCheck;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Readiness;

@Readiness
@ApplicationScoped
public class KeycloakReadyAsyncHealthCheck
implements AsyncHealthCheck {
    MyDataSourceHealthCheck delegate;
    static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS").withZone(ZoneId.systemDefault());
    @Inject
    AgroalDataSource agroalDataSource;
    @Inject
    QuarkusAsyncHealthCheckFactory healthCheckFactory;
    AtomicReference<Instant> failingSince = new AtomicReference();

    @PostConstruct
    protected void init() {
        this.delegate = new MyDataSourceHealthCheck();
        this.delegate.init();
    }

    public Uni<HealthCheckResponse> call() {
        HealthCheckResponseBuilder builder = HealthCheckResponse.named((String)"Keycloak database connections async health check").up();
        long activeCount = this.agroalDataSource.getMetrics().activeCount();
        long invalidCount = this.agroalDataSource.getMetrics().invalidCount();
        if (activeCount < 1L || invalidCount > 0L) {
            return this.healthCheckFactory.callSync(() -> {
                HealthCheckResponse activeCheckResult = this.delegate.call();
                if (activeCheckResult.getStatus() == HealthCheckResponse.Status.DOWN) {
                    builder.down();
                    Instant failingTime = this.failingSince.updateAndGet(this::createInstanceIfNeeded);
                    builder.withData("Failing since", DATE_FORMATTER.format(failingTime));
                }
                return builder.build();
            });
        }
        this.failingSince.set(null);
        return this.healthCheckFactory.callAsync(() -> Uni.createFrom().item((Object)builder.build()));
    }

    Instant createInstanceIfNeeded(Instant instant) {
        if (instant == null) {
            return Instant.now();
        }
        return instant;
    }

    private static class MyDataSourceHealthCheck
    extends DataSourceHealthCheck {
        private MyDataSourceHealthCheck() {
        }

        public void init() {
            super.init();
        }
    }
}

