/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.representations.idm.UserProfileAttributeGroupMetadata;
import org.keycloak.representations.idm.UserProfileAttributeMetadata;
import org.keycloak.representations.idm.UserProfileMetadata;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.representations.userprofile.config.UPGroup;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.userprofile.AttributeMetadata;
import org.keycloak.userprofile.AttributeValidatorMetadata;
import org.keycloak.userprofile.UserProfile;
import org.keycloak.userprofile.UserProfileContext;
import org.keycloak.userprofile.UserProfileProvider;
import org.keycloak.validate.Validators;

@Extension(name="x-smallrye-profile-admin", value="")
public class UserProfileResource {
    protected final KeycloakSession session;
    protected final RealmModel realm;
    private final AdminPermissionEvaluator auth;

    public UserProfileResource(KeycloakSession session, AdminPermissionEvaluator auth) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.auth = auth;
    }

    @GET
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(description="Get the configuration for the user profile")
    public UPConfig getConfiguration() {
        this.auth.requireAnyAdminRole();
        return ((UserProfileProvider)this.session.getProvider(UserProfileProvider.class)).getConfiguration();
    }

    @GET
    @Path(value="/metadata")
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(description="Get the UserProfileMetadata from the configuration")
    public UserProfileMetadata getMetadata() {
        this.auth.requireAnyAdminRole();
        UserProfile profile = ((UserProfileProvider)this.session.getProvider(UserProfileProvider.class)).create(UserProfileContext.USER_API, Collections.emptyMap());
        return UserProfileResource.createUserProfileMetadata(this.session, profile);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Tag(name="Users")
    @Operation(description="Set the configuration for the user profile")
    @APIResponse(responseCode="200", content={@Content(schema=@Schema(implementation=UPConfig.class))})
    public Response update(@RequestBody(content={@Content(schema=@Schema(implementation=UPConfig.class))}) String text) {
        this.auth.realm().requireManageRealm();
        UserProfileProvider t = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        try {
            t.setConfiguration(text);
        }
        catch (ComponentValidationException e) {
            throw ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        return Response.ok((Object)t.getConfiguration()).type("application/json").build();
    }

    public static UserProfileMetadata createUserProfileMetadata(KeycloakSession session, UserProfile profile) {
        Map am = profile.getAttributes().getReadable();
        if (am == null) {
            return null;
        }
        List attributes = am.keySet().stream().map(name -> profile.getAttributes().getMetadata(name)).filter(Objects::nonNull).sorted(Comparator.comparingInt(AttributeMetadata::getGuiOrder)).map(sam -> UserProfileResource.toRestMetadata(sam, session, profile)).collect(Collectors.toList());
        UserProfileProvider provider = (UserProfileProvider)session.getProvider(UserProfileProvider.class);
        UPConfig config = provider.getConfiguration();
        List groups = config.getGroups().stream().map(new Function<UPGroup, UserProfileAttributeGroupMetadata>(){

            @Override
            public UserProfileAttributeGroupMetadata apply(UPGroup upGroup) {
                return new UserProfileAttributeGroupMetadata(upGroup.getName(), upGroup.getDisplayHeader(), upGroup.getDisplayDescription(), upGroup.getAnnotations());
            }
        }).collect(Collectors.toList());
        return new UserProfileMetadata(attributes, groups);
    }

    private static UserProfileAttributeMetadata toRestMetadata(AttributeMetadata am, KeycloakSession session, UserProfile profile) {
        String group = null;
        if (am.getAttributeGroupMetadata() != null) {
            group = am.getAttributeGroupMetadata().getName();
        }
        return new UserProfileAttributeMetadata(am.getName(), am.getAttributeDisplayName(), profile.getAttributes().isRequired(am.getName()), profile.getAttributes().isReadOnly(am.getName()), group, am.getAnnotations(), UserProfileResource.toValidatorMetadata(am, session));
    }

    private static Map<String, Map<String, Object>> toValidatorMetadata(AttributeMetadata am, KeycloakSession session) {
        return am.getValidators() == null ? null : am.getValidators().stream().filter(avm -> Validators.validator((KeycloakSession)session, (String)avm.getValidatorId()) instanceof ConfiguredProvider).collect(Collectors.toMap(AttributeValidatorMetadata::getValidatorId, AttributeValidatorMetadata::getValidatorConfig));
    }
}

