/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage;

import java.util.Objects;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.reflections.Types;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.LegacyRealmModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.RoleProvider;
import org.keycloak.provider.Provider;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.role.RoleLookupProvider;
import org.keycloak.storage.role.RoleStorageProvider;
import org.keycloak.storage.role.RoleStorageProviderFactory;
import org.keycloak.storage.role.RoleStorageProviderModel;
import org.keycloak.utils.ServicesUtils;

public class RoleStorageManager
implements RoleProvider {
    private static final Logger logger = Logger.getLogger(RoleStorageManager.class);
    protected KeycloakSession session;
    private final long roleStorageProviderTimeout;

    public RoleStorageManager(KeycloakSession session, long roleStorageProviderTimeout) {
        this.session = session;
        this.roleStorageProviderTimeout = roleStorageProviderTimeout;
    }

    private RoleProvider localStorage() {
        return (RoleProvider)this.session.getProvider(RoleProvider.class);
    }

    public static boolean isStorageProviderEnabled(RealmModel realm, String providerId) {
        RoleStorageProviderModel model = RoleStorageManager.getStorageProviderModel(realm, providerId);
        return model.isEnabled();
    }

    public static RoleStorageProviderModel getStorageProviderModel(RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        return new RoleStorageProviderModel(model);
    }

    public static RoleStorageProvider getStorageProvider(KeycloakSession session, RealmModel realm, String componentId) {
        ComponentModel model = realm.getComponent(componentId);
        if (model == null) {
            return null;
        }
        RoleStorageProviderModel storageModel = new RoleStorageProviderModel(model);
        RoleStorageProviderFactory factory = (RoleStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(RoleStorageProvider.class, model.getProviderId());
        if (factory == null) {
            throw new ModelException("Could not find RoletStorageProviderFactory for: " + model.getProviderId());
        }
        return RoleStorageManager.getStorageProviderInstance(session, storageModel, factory);
    }

    public static <T> Stream<RoleStorageProviderModel> getStorageProviders(RealmModel realm, KeycloakSession session, Class<T> type) {
        return ((LegacyRealmModel)realm).getRoleStorageProvidersStream().filter(model -> {
            RoleStorageProviderFactory factory = RoleStorageManager.getRoleStorageProviderFactory(model, session);
            if (factory == null) {
                logger.warnv("Configured RoleStorageProvider {0} of provider id {1} does not exist in realm {2}", (Object)model.getName(), (Object)model.getProviderId(), (Object)realm.getName());
                return false;
            }
            return Types.supports((Class)type, (Object)factory, RoleStorageProviderFactory.class);
        });
    }

    private static RoleStorageProviderFactory getRoleStorageProviderFactory(RoleStorageProviderModel model, KeycloakSession session) {
        return (RoleStorageProviderFactory)session.getKeycloakSessionFactory().getProviderFactory(RoleStorageProvider.class, model.getProviderId());
    }

    public static RoleStorageProvider getStorageProviderInstance(KeycloakSession session, RoleStorageProviderModel model, RoleStorageProviderFactory factory) {
        RoleStorageProvider instance = (RoleStorageProvider)session.getAttribute(model.getId());
        if (instance != null) {
            return instance;
        }
        instance = factory.create(session, (ComponentModel)model);
        if (instance == null) {
            throw new IllegalStateException("RoleStorageProvideFactory (of type " + factory.getClass().getName() + ") produced a null instance");
        }
        session.enlistForClose((Provider)instance);
        session.setAttribute(model.getId(), (Object)instance);
        return instance;
    }

    public static <T> Stream<T> getStorageProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        return RoleStorageManager.getStorageProviders(realm, session, type).map(model -> type.cast(RoleStorageManager.getStorageProviderInstance(session, model, RoleStorageManager.getRoleStorageProviderFactory(model, session))));
    }

    public static <T> Stream<T> getEnabledStorageProviders(KeycloakSession session, RealmModel realm, Class<T> type) {
        return RoleStorageManager.getStorageProviders(realm, session, type).filter(RoleStorageProviderModel::isEnabled).map(model -> type.cast(RoleStorageManager.getStorageProviderInstance(session, model, RoleStorageManager.getRoleStorageProviderFactory(model, session))));
    }

    public RoleModel addRealmRole(RealmModel realm, String name) {
        return this.localStorage().addRealmRole(realm, name);
    }

    public RoleModel addRealmRole(RealmModel realm, String id, String name) {
        return this.localStorage().addRealmRole(realm, id, name);
    }

    public RoleModel getRealmRole(RealmModel realm, String name) {
        RoleModel realmRole = this.localStorage().getRealmRole(realm, name);
        if (realmRole != null) {
            return realmRole;
        }
        return RoleStorageManager.getEnabledStorageProviders(this.session, realm, RoleLookupProvider.class).map(provider -> provider.getRealmRole(realm, name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public RoleModel getRoleById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        if (storageId.getProviderId() == null) {
            return this.localStorage().getRoleById(realm, id);
        }
        RoleStorageProvider provider = RoleStorageManager.getStorageProvider(this.session, realm, storageId.getProviderId());
        if (provider == null) {
            return null;
        }
        if (!RoleStorageManager.isStorageProviderEnabled(realm, storageId.getProviderId())) {
            return null;
        }
        return provider.getRoleById(realm, id);
    }

    public Stream<RoleModel> getRealmRolesStream(RealmModel realm, Integer first, Integer max) {
        return this.localStorage().getRealmRolesStream(realm, first, max);
    }

    public Stream<RoleModel> getRolesStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        return this.localStorage().getRolesStream(realm, ids, search, first, max);
    }

    public Stream<RoleModel> searchForRolesStream(RealmModel realm, String search, Integer first, Integer max) {
        Stream local = this.localStorage().searchForRolesStream(realm, search, first, max);
        Stream ext = RoleStorageManager.getEnabledStorageProviders(this.session, realm, RoleLookupProvider.class).flatMap(ServicesUtils.timeBound((KeycloakSession)this.session, (long)this.roleStorageProviderTimeout, p -> ((RoleLookupProvider)p).searchForRolesStream(realm, search, first, max)));
        return Stream.concat(local, ext);
    }

    public boolean removeRole(RoleModel role) {
        if (!StorageId.isLocalStorage((String)role.getId())) {
            throw new RuntimeException("Federated roles do not support this operation");
        }
        return this.localStorage().removeRole(role);
    }

    public void removeRoles(RealmModel realm) {
        this.localStorage().removeRoles(realm);
    }

    public void removeRoles(ClientModel client) {
        this.localStorage().removeRoles(client);
    }

    public RoleModel addClientRole(ClientModel client, String name) {
        return this.localStorage().addClientRole(client, name);
    }

    public RoleModel addClientRole(ClientModel client, String id, String name) {
        return this.localStorage().addClientRole(client, id, name);
    }

    public RoleModel getClientRole(ClientModel client, String name) {
        RoleModel clientRole = this.localStorage().getClientRole(client, name);
        if (clientRole != null) {
            return clientRole;
        }
        return RoleStorageManager.getEnabledStorageProviders(this.session, client.getRealm(), RoleLookupProvider.class).map(provider -> provider.getClientRole(client, name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client) {
        return this.localStorage().getClientRolesStream(client);
    }

    public Stream<RoleModel> getClientRolesStream(ClientModel client, Integer first, Integer max) {
        return this.localStorage().getClientRolesStream(client, first, max);
    }

    public Stream<RoleModel> searchForClientRolesStream(ClientModel client, String search, Integer first, Integer max) {
        Stream local = this.localStorage().searchForClientRolesStream(client, search, first, max);
        Stream ext = RoleStorageManager.getEnabledStorageProviders(this.session, client.getRealm(), RoleLookupProvider.class).flatMap(ServicesUtils.timeBound((KeycloakSession)this.session, (long)this.roleStorageProviderTimeout, p -> ((RoleLookupProvider)p).searchForClientRolesStream(client, search, first, max)));
        return Stream.concat(local, ext);
    }

    public Stream<RoleModel> searchForClientRolesStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        Stream local = this.localStorage().searchForClientRolesStream(realm, ids, search, first, max);
        Stream ext = RoleStorageManager.getEnabledStorageProviders(this.session, realm, RoleLookupProvider.class).flatMap(ServicesUtils.timeBound((KeycloakSession)this.session, (long)this.roleStorageProviderTimeout, p -> ((RoleLookupProvider)p).searchForClientRolesStream(realm, ids, search, first, max)));
        return Stream.concat(local, ext);
    }

    public Stream<RoleModel> searchForClientRolesStream(RealmModel realm, String search, Stream<String> excludedIds, Integer first, Integer max) {
        Stream local = this.localStorage().searchForClientRolesStream(realm, search, excludedIds, first, max);
        Stream ext = RoleStorageManager.getEnabledStorageProviders(this.session, realm, RoleLookupProvider.class).flatMap(ServicesUtils.timeBound((KeycloakSession)this.session, (long)this.roleStorageProviderTimeout, p -> ((RoleLookupProvider)p).searchForClientRolesStream(realm, search, excludedIds, first, max)));
        return Stream.concat(local, ext);
    }

    public void close() {
    }
}

