/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.cache.AbstractTransportConfigurationChildBuilder;
import org.infinispan.configuration.cache.RecoveryConfiguration;
import org.infinispan.configuration.cache.TransactionConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;

public class RecoveryConfigurationBuilder
extends AbstractTransportConfigurationChildBuilder
implements Builder<RecoveryConfiguration> {
    private final AttributeSet attributes = RecoveryConfiguration.attributeDefinitionSet();

    RecoveryConfigurationBuilder(TransactionConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public RecoveryConfigurationBuilder enable() {
        this.attributes.attribute(RecoveryConfiguration.ENABLED).set((Object)true);
        return this;
    }

    public RecoveryConfigurationBuilder disable() {
        this.attributes.attribute(RecoveryConfiguration.ENABLED).set((Object)false);
        return this;
    }

    public RecoveryConfigurationBuilder enabled(boolean enabled) {
        this.attributes.attribute(RecoveryConfiguration.ENABLED).set((Object)enabled);
        return this;
    }

    boolean isEnabled() {
        return (Boolean)this.attributes.attribute(RecoveryConfiguration.ENABLED).get();
    }

    public RecoveryConfigurationBuilder recoveryInfoCacheName(String recoveryInfoName) {
        this.attributes.attribute(RecoveryConfiguration.RECOVERY_INFO_CACHE_NAME).set((Object)recoveryInfoName);
        return this;
    }

    public void validate() {
        if (!((Boolean)this.attributes.attribute(RecoveryConfiguration.ENABLED).get()).booleanValue()) {
            return;
        }
        if (this.transaction().transactionMode() == TransactionMode.NON_TRANSACTIONAL) {
            throw Log.CONFIG.recoveryNotSupportedWithNonTxCache();
        }
        if (this.transaction().useSynchronization()) {
            throw Log.CONFIG.recoveryNotSupportedWithSynchronization();
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
        this.validate();
    }

    public RecoveryConfiguration create() {
        return new RecoveryConfiguration(this.attributes.protect());
    }

    public RecoveryConfigurationBuilder read(RecoveryConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "RecoveryConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

