/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils.reflection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.models.utils.reflection.MethodProperty;
import org.keycloak.models.utils.reflection.Properties;
import org.keycloak.models.utils.reflection.Property;
import org.keycloak.models.utils.reflection.PropertyCriteria;

public class PropertyQuery<V> {
    private final Class<?> targetClass;
    private final List<PropertyCriteria> criteria;

    PropertyQuery(Class<?> targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException("targetClass parameter may not be null");
        }
        this.targetClass = targetClass;
        this.criteria = new ArrayList<PropertyCriteria>();
    }

    public PropertyQuery<V> addCriteria(PropertyCriteria criteria) {
        this.criteria.add(criteria);
        return this;
    }

    public Property<V> getFirstResult() {
        Map<String, Property<V>> results = this.getResultList();
        return results.isEmpty() ? null : results.values().iterator().next();
    }

    public Property<V> getFirstWritableResult() {
        Map<String, Property<V>> results = this.getWritableResultList();
        return results.isEmpty() ? null : results.values().iterator().next();
    }

    public Property<V> getSingleResult() {
        Map<String, Property<V>> results = this.getResultList();
        if (results.size() == 1) {
            return results.values().iterator().next();
        }
        if (results.isEmpty()) {
            throw new RuntimeException("Expected one property match, but the criteria did not match any properties on " + this.targetClass.getName());
        }
        throw new RuntimeException("Expected one property match, but the criteria matched " + results.size() + " properties on " + this.targetClass.getName());
    }

    public Property<V> getWritableSingleResult() {
        Map<String, Property<V>> results = this.getWritableResultList();
        if (results.size() == 1) {
            return results.values().iterator().next();
        }
        if (results.isEmpty()) {
            throw new RuntimeException("Expected one property match, but the criteria did not match any properties on " + this.targetClass.getName());
        }
        throw new RuntimeException("Expected one property match, but the criteria matched " + results.size() + " properties on " + this.targetClass.getName());
    }

    public Map<String, Property<V>> getResultList() {
        return this.getResultList(false);
    }

    public Map<String, Property<V>> getWritableResultList() {
        return this.getResultList(true);
    }

    private Map<String, Property<V>> getResultList(boolean writable) {
        HashMap properties = new HashMap();
        for (Method method : this.targetClass.getMethods()) {
            if (!method.getName().startsWith("is") && !method.getName().startsWith("get")) continue;
            boolean match = true;
            for (PropertyCriteria c : this.criteria) {
                if (c.methodMatches(method)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            MethodProperty property = Properties.createProperty(method);
            if (writable && property.isReadOnly()) continue;
            properties.put(property.getName(), property);
        }
        return Collections.unmodifiableMap(properties);
    }
}

