/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Locale;
import java.util.function.Function;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnknownTableReferenceException;

public class UnionTableReference
extends NamedTableReference {
    private final String[] subclassTableSpaceExpressions;

    public UnionTableReference(String unionTableExpression, String[] subclassTableSpaceExpressions, String identificationVariable) {
        this(unionTableExpression, subclassTableSpaceExpressions, identificationVariable, false);
    }

    public UnionTableReference(String unionTableExpression, String[] subclassTableSpaceExpressions, String identificationVariable, boolean isOptional) {
        super(unionTableExpression, identificationVariable, isOptional);
        this.subclassTableSpaceExpressions = subclassTableSpaceExpressions;
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression) {
        if (this.hasTableExpression(tableExpression)) {
            return this;
        }
        throw new UnknownTableReferenceException(tableExpression, String.format(Locale.ROOT, "Unable to determine TableReference (`%s`) for `%s`", tableExpression, navigablePath));
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean resolve) {
        if (this.hasTableExpression(tableExpression)) {
            return this;
        }
        return null;
    }

    private boolean hasTableExpression(String tableExpression) {
        if (tableExpression.equals(this.getTableExpression())) {
            return true;
        }
        for (String expression : this.subclassTableSpaceExpressions) {
            if (!tableExpression.equals(expression)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAffectedTableName(String requestedName) {
        return StringHelper.isEmpty(requestedName) || this.hasTableExpression(requestedName);
    }

    @Override
    public Boolean visitAffectedTableNames(Function<String, Boolean> nameCollector) {
        for (String expression : this.subclassTableSpaceExpressions) {
            Boolean result = nameCollector.apply(expression);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

