/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli;

import java.io.PrintWriter;
import java.util.stream.Stream;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;
import picocli.CommandLine;

public class ShortErrorMessageHandler
implements CommandLine.IParameterExceptionHandler {
    public int handleParseException(CommandLine.ParameterException ex, String[] args) {
        CommandLine cmd = ex.getCommandLine();
        PrintWriter writer = cmd.getErr();
        Object errorMessage = ex.getMessage();
        if (ex instanceof CommandLine.UnmatchedArgumentException) {
            AbstractCommand command;
            String cliKey;
            PropertyMapper mapper;
            String original;
            CommandLine.UnmatchedArgumentException uae = (CommandLine.UnmatchedArgumentException)ex;
            String[] unmatched = this.getUnmatchedPartsByOptionSeparator(uae, "=");
            if (unmatched[0].equals(original = (String)uae.getUnmatched().get(0))) {
                unmatched = this.getUnmatchedPartsByOptionSeparator(uae, " ");
            }
            errorMessage = (mapper = PropertyMappers.getMapper(cliKey = unmatched[0])) == null || !(cmd.getCommand() instanceof AbstractCommand) ? "Unknown option: '" + cliKey + "'" : (!(command = (AbstractCommand)cmd.getCommand()).getOptionCategories().contains(mapper.getCategory()) ? "Option: '" + cliKey + "' not valid for command " + cmd.getCommandName() : (Stream.of(args).anyMatch("--optimized"::equals) && mapper.isBuildTime() && "start".equals(cmd.getCommandName()) ? "Build time option: '" + cliKey + "' not usable with pre-built image and --optimized" : (mapper.isRunTime() ? "Run time" : "Build time") + " option: '" + cliKey + "' not usable with " + cmd.getCommandName()));
        }
        writer.println(cmd.getColorScheme().errorText((String)errorMessage));
        CommandLine.UnmatchedArgumentException.printSuggestions((CommandLine.ParameterException)ex, (PrintWriter)writer);
        CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
        writer.printf("Try '%s --help' for more information on the available options.%n", spec.qualifiedName());
        return ShortErrorMessageHandler.getInvalidInputExitCode((Exception)((Object)ex), cmd);
    }

    static int getInvalidInputExitCode(Exception ex, CommandLine cmd) {
        return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode((Throwable)ex) : cmd.getCommandSpec().exitCodeOnInvalidInput();
    }

    private String[] getUnmatchedPartsByOptionSeparator(CommandLine.UnmatchedArgumentException uae, String separator) {
        return ((String)uae.getUnmatched().get(0)).split(separator);
    }
}

