/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.LockOptions;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.internal.BaseNaturalIdLoadAccessImpl;
import org.hibernate.loader.internal.LoadAccessContext;
import org.hibernate.metamodel.mapping.EntityMappingType;

public class NaturalIdLoadAccessImpl<T>
extends BaseNaturalIdLoadAccessImpl<T>
implements NaturalIdLoadAccess<T> {
    private final Map<String, Object> naturalIdParameters = new LinkedHashMap<String, Object>();

    public NaturalIdLoadAccessImpl(LoadAccessContext context, EntityMappingType entityDescriptor) {
        super(context, entityDescriptor);
    }

    @Override
    public NaturalIdLoadAccessImpl<T> with(LockOptions lockOptions) {
        return (NaturalIdLoadAccessImpl)super.with(lockOptions);
    }

    @Override
    public NaturalIdLoadAccess<T> using(String attributeName, Object value) {
        this.naturalIdParameters.put(attributeName, value);
        return this;
    }

    @Override
    public NaturalIdLoadAccess<T> using(Object ... mappings) {
        CollectionHelper.collectMapEntries(this.naturalIdParameters::put, mappings);
        return this;
    }

    @Override
    public NaturalIdLoadAccessImpl<T> setSynchronizationEnabled(boolean synchronizationEnabled) {
        super.synchronizationEnabled(synchronizationEnabled);
        return this;
    }

    @Override
    public final T getReference() {
        return this.doGetReference(this.entityPersister().getNaturalIdMapping().normalizeInput(this.naturalIdParameters));
    }

    @Override
    public final T load() {
        return this.doLoad(this.entityPersister().getNaturalIdMapping().normalizeInput(this.naturalIdParameters));
    }

    @Override
    public Optional<T> loadOptional() {
        return Optional.ofNullable(this.load());
    }
}

