/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.client.ClientPolicyProvider;
import org.keycloak.authorization.store.PolicyStore;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.authorization.ClientPolicyRepresentation;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.util.JsonSerialization;

public class ClientPolicyProviderFactory
implements PolicyProviderFactory<ClientPolicyRepresentation> {
    private ClientPolicyProvider provider = new ClientPolicyProvider(this::toRepresentation);

    public String getName() {
        return "Client";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public ClientPolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        ClientPolicyRepresentation representation = new ClientPolicyRepresentation();
        representation.setClients(this.getClients(policy));
        return representation;
    }

    public Class<ClientPolicyRepresentation> getRepresentationType() {
        return ClientPolicyRepresentation.class;
    }

    public void onCreate(Policy policy, ClientPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateClients(policy, representation.getClients(), authorization);
    }

    public void onUpdate(Policy policy, ClientPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateClients(policy, representation.getClients(), authorization);
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateClients(policy, this.getClients(policy), authorization);
    }

    public void onExport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        ClientPolicyRepresentation userRep = this.toRepresentation(policy, authorization);
        HashMap<String, String> config = new HashMap<String, String>();
        try {
            RealmModel realm = authorization.getRealm();
            config.put("clients", JsonSerialization.writeValueAsString(userRep.getClients().stream().map(id -> realm.getClientById(id).getClientId()).collect(Collectors.toList())));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to export user policy [" + policy.getName() + "]", cause);
        }
        representation.setConfig(config);
    }

    public PolicyProvider create(KeycloakSession session) {
        return null;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
        factory.register(event -> {
            if (event instanceof ClientModel.ClientRemovedEvent) {
                KeycloakSession keycloakSession = ((ClientModel.ClientRemovedEvent)event).getKeycloakSession();
                AuthorizationProvider provider = (AuthorizationProvider)keycloakSession.getProvider(AuthorizationProvider.class);
                StoreFactory storeFactory = provider.getStoreFactory();
                PolicyStore policyStore = storeFactory.getPolicyStore();
                ClientModel removedClient = ((ClientModel.ClientRemovedEvent)event).getClient();
                ResourceServerStore resourceServerStore = storeFactory.getResourceServerStore();
                ResourceServer resourceServer = resourceServerStore.findByClient(removedClient);
                if (resourceServer != null) {
                    policyStore.findByType(resourceServer, this.getId()).forEach(policy -> {
                        ArrayList<String> clients = new ArrayList<String>();
                        for (String clientId : this.getClients((Policy)policy)) {
                            if (clientId.equals(removedClient.getId())) continue;
                            clients.add(clientId);
                        }
                        try {
                            if (clients.isEmpty()) {
                                policyStore.delete(removedClient.getRealm(), policy.getId());
                            } else {
                                policy.putConfig("clients", JsonSerialization.writeValueAsString(clients));
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Error while synchronizing clients with policy [" + policy.getName() + "].", e);
                        }
                    });
                }
            }
        });
    }

    public void close() {
    }

    public String getId() {
        return "client";
    }

    private void updateClients(Policy policy, Set<String> clients, AuthorizationProvider authorization) {
        RealmModel realm = authorization.getRealm();
        if (clients == null || clients.isEmpty()) {
            throw new RuntimeException("No client provided.");
        }
        HashSet<String> updatedClients = new HashSet<String>();
        for (String id : clients) {
            ClientModel client = realm.getClientByClientId(id);
            if (client == null) {
                client = realm.getClientById(id);
            }
            if (client == null) {
                throw new RuntimeException("Error while updating policy [" + policy.getName() + "]. Client [" + id + "] could not be found.");
            }
            updatedClients.add(client.getId());
        }
        try {
            policy.putConfig("clients", JsonSerialization.writeValueAsString(updatedClients));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to serialize clients", cause);
        }
    }

    private Set<String> getClients(Policy policy) {
        String clients = (String)policy.getConfig().get("clients");
        if (clients != null) {
            try {
                return (Set)JsonSerialization.readValue((String)clients, Set.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not parse clients [" + clients + "] from policy config [" + policy.getName() + "].", e);
            }
        }
        return Collections.emptySet();
    }
}

