/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.HashMap;
import java.util.Map;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.storage.client.ClientStorageProvider;

public class ClientStorageProviderResource {
    protected final RealmModel realm;
    protected final AdminPermissionEvaluator auth;
    protected final AdminEventBuilder adminEvent;
    protected final ClientConnection clientConnection;
    protected final KeycloakSession session;
    protected final HttpHeaders headers;

    public ClientStorageProviderResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
        this.adminEvent = adminEvent;
        this.clientConnection = session.getContext().getConnection();
        this.headers = session.getContext().getRequestHeaders();
    }

    @GET
    @Path(value="{id}/name")
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, String> getSimpleName(@PathParam(value="id") String id) {
        this.auth.clients().requireList();
        ComponentModel model = this.realm.getComponent(id);
        if (model == null) {
            throw new NotFoundException("Could not find component");
        }
        if (!model.getProviderType().equals(ClientStorageProvider.class.getName())) {
            throw new NotFoundException("found, but not a ClientStorageProvider");
        }
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("id", model.getId());
        data.put("name", model.getName());
        return data;
    }
}

