/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

abstract class GeneratedPhysicalConnection
extends OracleConnection {
    boolean autocommit;
    int commitOption;
    int ociConnectionPoolMinLimit = 0;
    int ociConnectionPoolMaxLimit = 0;
    int ociConnectionPoolIncrement = 0;
    int ociConnectionPoolTimeout = 0;
    boolean ociConnectionPoolNoWait = false;
    boolean ociConnectionPoolTransactionDistributed = false;
    String ociConnectionPoolLogonMode = null;
    boolean ociConnectionPoolIsPooling = false;
    Object ociConnectionPoolObject = null;
    Object ociConnectionPoolConnID = null;
    String ociConnectionPoolProxyType = null;
    Integer ociConnectionPoolProxyNumRoles = 0;
    Object ociConnectionPoolProxyRoles = null;
    String ociConnectionPoolProxyUserName = null;
    OpaqueString ociConnectionPoolProxyPassword = null;
    String ociConnectionPoolProxyDistinguishedName = null;
    Object ociConnectionPoolProxyCertificate = null;
    private static Set<String> providerAllowedProperties = new HashSet<String>();
    boolean retainV9BindBehavior;
    String userName;
    OpaqueString newPasswordValue;
    String database;
    boolean defaultautocommit;
    boolean bindUseDBA;
    String protocol;
    int streamChunkSize;
    boolean setFloatAndDoubleUseBinary;
    String thinVsessionTerminal;
    String thinVsessionMachine;
    String thinVsessionOsuser;
    String thinVsessionProgram;
    String thinVsessionProcess;
    String thinVsessionIname;
    String thinVsessionEname;
    String thinNetProfile;
    boolean ociExternalAuthentication;
    String thinNetAuthenticationServices;
    String thinNetRadiusCRHandler;
    String thinNetAuthenticationKrb5Mutual;
    String thinNetAuthenticationKrb5CcName;
    String thinNetAuthenticationKrbRealm;
    String thinNetAuthenticationKrbJaasLoginModule;
    String thinNetSetFIPSMode;
    String thinDebugJDWP;
    boolean thinNetAllowWeakCrypto;
    String thinNetEncryptionLevel;
    String thinNetEncryptionTypes;
    String thinNetChecksumLevel;
    String thinNetChecksumTypes;
    String thinNetCryptoSeed;
    boolean thinUseJCEAPI;
    boolean thinTcpNoDelay;
    String thinReadTimeout;
    String thinOutboundConnectTimeout;
    String thinNetConnectTimeout;
    boolean thinNetDisableOutOfBandBreak;
    boolean thinNetUseZeroCopyIO;
    boolean use1900AsYearForTime;
    boolean timestamptzInGmt;
    boolean timezoneAsRegion;
    String thinSslCertificateAlias;
    String thinSslServerDnMatch;
    String thinSslServerCertDn;
    String thinSslAllowWeakDnMatch;
    String thinSslVersion;
    String thinSslCipherSuites;
    String thinJavaxNetSslKeystore;
    String thinJavaxNetSslKeystoretype;
    OpaqueString thinJavaxNetSslKeystorepassword;
    String thinJavaxNetSslTruststore;
    String thinJavaxNetSslTruststoretype;
    OpaqueString thinJavaxNetSslTruststorepassword;
    String thinSslKeymanagerfactoryAlgorithm;
    String thinSslTrustmanagerfactoryAlgorithm;
    String thinNetOldsyntax;
    String thinJndiLdapConnectTimeout;
    String thinJndiLdapReadTimeout;
    String walletLocation;
    OpaqueString walletPassword;
    String thinLdapSslCipherSuites;
    String thinLdapSslVersions;
    String thinLdapSslKeyStore;
    String thinLdapSslKeyStoreType;
    OpaqueString thinLdapSslKeyStorePwd;
    String thinLdapSslKeyManagerFactoryAlgo;
    String thinLdapSslTrustStore;
    String thinLdapSslTrustStoreType;
    OpaqueString thinLdapSslTrustStorePassword;
    String thinLdapSslTrustManagerFactoryAlgo;
    String thinLdapSslWalletLocation;
    OpaqueString thinLdapSslWalletPassword;
    String thinLdapSecurityAuthentication;
    String thinLdapSecurityPrincipal;
    OpaqueString thinLdapSecurityCredetials;
    String thinLdapsslContextProtocol;
    String proxyClientName;
    boolean useNio;
    String thinHttpsProxyHost;
    int thinHttpsProxyPort;
    String localHostName;
    String thinNetConnectionIdPrefix;
    String ociDriverCharset;
    String editionName;
    String logonCap;
    boolean useOCIDefaultDefines;
    String internalLogon;
    boolean createDescriptorUseCurrentSchemaForSchemaName;
    long ociSvcCtxHandle;
    long ociEnvHandle;
    long ociErrHandle;
    boolean prelimAuth;
    boolean jmsNotificationConnection;
    boolean nlsLangBackdoor;
    int defaultExecuteBatch;
    int defaultRowPrefetch;
    int defaultLobPrefetchSize;
    boolean enableDataInLocator;
    boolean enableReadDataInLocator;
    boolean overrideEnableReadDataInLocator;
    boolean reportRemarks;
    boolean includeSynonyms;
    boolean restrictGettables;
    boolean accumulateBatchResult;
    boolean useFetchSizeWithLongColumn;
    boolean processEscapes;
    boolean fixedString;
    boolean defaultnchar;
    boolean permitTimestampDateMismatch;
    String resourceManagerId;
    boolean disableDefinecolumntype;
    boolean convertNcharLiterals;
    boolean autoCommitSpecCompliant;
    boolean jdbcStandardBehavior;
    boolean j2ee13Compliant;
    String dmsParentName;
    String dmsParentType;
    boolean dmsStmtMetrics;
    boolean dmsStmtCachingMetrics;
    boolean mapDateToTimestamp;
    boolean useThreadLocalBufferCache;
    String driverNameAttribute;
    int maxCachedBufferSize;
    int implicitStatementCacheSize;
    boolean lobStreamPosStandardCompliant;
    boolean isStrictAsciiConversion;
    boolean isQuickAsciiConversion;
    String drcpConnectionClass;
    String drcpTagName;
    String drcpConnectionPurity;
    boolean useDRCPMultipletag;
    String drcpPLSQLCallback;
    String blockSourceImpl;
    boolean thinForceDnsLoadBalancing;
    boolean enableTempLobRefCnt;
    boolean keepAlive;
    String sqlTranslationProfile;
    String sqlErrorTranslationFile;
    boolean ignoreReplayContextFromAuthentication;
    boolean javaNetNio;
    boolean nsDirectBuffer;
    boolean plsqlVarcharParameter4KOnly;
    String targetInstanceName;
    String targetServiceName;
    String targetShardingKey;
    String targetSuperShardingKey;
    boolean readOnlyInstanceAllowed;
    boolean enableOCIFAN;
    boolean isResultSetCacheEnabled_IGNORED;
    boolean isResultSetCacheEnabled_IGNORED2;
    boolean isResultSetCacheEnabled;
    boolean isOldUpdateableResultSet;
    String allowedLogonVersion;
    String commitOptionProperty;
    String calculateChecksumProperty;
    String javaNetLocalIPForMsgq;
    String javaNetMsgqTransport;
    int javaNetMsgqBusyWait;
    int javaNetMsgqKernelWait;
    int downHostsTimeout;
    boolean fanEnabled;
    String tnsAdmin;
    String networkCompression;
    String networkCompressionLevels;
    int networkCompressionThreshold;
    String configFile;
    String websocketUser;
    OpaqueString websocketPassword;
    String socksProxyHost;
    int socksProxyPort;
    boolean socksRemoteDNS;
    OracleConnection.ConnectionValidation defaultConnectionValidation;
    boolean enableACSupport;
    boolean enableTGSupport;
    boolean enableImplicitRequests;
    boolean enableSSSCursor;
    boolean drcpMultiplexingInRequestAPIs;
    boolean continueBatchOnError;
    int tcpKeepIdle;
    int tcpKeepInterval;
    boolean useShardingDriverConnection;
    int tcpKeepCount;
    int requestSizeLimit;
    String onsWalletFile;
    OpaqueString onsWalletPassword;
    String onsProtocol;
    int loginTimeout;
    boolean inbandNotification;
    String sslContextProtocol;
    int fetchSizeTuning;
    boolean useTrueCacheDriverConnection;
    boolean isPermitSensitiveDiagnostics;
    boolean isSensitiveDiagnosticsEnabled;
    String diagnosticLoggerName;
    int diagnosticBufferSize;
    boolean isDiagnoseFirstFailureEnabled;
    boolean isLoggingEnabled;
    boolean isObservabilityEnabled;
    boolean isWriteLogsToDiagnoseFirstFailure;
    String debugTenants;
    String debugSQLs;
    boolean isMetricsEnabled;
    String tokenAuthentication;
    String tokenLocation;
    String passwordAuthentication;
    String ociIamUrl;
    String ociTenancy;
    String ociCompartment;
    String ociDatabase;
    boolean commitSelectOnAutocommit;
    String jsonDefaultGetObjectType;
    OpaqueString accessToken;
    boolean isLobPrefetchDataRetained;
    String ociConfigFile;
    String ociProfile;
    String azureDatabaseApplicationIdUri;
    String tenantId;
    String clientId;
    OpaqueString clientSecret;
    String clientCertificate;
    OpaqueString clientCertificatePassword;
    String redirectUri;
    boolean enableErrorUrl;
    float asyncCursorLimit;
    boolean parameterMetadataPreprocess;
    int parameterMetadataCacheSize;
    boolean parameterMetadataCacheIncludeParsing;
    boolean remoteConfigurationFiltering;
    int ttcCookieCacheSize;
    boolean ttcCookieOptimizationEnabled;
    boolean sendAllDataForValueLobs;
    boolean sendBooleanInPLSQL;
    String databaseStateRequirement;
    boolean allowMixingJdbcAndNamedBinds;
    boolean allowSingleShardTransactionSupport;

    GeneratedPhysicalConnection() {
    }

    static String getSystemPropertyPollInterval() {
        return GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.TimeoutPollInterval", "1000");
    }

    static String getSystemPropertySqlTranslationProfile() {
        return GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.sqlTranslationProfile", null);
    }

    static String getSystemPropertyFastConnectionFailover(String defaultValue) {
        return GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.FastConnectionFailover", defaultValue);
    }

    static String getSystemPropertyUserName() {
        return GeneratedPhysicalConnection.getSystemProperty("user.name", null);
    }

    static String getSystemPropertyTrace() {
        return GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.Trace", null);
    }

    static String getSystemPropertyDateZeroTime(String defaultValue) {
        return GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.DateZeroTime", defaultValue);
    }

    static String getSystemPropertyDateZeroTimeExtra(String defaultValue) {
        return GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.DateZeroTimeExtra", defaultValue);
    }

    static String getSystemPropertyConfigFile(String defaultValue) {
        return GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.config.file", defaultValue);
    }

    static String getSystemPropertyTnsAdmin(String defaultValue) {
        return GeneratedPhysicalConnection.getSystemProperty("oracle.net.tns_admin", defaultValue);
    }

    static String getSystemPropertyDatabase(String defaultValue) {
        String database = GeneratedPhysicalConnection.getSystemProperty("database", null);
        return database != null ? database : GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.database", defaultValue);
    }

    static String getSystemPropertyUserHome(String defaultValue) {
        return GeneratedPhysicalConnection.getSystemProperty("user.home", defaultValue);
    }

    static String getApplicationProgramName(final String defaultValue) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String sessionProgram = defaultValue;
                Collection<StackTraceElement[]> stacks = Thread.getAllStackTraces().values();
                for (StackTraceElement[] currentStack : stacks) {
                    StackTraceElement lastElement;
                    if (currentStack.length == 0 || !(lastElement = currentStack[currentStack.length - 1]).getMethodName().equals("main")) continue;
                    try {
                        String mainClassName = lastElement.getClassName();
                        sessionProgram = Class.forName(mainClassName).getSimpleName();
                        if (sessionProgram == null) {
                            sessionProgram = defaultValue;
                        }
                        return sessionProgram;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                return sessionProgram;
            }
        });
    }

    static String getSystemPropertyTTCCookieCacheSize() {
        return GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.TTCCookieCacheSize", "50");
    }

    private static String getSystemProperty(final String str, final String defaultValue) {
        if (str != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(str, defaultValue);
                }
            });
        }
        return defaultValue;
    }

    private void readDeprecatedConnectionProperties(@Blind(value=PropertiesBlinder.class) Properties info) throws SQLException {
        this.includeSynonyms = this.parseConnectionProperty(info, "synonyms", (byte)3, this.includeSynonyms);
        this.reportRemarks = this.parseConnectionProperty(info, "remarks", (byte)3, this.reportRemarks);
        this.defaultRowPrefetch = this.parseConnectionProperty(info, "prefetch", (byte)3, this.defaultRowPrefetch);
        this.defaultRowPrefetch = this.parseConnectionProperty(info, "rowPrefetch", (byte)3, this.defaultRowPrefetch);
        this.proxyClientName = this.parseConnectionProperty(info, "PROXY_CLIENT_NAME", (byte)1, this.proxyClientName);
    }

    private String parseConnectionProperty(@Blind(value=PropertiesBlinder.class) Properties props, String name, byte mode, String def) throws SQLException {
        String ret = null;
        if (!(mode != 1 && mode != 3 || props == null || (ret = props.getProperty(name)) != null || name.startsWith("oracle.") || name.startsWith("java.") || name.startsWith("javax."))) {
            ret = props.getProperty("oracle.jdbc." + name);
        }
        if (ret == null && (mode == 2 || mode == 3)) {
            ret = name.startsWith("oracle.") || name.startsWith("java.") || name.startsWith("javax.") ? GeneratedPhysicalConnection.getSystemProperty(name, null) : GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc." + name, null);
        }
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    private int parseConnectionProperty(@Blind(value=PropertiesBlinder.class) Properties props, String name, byte mode, int def) throws SQLException {
        int ret = def;
        String val = this.parseConnectionProperty(props, name, mode, null);
        if (val != null) {
            try {
                ret = Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is '" + name + "' and value is '" + val + "'").fillInStackTrace();
            }
        }
        return ret;
    }

    private long parseConnectionProperty(@Blind(value=PropertiesBlinder.class) Properties props, String name, byte mode, long def) throws SQLException {
        long ret = def;
        String val = this.parseConnectionProperty(props, name, mode, null);
        if (val != null) {
            try {
                ret = Long.parseLong(val);
            }
            catch (NumberFormatException nfe) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is '" + name + "' and value is '" + val + "'").fillInStackTrace();
            }
        }
        return ret;
    }

    private boolean parseConnectionProperty(@Blind(value=PropertiesBlinder.class) Properties props, String name, byte mode, boolean def) throws SQLException {
        boolean ret = def;
        String val = this.parseConnectionProperty(props, name, mode, null);
        if (val != null) {
            if (val.equalsIgnoreCase("false")) {
                ret = false;
            } else if (val.equalsIgnoreCase("true")) {
                ret = true;
            }
        }
        return ret;
    }

    protected void readOCIConnectionPoolProperties(@Blind(value=PropertiesBlinder.class) Properties info) throws SQLException {
        this.ociConnectionPoolMinLimit = this.parseConnectionProperty(info, "connpool_min_limit", (byte)1, 0);
        this.ociConnectionPoolMaxLimit = this.parseConnectionProperty(info, "connpool_max_limit", (byte)1, 0);
        this.ociConnectionPoolIncrement = this.parseConnectionProperty(info, "connpool_increment", (byte)1, 0);
        this.ociConnectionPoolTimeout = this.parseConnectionProperty(info, "connpool_timeout", (byte)1, 0);
        this.ociConnectionPoolNoWait = this.parseConnectionProperty(info, "connpool_nowait", (byte)1, false);
        this.ociConnectionPoolTransactionDistributed = this.parseConnectionProperty(info, "transactions_distributed", (byte)1, false);
        this.ociConnectionPoolLogonMode = this.parseConnectionProperty(info, "connection_pool", (byte)1, null);
        this.ociConnectionPoolIsPooling = this.parseConnectionProperty(info, "is_connection_pooling", (byte)1, false);
        this.ociConnectionPoolObject = this.parseOCIConnectionPoolProperty(info, "connpool_object", null);
        this.ociConnectionPoolConnID = this.parseOCIConnectionPoolProperty(info, "connection_id", null);
        this.ociConnectionPoolProxyType = this.parseConnectionProperty(info, "proxytype", (byte)1, null);
        this.ociConnectionPoolProxyNumRoles = (Integer)this.parseOCIConnectionPoolProperty(info, "proxy_num_roles", 0);
        this.ociConnectionPoolProxyRoles = this.parseOCIConnectionPoolProperty(info, "proxy_roles", null);
        this.ociConnectionPoolProxyUserName = this.parseConnectionProperty(info, "proxy_user_name", (byte)1, null);
        this.ociConnectionPoolProxyPassword = OpaqueString.newOpaqueString(this.parseConnectionProperty(info, "proxy_password", (byte)1, null));
        this.ociConnectionPoolProxyDistinguishedName = this.parseConnectionProperty(info, "proxy_distinguished_name", (byte)1, null);
        this.ociConnectionPoolProxyCertificate = this.parseOCIConnectionPoolProperty(info, "proxy_certificate", null);
    }

    private Object parseOCIConnectionPoolProperty(@Blind(value=PropertiesBlinder.class) Properties props, String name, Object def) throws SQLException {
        Object val;
        Object ret = def;
        if (props != null && (val = props.get(name)) != null) {
            ret = val;
        }
        return ret;
    }

    static boolean isAllowedByProvider(String property) {
        return providerAllowedProperties.contains(property);
    }

    @Override
    public Set<String> getProviderAllowedProperties() {
        return providerAllowedProperties;
    }

    protected void readConnectionProperties(String ul, @Blind(value=PropertiesBlinder.class) Properties info, @Blind(value=PropertiesBlinder.class) Properties fromFile) throws SQLException {
        String tempval = null;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.RetainV9LongBindBehavior");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.RetainV9LongBindBehavior", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.RetainV9LongBindBehavior");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.retainV9BindBehavior = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("user")) == null) {
            tempval = info.getProperty("oracle.jdbc.user");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.user", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("user")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.user");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.userName = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.newPassword");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.newPasswordValue = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null && (tempval = info.getProperty("database")) == null) {
            tempval = info.getProperty("oracle.jdbc.database");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.database", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("database")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.database");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.database = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("autoCommit")) == null) {
            tempval = info.getProperty("oracle.jdbc.autoCommit");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.autoCommit", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("autoCommit")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.autoCommit");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.defaultautocommit = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.bindUseDBA");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.bindUseDBA", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.bindUseDBA");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.bindUseDBA = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("protocol")) == null) {
            tempval = info.getProperty("oracle.jdbc.protocol");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.protocol", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("protocol")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.protocol");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.protocol = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.StreamChunkSize");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.StreamChunkSize", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.StreamChunkSize");
        }
        if (tempval == null) {
            tempval = "32767";
        }
        try {
            this.streamChunkSize = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'streamChunkSize'").fillInStackTrace();
        }
        tempval = null;
        if (info != null && (tempval = info.getProperty("SetFloatAndDoubleUseBinary")) == null) {
            tempval = info.getProperty("oracle.jdbc.SetFloatAndDoubleUseBinary");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.SetFloatAndDoubleUseBinary", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("SetFloatAndDoubleUseBinary")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.SetFloatAndDoubleUseBinary");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.setFloatAndDoubleUseBinary = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("v$session.terminal")) == null) {
            tempval = info.getProperty("oracle.jdbc.v$session.terminal");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.terminal", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.terminal")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.v$session.terminal");
        }
        if (tempval == null) {
            tempval = "unknown";
        }
        this.thinVsessionTerminal = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("v$session.machine")) == null) {
            tempval = info.getProperty("oracle.jdbc.v$session.machine");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.machine", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.machine")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.v$session.machine");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinVsessionMachine = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("v$session.osuser")) == null) {
            tempval = info.getProperty("oracle.jdbc.v$session.osuser");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.osuser", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.osuser")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.v$session.osuser");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinVsessionOsuser = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("v$session.program")) == null) {
            tempval = info.getProperty("oracle.jdbc.v$session.program");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.program", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.program")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.v$session.program");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinVsessionProgram = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("v$session.process")) == null) {
            tempval = info.getProperty("oracle.jdbc.v$session.process");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.process", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.process")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.v$session.process");
        }
        if (tempval == null) {
            tempval = "1234";
        }
        this.thinVsessionProcess = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("v$session.iname")) == null) {
            tempval = info.getProperty("oracle.jdbc.v$session.iname");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.iname", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.iname")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.v$session.iname");
        }
        if (tempval == null) {
            tempval = "jdbc_ttc_impl";
        }
        this.thinVsessionIname = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("v$session.ename")) == null) {
            tempval = info.getProperty("oracle.jdbc.v$session.ename");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.v$session.ename", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("v$session.ename")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.v$session.ename");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinVsessionEname = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.profile");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.profile", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.profile");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetProfile = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.external_authentication");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.external_authentication", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.external_authentication");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.ociExternalAuthentication = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.authentication_services");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.authentication_services", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.authentication_services");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetAuthenticationServices = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.radius_challenge_response_handler");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.radius_challenge_response_handler", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.radius_challenge_response_handler");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetRadiusCRHandler = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.kerberos5_mutual_authentication");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.kerberos5_mutual_authentication", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.kerberos5_mutual_authentication");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetAuthenticationKrb5Mutual = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.kerberos5_cc_name");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.kerberos5_cc_name", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.kerberos5_cc_name");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetAuthenticationKrb5CcName = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.KerberosRealm");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.KerberosRealm", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.KerberosRealm");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetAuthenticationKrbRealm = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.KerberosJaasLoginModule");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.KerberosJaasLoginModule", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.KerberosJaasLoginModule");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetAuthenticationKrbJaasLoginModule = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.setFIPSMode");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.setFIPSMode", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.setFIPSMode");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetSetFIPSMode = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.debugJDWP");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.debugJDWP", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.debugJDWP");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinDebugJDWP = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.allow_weak_crypto");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.allow_weak_crypto", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.allow_weak_crypto");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.thinNetAllowWeakCrypto = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.encryption_client");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.encryption_client", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.encryption_client");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetEncryptionLevel = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.encryption_types_client");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.encryption_types_client", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.encryption_types_client");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetEncryptionTypes = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.crypto_checksum_client");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.crypto_checksum_client", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.crypto_checksum_client");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetChecksumLevel = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.crypto_checksum_types_client");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.crypto_checksum_types_client", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.crypto_checksum_types_client");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetChecksumTypes = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.crypto_seed");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.crypto_seed", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.crypto_seed");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetCryptoSeed = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.useJCEAPI");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.useJCEAPI", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.useJCEAPI");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.thinUseJCEAPI = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.TcpNoDelay");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.TcpNoDelay", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.TcpNoDelay");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.thinTcpNoDelay = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ReadTimeout");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ReadTimeout", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.ReadTimeout");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinReadTimeout = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.OUTBOUND_CONNECT_TIMEOUT");
        }
        if (tempval == null) {
            tempval = "0";
        }
        this.thinOutboundConnectTimeout = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.CONNECT_TIMEOUT");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.CONNECT_TIMEOUT", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.CONNECT_TIMEOUT");
        }
        if (tempval == null) {
            tempval = "0";
        }
        this.thinNetConnectTimeout = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.disableOob");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.disableOob", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.disableOob");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.thinNetDisableOutOfBandBreak = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.useZeroCopyIO");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.useZeroCopyIO", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.useZeroCopyIO");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.thinNetUseZeroCopyIO = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.use1900AsYearForTime");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.use1900AsYearForTime", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.use1900AsYearForTime");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.use1900AsYearForTime = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.timestampTzInGmt");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.timestampTzInGmt", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.timestampTzInGmt");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.timestamptzInGmt = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.timezoneAsRegion");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.timezoneAsRegion", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.timezoneAsRegion");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.timezoneAsRegion = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ssl_certificate_alias");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_certificate_alias", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ssl_certificate_alias");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinSslCertificateAlias = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ssl_server_dn_match");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_server_dn_match", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ssl_server_dn_match");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinSslServerDnMatch = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ssl_server_cert_dn");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_server_cert_dn", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ssl_server_cert_dn");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinSslServerCertDn = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ssl_allow_weak_dn_match");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_allow_weak_dn_match", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ssl_allow_weak_dn_match");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinSslAllowWeakDnMatch = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ssl_version");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_version", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ssl_version");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinSslVersion = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ssl_cipher_suites");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_cipher_suites", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ssl_cipher_suites");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinSslCipherSuites = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("javax.net.ssl.keyStore");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.keyStore", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("javax.net.ssl.keyStore");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinJavaxNetSslKeystore = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("javax.net.ssl.keyStoreType");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.keyStoreType", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("javax.net.ssl.keyStoreType");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinJavaxNetSslKeystoretype = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.keyStorePassword", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinJavaxNetSslKeystorepassword = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("javax.net.ssl.trustStore");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.trustStore", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("javax.net.ssl.trustStore");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinJavaxNetSslTruststore = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("javax.net.ssl.trustStoreType");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.trustStoreType", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("javax.net.ssl.trustStoreType");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinJavaxNetSslTruststoretype = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("javax.net.ssl.trustStorePassword", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinJavaxNetSslTruststorepassword = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null && (tempval = info.getProperty("ssl.keyManagerFactory.algorithm")) == null) {
            tempval = info.getProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("ssl.keyManagerFactory.algorithm")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.ssl.keyManagerFactory.algorithm");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinSslKeymanagerfactoryAlgorithm = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("ssl.trustManagerFactory.algorithm")) == null) {
            tempval = info.getProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("ssl.trustManagerFactory.algorithm")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.ssl.trustManagerFactory.algorithm");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinSslTrustmanagerfactoryAlgorithm = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.oldSyntax");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.oldSyntax", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.oldSyntax");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetOldsyntax = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("com.sun.jndi.ldap.connect.timeout")) == null) {
            tempval = info.getProperty("oracle.jdbc.com.sun.jndi.ldap.connect.timeout");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.com.sun.jndi.ldap.connect.timeout", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("com.sun.jndi.ldap.connect.timeout")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.com.sun.jndi.ldap.connect.timeout");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinJndiLdapConnectTimeout = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("com.sun.jndi.ldap.read.timeout")) == null) {
            tempval = info.getProperty("oracle.jdbc.com.sun.jndi.ldap.read.timeout");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.com.sun.jndi.ldap.read.timeout", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("com.sun.jndi.ldap.read.timeout")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.com.sun.jndi.ldap.read.timeout");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinJndiLdapReadTimeout = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.wallet_location");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.wallet_location", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.wallet_location");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.walletLocation = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.wallet_password");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.wallet_password", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.wallet_password");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.walletPassword = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.supportedCiphers");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.supportedCiphers", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.supportedCiphers");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslCipherSuites = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.supportedVersions");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.supportedVersions", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.supportedVersions");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslVersions = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.keyStore");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.keyStore", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.keyStore");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslKeyStore = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.keyStoreType");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.keyStoreType", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.keyStoreType");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslKeyStoreType = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.keyStorePassword");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.keyStorePassword", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.keyStorePassword");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslKeyStorePwd = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.keyManagerFactory.algorithm");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslKeyManagerFactoryAlgo = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.trustStore");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.trustStore", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.trustStore");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslTrustStore = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.trustStoreType");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.trustStoreType", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.trustStoreType");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslTrustStoreType = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.trustStorePassword");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.trustStorePassword", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.trustStorePassword");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslTrustStorePassword = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.trustManagerFactory.algorithm");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslTrustManagerFactoryAlgo = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.walletLocation");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.walletLocation", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.walletLocation");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslWalletLocation = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.walletPassword");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.walletPassword", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.walletPassword");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSslWalletPassword = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.security.authentication");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.security.authentication", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.security.authentication");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSecurityAuthentication = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.security.principal");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.security.principal", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.security.principal");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSecurityPrincipal = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.security.credentials");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.security.credentials", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.security.credentials");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapSecurityCredetials = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ldap.ssl.ssl_context_protocol");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ldap.ssl.ssl_context_protocol", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ldap.ssl.ssl_context_protocol");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinLdapsslContextProtocol = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.proxyClientName");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.proxyClientName", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.proxyClientName");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.proxyClientName = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.useNio");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.useNio", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.useNio");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.useNio = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.httpsProxyHost");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.httpsProxyHost", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.httpsProxyHost");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinHttpsProxyHost = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.httpsProxyPort");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.httpsProxyPort", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.httpsProxyPort");
        }
        if (tempval == null) {
            tempval = "0";
        }
        try {
            this.thinHttpsProxyPort = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'thinHttpsProxyPort'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.localhostName");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.localhostName", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.localhostName");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.localHostName = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.connectionIdPrefix");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.connectionIdPrefix", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.connectionIdPrefix");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.thinNetConnectionIdPrefix = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("JDBCDriverCharSetId")) == null) {
            tempval = info.getProperty("oracle.jdbc.JDBCDriverCharSetId");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.JDBCDriverCharSetId", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("JDBCDriverCharSetId")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.JDBCDriverCharSetId");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.ociDriverCharset = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.editionName");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.editionName", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.editionName");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.editionName = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.thinLogonCapability");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.thinLogonCapability", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.thinLogonCapability");
        }
        if (tempval == null) {
            tempval = "o5";
        }
        this.logonCap = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.useOCIDefaultDefines");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.useOCIDefaultDefines", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.useOCIDefaultDefines");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.useOCIDefaultDefines = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("internal_logon")) == null) {
            tempval = info.getProperty("oracle.jdbc.internal_logon");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.internal_logon", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("internal_logon")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.internal_logon");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.internalLogon = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.createDescriptorUseCurrentSchemaForSchemaName = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("OCISvcCtxHandle")) == null) {
            tempval = info.getProperty("oracle.jdbc.OCISvcCtxHandle");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.OCISvcCtxHandle", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("OCISvcCtxHandle")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.OCISvcCtxHandle");
        }
        if (tempval == null) {
            tempval = "0";
        }
        try {
            this.ociSvcCtxHandle = Long.parseLong(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociSvcCtxHandle'").fillInStackTrace();
        }
        tempval = null;
        if (info != null && (tempval = info.getProperty("OCIEnvHandle")) == null) {
            tempval = info.getProperty("oracle.jdbc.OCIEnvHandle");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.OCIEnvHandle", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("OCIEnvHandle")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.OCIEnvHandle");
        }
        if (tempval == null) {
            tempval = "0";
        }
        try {
            this.ociEnvHandle = Long.parseLong(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociEnvHandle'").fillInStackTrace();
        }
        tempval = null;
        if (info != null && (tempval = info.getProperty("OCIErrHandle")) == null) {
            tempval = info.getProperty("oracle.jdbc.OCIErrHandle");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.OCIErrHandle", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("OCIErrHandle")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.OCIErrHandle");
        }
        if (tempval == null) {
            tempval = "0";
        }
        try {
            this.ociErrHandle = Long.parseLong(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ociErrHandle'").fillInStackTrace();
        }
        tempval = null;
        if (info != null && (tempval = info.getProperty("prelim_auth")) == null) {
            tempval = info.getProperty("oracle.jdbc.prelim_auth");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.prelim_auth", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("prelim_auth")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.prelim_auth");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.prelimAuth = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.jmsNotification");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.jmsNotification", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.jmsNotification");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.jmsNotificationConnection = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ociNlsLangBackwardCompatible", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.nlsLangBackdoor = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("defaultExecuteBatch")) == null) {
            tempval = info.getProperty("oracle.jdbc.defaultExecuteBatch");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.defaultExecuteBatch", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("defaultExecuteBatch")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.defaultExecuteBatch");
        }
        if (tempval == null) {
            tempval = "1";
        }
        try {
            this.defaultExecuteBatch = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultExecuteBatch'").fillInStackTrace();
        }
        tempval = null;
        if (info != null && (tempval = info.getProperty("defaultRowPrefetch")) == null) {
            tempval = info.getProperty("oracle.jdbc.defaultRowPrefetch");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.defaultRowPrefetch", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("defaultRowPrefetch")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.defaultRowPrefetch");
        }
        if (tempval == null) {
            tempval = "10";
        }
        try {
            this.defaultRowPrefetch = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultRowPrefetch'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.defaultLobPrefetchSize");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.defaultLobPrefetchSize", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.defaultLobPrefetchSize");
        }
        if (tempval == null) {
            tempval = "32768";
        }
        try {
            this.defaultLobPrefetchSize = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultLobPrefetchSize'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.enableDataInLocator");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableDataInLocator", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.enableDataInLocator");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.enableDataInLocator = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.enableReadDataInLocator");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableReadDataInLocator", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.enableReadDataInLocator");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.enableReadDataInLocator = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.overrideEnableReadDataInLocator");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.overrideEnableReadDataInLocator", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.overrideEnableReadDataInLocator");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.overrideEnableReadDataInLocator = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("remarksReporting")) == null) {
            tempval = info.getProperty("oracle.jdbc.remarksReporting");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.remarksReporting", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("remarksReporting")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.remarksReporting");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.reportRemarks = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("includeSynonyms")) == null) {
            tempval = info.getProperty("oracle.jdbc.includeSynonyms");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.includeSynonyms", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("includeSynonyms")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.includeSynonyms");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.includeSynonyms = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("restrictGetTables")) == null) {
            tempval = info.getProperty("oracle.jdbc.restrictGetTables");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.restrictGetTables", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("restrictGetTables")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.restrictGetTables");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.restrictGettables = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("AccumulateBatchResult")) == null) {
            tempval = info.getProperty("oracle.jdbc.AccumulateBatchResult");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.AccumulateBatchResult", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("AccumulateBatchResult")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.AccumulateBatchResult");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.accumulateBatchResult = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("useFetchSizeWithLongColumn")) == null) {
            tempval = info.getProperty("oracle.jdbc.useFetchSizeWithLongColumn");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.useFetchSizeWithLongColumn", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("useFetchSizeWithLongColumn")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.useFetchSizeWithLongColumn");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.useFetchSizeWithLongColumn = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("processEscapes")) == null) {
            tempval = info.getProperty("oracle.jdbc.processEscapes");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.processEscapes", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("processEscapes")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.processEscapes");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.processEscapes = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("fixedString")) == null) {
            tempval = info.getProperty("oracle.jdbc.fixedString");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.fixedString", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("fixedString")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.fixedString");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.fixedString = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("defaultNChar")) == null) {
            tempval = info.getProperty("oracle.jdbc.defaultNChar");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.defaultNChar", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("defaultNChar")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.defaultNChar");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.defaultnchar = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.permitTimestampDateMismatch = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("RessourceManagerId")) == null) {
            tempval = info.getProperty("oracle.jdbc.RessourceManagerId");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.RessourceManagerId", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("RessourceManagerId")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.RessourceManagerId");
        }
        if (tempval == null) {
            tempval = "0000";
        }
        this.resourceManagerId = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("disableDefineColumnType")) == null) {
            tempval = info.getProperty("oracle.jdbc.disableDefineColumnType");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.disableDefineColumnType", null);
        }
        if (tempval == null && fromFile != null && (tempval = fromFile.getProperty("disableDefineColumnType")) == null) {
            tempval = fromFile.getProperty("oracle.jdbc.disableDefineColumnType");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.disableDefinecolumntype = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.convertNcharLiterals");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.convertNcharLiterals", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.convertNcharLiterals");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.convertNcharLiterals = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.autoCommitSpecCompliant");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.autoCommitSpecCompliant", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.autoCommitSpecCompliant");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.autoCommitSpecCompliant = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.JDBCStandardBehavior");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.JDBCStandardBehavior", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.JDBCStandardBehavior");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.jdbcStandardBehavior = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.J2EE13Compliant");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.J2EE13Compliant", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.J2EE13Compliant");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.j2ee13Compliant = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null && (tempval = info.getProperty("DMSName")) == null) {
            tempval = info.getProperty("oracle.jdbc.DMSName");
        }
        if (tempval == null) {
            tempval = "Driver";
        }
        this.dmsParentName = tempval;
        tempval = null;
        if (info != null && (tempval = info.getProperty("DMSType")) == null) {
            tempval = info.getProperty("oracle.jdbc.DMSType");
        }
        if (tempval == null) {
            tempval = "JDBC_Driver";
        }
        this.dmsParentType = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.DMSStatementMetrics");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.dmsStmtMetrics = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.DMSStatementCachingMetrics");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.dmsStmtCachingMetrics = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.mapDateToTimestamp");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.mapDateToTimestamp", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.mapDateToTimestamp");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.mapDateToTimestamp = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.useThreadLocalBufferCache");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.useThreadLocalBufferCache", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.useThreadLocalBufferCache");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.useThreadLocalBufferCache = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.driverNameAttribute");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.driverNameAttribute", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.driverNameAttribute");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.driverNameAttribute = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.maxCachedBufferSize");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.maxCachedBufferSize", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.maxCachedBufferSize");
        }
        if (tempval == null) {
            tempval = "30";
        }
        try {
            this.maxCachedBufferSize = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'maxCachedBufferSize'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.implicitStatementCacheSize");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.implicitStatementCacheSize", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.implicitStatementCacheSize");
        }
        if (tempval == null) {
            tempval = "0";
        }
        try {
            this.implicitStatementCacheSize = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'implicitStatementCacheSize'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.LobStreamPosStandardCompliant");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.LobStreamPosStandardCompliant", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.LobStreamPosStandardCompliant");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.lobStreamPosStandardCompliant = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.strictASCIIConversion");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.strictASCIIConversion", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.strictASCIIConversion");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.isStrictAsciiConversion = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.quickASCIIConversion");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.quickASCIIConversion", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.quickASCIIConversion");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.isQuickAsciiConversion = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.DRCPConnectionClass");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.DRCPConnectionClass", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.DRCPConnectionClass");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.drcpConnectionClass = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.DRCPTagName");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.drcpTagName = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.DRCPConnectionPurity");
        }
        if (tempval == null) {
            tempval = "SELF";
        }
        this.drcpConnectionPurity = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.UseDRCPMultipletag");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.useDRCPMultipletag = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.DRCPPLSQLCallback");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.drcpPLSQLCallback = tempval;
        tempval = null;
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.blockSourceImplementation", null);
        }
        if (tempval == null) {
            tempval = "THREADED";
        }
        this.blockSourceImpl = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.thinForceDNSLoadBalancing");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.thinForceDNSLoadBalancing", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.thinForceDNSLoadBalancing");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.thinForceDnsLoadBalancing = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.enableTempLobRefCnt");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableTempLobRefCnt", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.enableTempLobRefCnt");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.enableTempLobRefCnt = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.keepAlive");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.keepAlive", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.keepAlive");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.keepAlive = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.sqlTranslationProfile");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.sqlTranslationProfile", null);
        }
        if (tempval == null) {
            tempval = null;
        }
        this.sqlTranslationProfile = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.sqlErrorTranslationFile");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.sqlErrorTranslationFile", null);
        }
        if (tempval == null) {
            tempval = null;
        }
        this.sqlErrorTranslationFile = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ignoreReplayContextFromAuthentication");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.ignoreReplayContextFromAuthentication = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.javaNetNio");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.javaNetNio", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.javaNetNio");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.javaNetNio = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.nsDirectBuffer");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.nsDirectBuffer", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.nsDirectBuffer");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.nsDirectBuffer = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.plsqlVarcharParameter4KOnly");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.plsqlVarcharParameter4KOnly", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.plsqlVarcharParameter4KOnly");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.plsqlVarcharParameter4KOnly = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.targetInstanceName");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.targetInstanceName", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.targetInstanceName");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.targetInstanceName = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.targetServiceName");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.targetServiceName = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.targetShardingKey");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.targetShardingKey = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.targetSuperShardingKey");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.targetSuperShardingKey = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.readOnlyInstanceAllowed");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.readOnlyInstanceAllowed", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.readOnlyInstanceAllowed");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.readOnlyInstanceAllowed = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.enableOCIFastApplicationNotification");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableOCIFastApplicationNotification", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.enableOCIFastApplicationNotification");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.enableOCIFAN = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.enableResultSetCache");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableResultSetCache", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.enableResultSetCache");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.isResultSetCacheEnabled_IGNORED = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.enableResultSetCache");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableResultSetCache", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.enableResultSetCache");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.isResultSetCacheEnabled_IGNORED2 = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.enableQueryResultCache");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableQueryResultCache", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.enableQueryResultCache");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.isResultSetCacheEnabled = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.backwardCompatibileUpdateableResultSet");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.backwardCompatibileUpdateableResultSet", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.backwardCompatibileUpdateableResultSet");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.isOldUpdateableResultSet = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.allowedLogonVersion");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.allowedLogonVersion", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.allowedLogonVersion");
        }
        if (tempval == null) {
            tempval = "8";
        }
        this.allowedLogonVersion = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.commitOption");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.commitOption", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.commitOption");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.commitOptionProperty = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.calculateChecksum");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.calculateChecksum", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.calculateChecksum");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.calculateChecksumProperty = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.javaNetLocalIPForMsgq");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.javaNetLocalIPForMsgq", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.javaNetLocalIPForMsgq");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.javaNetLocalIPForMsgq = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.javaNetMsgqTransport");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.javaNetMsgqTransport", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.javaNetMsgqTransport");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.javaNetMsgqTransport = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.javaNetMsgqBusyWait");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.javaNetMsgqBusyWait", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.javaNetMsgqBusyWait");
        }
        if (tempval == null) {
            tempval = "40";
        }
        try {
            this.javaNetMsgqBusyWait = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'javaNetMsgqBusyWait'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.javaNetMsgqKernelWait");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.javaNetMsgqKernelWait", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.javaNetMsgqKernelWait");
        }
        if (tempval == null) {
            tempval = "50";
        }
        try {
            this.javaNetMsgqKernelWait = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'javaNetMsgqKernelWait'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.DOWN_HOSTS_TIMEOUT");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.DOWN_HOSTS_TIMEOUT", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.DOWN_HOSTS_TIMEOUT");
        }
        if (tempval == null) {
            tempval = "600";
        }
        try {
            this.downHostsTimeout = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'downHostsTimeout'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.fanEnabled");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.fanEnabled", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.fanEnabled");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.fanEnabled = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.tns_admin");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.tns_admin", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.tns_admin");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.tnsAdmin = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.networkCompression");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.networkCompression", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.networkCompression");
        }
        if (tempval == null) {
            tempval = "off";
        }
        this.networkCompression = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.networkCompressionLevels");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.networkCompressionLevels", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.networkCompressionLevels");
        }
        if (tempval == null) {
            tempval = "(high)";
        }
        this.networkCompressionLevels = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.networkCompressionThreshold");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.networkCompressionThreshold", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.networkCompressionThreshold");
        }
        if (tempval == null) {
            tempval = "1024";
        }
        try {
            this.networkCompressionThreshold = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'networkCompressionThreshold'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.config.file");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.config.file", null);
        }
        if (tempval == null) {
            tempval = null;
        }
        this.configFile = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.websocketUser");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.websocketUser", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.websocketUser");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.websocketUser = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.websocketPassword");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.websocketPassword", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.websocketPassword");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.websocketPassword = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.socksProxyHost");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.socksProxyHost", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.socksProxyHost");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.socksProxyHost = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.socksProxyPort");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.socksProxyPort", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.socksProxyPort");
        }
        if (tempval == null) {
            tempval = "1080";
        }
        try {
            this.socksProxyPort = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'socksProxyPort'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.socksRemoteDNS");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.socksRemoteDNS", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.socksRemoteDNS");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.socksRemoteDNS = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.defaultConnectionValidation");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.defaultConnectionValidation", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.defaultConnectionValidation");
        }
        if (tempval == null) {
            tempval = "NETWORK";
        }
        try {
            this.defaultConnectionValidation = OracleConnection.ConnectionValidation.valueOf(tempval);
        }
        catch (IllegalArgumentException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'defaultConnectionValidation'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.enableACSupport");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableACSupport", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.enableACSupport");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.enableACSupport = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.enableTGSupport");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableTGSupport", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.enableTGSupport");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.enableTGSupport = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.enableImplicitRequests");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableImplicitRequests", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.enableImplicitRequests");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.enableImplicitRequests = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.enableSSSCursor");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableSSSCursor", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.enableSSSCursor");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.enableSSSCursor = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.DRCPMultiplexingInRequestAPIs");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.DRCPMultiplexingInRequestAPIs", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.DRCPMultiplexingInRequestAPIs");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.drcpMultiplexingInRequestAPIs = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.continueBatchOnError");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.continueBatchOnError", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.continueBatchOnError");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.continueBatchOnError = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.TCP_KEEPIDLE");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.TCP_KEEPIDLE", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.TCP_KEEPIDLE");
        }
        if (tempval == null) {
            tempval = "-1";
        }
        try {
            this.tcpKeepIdle = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'tcpKeepIdle'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.TCP_KEEPINTERVAL");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.TCP_KEEPINTERVAL", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.TCP_KEEPINTERVAL");
        }
        if (tempval == null) {
            tempval = "-1";
        }
        try {
            this.tcpKeepInterval = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'tcpKeepInterval'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.useShardingDriverConnection");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.useShardingDriverConnection", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.useShardingDriverConnection");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.useShardingDriverConnection = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.TCP_KEEPCOUNT");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.TCP_KEEPCOUNT", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.TCP_KEEPCOUNT");
        }
        if (tempval == null) {
            tempval = "-1";
        }
        try {
            this.tcpKeepCount = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'tcpKeepCount'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.replay.protectedRequestSizeLimit");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.replay.protectedRequestSizeLimit", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.replay.protectedRequestSizeLimit");
        }
        if (tempval == null) {
            tempval = "2147483647";
        }
        try {
            this.requestSizeLimit = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'requestSizeLimit'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ons.walletfile");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ons.walletfile", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.ons.walletfile");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.onsWalletFile = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ons.walletpassword");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ons.walletpassword", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.ons.walletpassword");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.onsWalletPassword = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ons.protocol");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ons.protocol", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.ons.protocol");
        }
        if (tempval == null) {
            tempval = "TCP";
        }
        this.onsProtocol = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.loginTimeout");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.loginTimeout", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.loginTimeout");
        }
        if (tempval == null) {
            tempval = "0";
        }
        try {
            this.loginTimeout = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'loginTimeout'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.inbandNotification");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.inbandNotification", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.inbandNotification");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.inbandNotification = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.ssl_context_protocol");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.ssl_context_protocol", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.ssl_context_protocol");
        }
        if (tempval == null) {
            tempval = "TLS";
        }
        this.sslContextProtocol = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.fetchSizeTuning");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.fetchSizeTuning", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.fetchSizeTuning");
        }
        if (tempval == null) {
            tempval = "8";
        }
        try {
            this.fetchSizeTuning = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'fetchSizeTuning'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.useTrueCacheDriverConnection");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.useTrueCacheDriverConnection", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.useTrueCacheDriverConnection");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.useTrueCacheDriverConnection = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.diagnostic.permitSensitiveDiagnostics", null);
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.isPermitSensitiveDiagnostics = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.diagnostic.enableSensitiveDiagnostics");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.diagnostic.enableSensitiveDiagnostics", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.diagnostic.enableSensitiveDiagnostics");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.isSensitiveDiagnosticsEnabled = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.diagnostic.loggerName");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.diagnostic.loggerName", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.diagnostic.loggerName");
        }
        if (tempval == null) {
            tempval = "oracle.jdbc";
        }
        this.diagnosticLoggerName = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.diagnostic.bufferSize");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.diagnostic.bufferSize", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.diagnostic.bufferSize");
        }
        if (tempval == null) {
            tempval = "1000";
        }
        try {
            this.diagnosticBufferSize = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'diagnosticBufferSize'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.diagnostic.enableDiagnoseFirstFailure");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.diagnostic.enableDiagnoseFirstFailure", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.diagnostic.enableDiagnoseFirstFailure");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.isDiagnoseFirstFailureEnabled = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.diagnostic.enableLogging");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.diagnostic.enableLogging", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.diagnostic.enableLogging");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.isLoggingEnabled = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.diagnostic.enableObservability", null);
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.isObservabilityEnabled = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.diagnostic.writeLogsToDiagnoseFirstFailure", null);
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.isWriteLogsToDiagnoseFirstFailure = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.diagnostic.debugTenant");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.diagnostic.debugTenant", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.diagnostic.debugTenant");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.debugTenants = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.diagnostic.debugSQL");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.diagnostic.debugSQL", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.diagnostic.debugSQL");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.debugSQLs = tempval;
        tempval = null;
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.diagnostic.enableMetrics", null);
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.isMetricsEnabled = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.tokenAuthentication");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.tokenAuthentication", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.tokenAuthentication");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.tokenAuthentication = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.tokenLocation");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.tokenLocation", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.tokenLocation");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.tokenLocation = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.passwordAuthentication");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.passwordAuthentication", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.passwordAuthentication");
        }
        if (tempval == null) {
            tempval = "PASSWORD_VERIFIER";
        }
        this.passwordAuthentication = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ociIamUrl");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ociIamUrl", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.ociIamUrl");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.ociIamUrl = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ociTenancy");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ociTenancy", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.ociTenancy");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.ociTenancy = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ociCompartment");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ociCompartment", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.ociCompartment");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.ociCompartment = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ociDatabase");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ociDatabase", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.ociDatabase");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.ociDatabase = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.commitSelectOnAutocommit");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.commitSelectOnAutocommit", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.commitSelectOnAutocommit");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.commitSelectOnAutocommit = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.jsonDefaultGetObjectType");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.jsonDefaultGetObjectType", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.jsonDefaultGetObjectType");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.jsonDefaultGetObjectType = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.accessToken");
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.accessToken");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.accessToken = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.retainLobPrefetchData");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.retainLobPrefetchData", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.retainLobPrefetchData");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.isLobPrefetchDataRetained = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ociConfigFile");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ociConfigFile", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.ociConfigFile");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.ociConfigFile = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.ociProfile");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.ociProfile", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.ociProfile");
        }
        if (tempval == null) {
            tempval = "DEFAULT";
        }
        this.ociProfile = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.azureDatabaseApplicationIdUri");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.azureDatabaseApplicationIdUri", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.azureDatabaseApplicationIdUri");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.azureDatabaseApplicationIdUri = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.tenantId");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.tenantId", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.tenantId");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.tenantId = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.clientId");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.clientId", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.clientId");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.clientId = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.clientSecret");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.clientSecret", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.clientSecret");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.clientSecret = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.clientCertificate");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.clientCertificate", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.clientCertificate");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.clientCertificate = tempval;
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.clientCertificatePassword");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.clientCertificatePassword", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.clientCertificatePassword");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.clientCertificatePassword = OpaqueString.newOpaqueString(tempval);
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.redirectUri");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.redirectUri", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.redirectUri");
        }
        if (tempval == null) {
            tempval = null;
        }
        this.redirectUri = tempval;
        tempval = null;
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.enableErrorUrl", null);
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.enableErrorUrl = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.asyncCursorLimit");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.asyncCursorLimit", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.asyncCursorLimit");
        }
        if (tempval == null) {
            tempval = "0.2";
        }
        try {
            this.asyncCursorLimit = Float.parseFloat(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'asyncCursorLimit'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.parameterMetadataPreprocess");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.parameterMetadataPreprocess", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.parameterMetadataPreprocess");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.parameterMetadataPreprocess = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.parameterMetadataCacheSize", null);
        }
        if (tempval == null) {
            tempval = "0";
        }
        try {
            this.parameterMetadataCacheSize = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'parameterMetadataCacheSize'").fillInStackTrace();
        }
        tempval = null;
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.parameterMetadataCacheIncludeParsing", null);
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.parameterMetadataCacheIncludeParsing = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.remoteConfigurationFiltering");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.remoteConfigurationFiltering", null);
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.remoteConfigurationFiltering = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.TTCCookieCacheSize", null);
        }
        if (tempval == null) {
            tempval = "50";
        }
        try {
            this.ttcCookieCacheSize = Integer.parseInt(tempval);
        }
        catch (NumberFormatException nfe) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 190, "Property is 'ttcCookieCacheSize'").fillInStackTrace();
        }
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.net.TTCCookieOptimizationEnabled");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.net.TTCCookieOptimizationEnabled", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.net.TTCCookieOptimizationEnabled");
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.ttcCookieOptimizationEnabled = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.sendAllDataForValueLobs");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.sendAllDataForValueLobs", null);
        }
        if (tempval == null && fromFile != null) {
            tempval = fromFile.getProperty("oracle.jdbc.sendAllDataForValueLobs");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.sendAllDataForValueLobs = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.sendBooleanInPLSQL");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.sendBooleanInPLSQL", null);
        }
        if (tempval == null) {
            tempval = "true";
        }
        this.sendBooleanInPLSQL = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.databaseStateRequirement");
        }
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.databaseStateRequirement", null);
        }
        if (tempval == null) {
            tempval = "NOMOUNT";
        }
        this.databaseStateRequirement = tempval;
        tempval = null;
        if (tempval == null) {
            tempval = GeneratedPhysicalConnection.getSystemProperty("oracle.jdbc.allowMixingJdbcAndNamedBinds", null);
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.allowMixingJdbcAndNamedBinds = tempval != null && tempval.equalsIgnoreCase("true");
        tempval = null;
        if (info != null) {
            tempval = info.getProperty("oracle.jdbc.allowSingleShardTransactionSupport");
        }
        if (tempval == null) {
            tempval = "false";
        }
        this.allowSingleShardTransactionSupport = tempval != null && tempval.equalsIgnoreCase("true");
        this.readDeprecatedConnectionProperties(info);
    }

    static {
        providerAllowedProperties.add("password");
        providerAllowedProperties.add("URL");
        providerAllowedProperties.add("oracle.jdbc.RetainV9LongBindBehavior");
        providerAllowedProperties.add("user");
        providerAllowedProperties.add("database");
        providerAllowedProperties.add("autoCommit");
        providerAllowedProperties.add("oracle.jdbc.bindUseDBA");
        providerAllowedProperties.add("protocol");
        providerAllowedProperties.add("oracle.jdbc.StreamChunkSize");
        providerAllowedProperties.add("SetFloatAndDoubleUseBinary");
        providerAllowedProperties.add("v$session.terminal");
        providerAllowedProperties.add("v$session.machine");
        providerAllowedProperties.add("v$session.osuser");
        providerAllowedProperties.add("v$session.program");
        providerAllowedProperties.add("v$session.process");
        providerAllowedProperties.add("v$session.iname");
        providerAllowedProperties.add("v$session.ename");
        providerAllowedProperties.add("oracle.net.profile");
        providerAllowedProperties.add("oracle.net.setFIPSMode");
        providerAllowedProperties.add("oracle.jdbc.debugJDWP");
        providerAllowedProperties.add("oracle.net.allow_weak_crypto");
        providerAllowedProperties.add("oracle.net.encryption_client");
        providerAllowedProperties.add("oracle.net.encryption_types_client");
        providerAllowedProperties.add("oracle.net.crypto_checksum_client");
        providerAllowedProperties.add("oracle.net.crypto_checksum_types_client");
        providerAllowedProperties.add("oracle.net.crypto_seed");
        providerAllowedProperties.add("oracle.net.useJCEAPI");
        providerAllowedProperties.add("oracle.jdbc.TcpNoDelay");
        providerAllowedProperties.add("oracle.jdbc.ReadTimeout");
        providerAllowedProperties.add("oracle.net.OUTBOUND_CONNECT_TIMEOUT");
        providerAllowedProperties.add("oracle.net.CONNECT_TIMEOUT");
        providerAllowedProperties.add("oracle.net.disableOob");
        providerAllowedProperties.add("oracle.net.useZeroCopyIO");
        providerAllowedProperties.add("oracle.jdbc.use1900AsYearForTime");
        providerAllowedProperties.add("oracle.jdbc.timestampTzInGmt");
        providerAllowedProperties.add("oracle.jdbc.timezoneAsRegion");
        providerAllowedProperties.add("oracle.net.ssl_certificate_alias");
        providerAllowedProperties.add("oracle.net.ssl_server_dn_match");
        providerAllowedProperties.add("oracle.net.ssl_server_cert_dn");
        providerAllowedProperties.add("oracle.net.ssl_allow_weak_dn_match");
        providerAllowedProperties.add("oracle.net.ssl_version");
        providerAllowedProperties.add("oracle.net.ssl_cipher_suites");
        providerAllowedProperties.add("javax.net.ssl.keyStoreType");
        providerAllowedProperties.add("javax.net.ssl.keyStorePassword");
        providerAllowedProperties.add("javax.net.ssl.trustStoreType");
        providerAllowedProperties.add("javax.net.ssl.trustStorePassword");
        providerAllowedProperties.add("ssl.keyManagerFactory.algorithm");
        providerAllowedProperties.add("ssl.trustManagerFactory.algorithm");
        providerAllowedProperties.add("oracle.net.oldSyntax");
        providerAllowedProperties.add("oracle.net.wallet_location");
        providerAllowedProperties.add("oracle.net.wallet_password");
        providerAllowedProperties.add("oracle.jdbc.proxyClientName");
        providerAllowedProperties.add("oracle.jdbc.useNio");
        providerAllowedProperties.add("oracle.net.httpsProxyHost");
        providerAllowedProperties.add("oracle.net.httpsProxyPort");
        providerAllowedProperties.add("oracle.jdbc.localhostName");
        providerAllowedProperties.add("oracle.net.connectionIdPrefix");
        providerAllowedProperties.add("JDBCDriverCharSetId");
        providerAllowedProperties.add("oracle.jdbc.editionName");
        providerAllowedProperties.add("oracle.jdbc.thinLogonCapability");
        providerAllowedProperties.add("oracle.jdbc.useOCIDefaultDefines");
        providerAllowedProperties.add("internal_logon");
        providerAllowedProperties.add("oracle.jdbc.createDescriptorUseCurrentSchemaForSchemaName");
        providerAllowedProperties.add("OCISvcCtxHandle");
        providerAllowedProperties.add("OCIEnvHandle");
        providerAllowedProperties.add("OCIErrHandle");
        providerAllowedProperties.add("prelim_auth");
        providerAllowedProperties.add("oracle.jdbc.jmsNotification");
        providerAllowedProperties.add("oracle.jdbc.ociNlsLangBackwardCompatible");
        providerAllowedProperties.add("defaultExecuteBatch");
        providerAllowedProperties.add("defaultRowPrefetch");
        providerAllowedProperties.add("oracle.jdbc.defaultLobPrefetchSize");
        providerAllowedProperties.add("oracle.jdbc.enableDataInLocator");
        providerAllowedProperties.add("oracle.jdbc.enableReadDataInLocator");
        providerAllowedProperties.add("oracle.jdbc.overrideEnableReadDataInLocator");
        providerAllowedProperties.add("remarksReporting");
        providerAllowedProperties.add("includeSynonyms");
        providerAllowedProperties.add("restrictGetTables");
        providerAllowedProperties.add("AccumulateBatchResult");
        providerAllowedProperties.add("useFetchSizeWithLongColumn");
        providerAllowedProperties.add("processEscapes");
        providerAllowedProperties.add("fixedString");
        providerAllowedProperties.add("defaultNChar");
        providerAllowedProperties.add("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch");
        providerAllowedProperties.add("RessourceManagerId");
        providerAllowedProperties.add("disableDefineColumnType");
        providerAllowedProperties.add("oracle.jdbc.convertNcharLiterals");
        providerAllowedProperties.add("oracle.jdbc.autoCommitSpecCompliant");
        providerAllowedProperties.add("oracle.jdbc.JDBCStandardBehavior");
        providerAllowedProperties.add("oracle.jdbc.J2EE13Compliant");
        providerAllowedProperties.add("oracle.jdbc.mapDateToTimestamp");
        providerAllowedProperties.add("oracle.jdbc.useThreadLocalBufferCache");
        providerAllowedProperties.add("oracle.jdbc.driverNameAttribute");
        providerAllowedProperties.add("oracle.jdbc.maxCachedBufferSize");
        providerAllowedProperties.add("oracle.jdbc.implicitStatementCacheSize");
        providerAllowedProperties.add("oracle.jdbc.LobStreamPosStandardCompliant");
        providerAllowedProperties.add("oracle.jdbc.strictASCIIConversion");
        providerAllowedProperties.add("oracle.jdbc.quickASCIIConversion");
        providerAllowedProperties.add("oracle.jdbc.DRCPConnectionClass");
        providerAllowedProperties.add("oracle.jdbc.thinForceDNSLoadBalancing");
        providerAllowedProperties.add("oracle.jdbc.enableTempLobRefCnt");
        providerAllowedProperties.add("oracle.net.keepAlive");
        providerAllowedProperties.add("oracle.jdbc.javaNetNio");
        providerAllowedProperties.add("oracle.jdbc.nsDirectBuffer");
        providerAllowedProperties.add("oracle.jdbc.plsqlVarcharParameter4KOnly");
        providerAllowedProperties.add("oracle.jdbc.targetInstanceName");
        providerAllowedProperties.add("oracle.jdbc.readOnlyInstanceAllowed");
        providerAllowedProperties.add("oracle.jdbc.enableOCIFastApplicationNotification");
        providerAllowedProperties.add("oracle.jdbc.enableResultSetCache");
        providerAllowedProperties.add("oracle.jdbc.enableResultSetCache");
        providerAllowedProperties.add("oracle.jdbc.enableQueryResultCache");
        providerAllowedProperties.add("oracle.jdbc.backwardCompatibileUpdateableResultSet");
        providerAllowedProperties.add("oracle.jdbc.allowedLogonVersion");
        providerAllowedProperties.add("oracle.jdbc.commitOption");
        providerAllowedProperties.add("oracle.jdbc.calculateChecksum");
        providerAllowedProperties.add("oracle.jdbc.javaNetLocalIPForMsgq");
        providerAllowedProperties.add("oracle.jdbc.javaNetMsgqTransport");
        providerAllowedProperties.add("oracle.jdbc.javaNetMsgqBusyWait");
        providerAllowedProperties.add("oracle.jdbc.javaNetMsgqKernelWait");
        providerAllowedProperties.add("oracle.net.DOWN_HOSTS_TIMEOUT");
        providerAllowedProperties.add("oracle.jdbc.fanEnabled");
        providerAllowedProperties.add("oracle.net.networkCompression");
        providerAllowedProperties.add("oracle.net.networkCompressionLevels");
        providerAllowedProperties.add("oracle.net.networkCompressionThreshold");
        providerAllowedProperties.add("oracle.net.websocketUser");
        providerAllowedProperties.add("oracle.net.websocketPassword");
        providerAllowedProperties.add("oracle.net.socksProxyHost");
        providerAllowedProperties.add("oracle.net.socksProxyPort");
        providerAllowedProperties.add("oracle.net.socksRemoteDNS");
        providerAllowedProperties.add("oracle.jdbc.defaultConnectionValidation");
        providerAllowedProperties.add("oracle.jdbc.enableACSupport");
        providerAllowedProperties.add("oracle.jdbc.enableTGSupport");
        providerAllowedProperties.add("oracle.jdbc.enableImplicitRequests");
        providerAllowedProperties.add("oracle.jdbc.enableSSSCursor");
        providerAllowedProperties.add("oracle.jdbc.DRCPMultiplexingInRequestAPIs");
        providerAllowedProperties.add("oracle.jdbc.continueBatchOnError");
        providerAllowedProperties.add("oracle.net.TCP_KEEPIDLE");
        providerAllowedProperties.add("oracle.net.TCP_KEEPINTERVAL");
        providerAllowedProperties.add("oracle.jdbc.useShardingDriverConnection");
        providerAllowedProperties.add("oracle.net.TCP_KEEPCOUNT");
        providerAllowedProperties.add("oracle.jdbc.replay.protectedRequestSizeLimit");
        providerAllowedProperties.add("oracle.jdbc.ons.walletpassword");
        providerAllowedProperties.add("oracle.jdbc.ons.protocol");
        providerAllowedProperties.add("oracle.jdbc.loginTimeout");
        providerAllowedProperties.add("oracle.jdbc.inbandNotification");
        providerAllowedProperties.add("oracle.net.ssl_context_protocol");
        providerAllowedProperties.add("oracle.jdbc.fetchSizeTuning");
        providerAllowedProperties.add("oracle.jdbc.useTrueCacheDriverConnection");
        providerAllowedProperties.add("oracle.jdbc.diagnostic.enableSensitiveDiagnostics");
        providerAllowedProperties.add("oracle.jdbc.diagnostic.loggerName");
        providerAllowedProperties.add("oracle.jdbc.diagnostic.bufferSize");
        providerAllowedProperties.add("oracle.jdbc.diagnostic.enableDiagnoseFirstFailure");
        providerAllowedProperties.add("oracle.jdbc.diagnostic.enableLogging");
        providerAllowedProperties.add("oracle.jdbc.diagnostic.debugTenant");
        providerAllowedProperties.add("oracle.jdbc.diagnostic.debugSQL");
        providerAllowedProperties.add("oracle.jdbc.tokenAuthentication");
        providerAllowedProperties.add("oracle.jdbc.tokenLocation");
        providerAllowedProperties.add("oracle.jdbc.passwordAuthentication");
        providerAllowedProperties.add("oracle.jdbc.ociIamUrl");
        providerAllowedProperties.add("oracle.jdbc.ociTenancy");
        providerAllowedProperties.add("oracle.jdbc.ociCompartment");
        providerAllowedProperties.add("oracle.jdbc.ociDatabase");
        providerAllowedProperties.add("oracle.jdbc.commitSelectOnAutocommit");
        providerAllowedProperties.add("oracle.jdbc.jsonDefaultGetObjectType");
        providerAllowedProperties.add("oracle.jdbc.accessToken");
        providerAllowedProperties.add("oracle.jdbc.retainLobPrefetchData");
        providerAllowedProperties.add("oracle.jdbc.ociProfile");
        providerAllowedProperties.add("oracle.jdbc.azureDatabaseApplicationIdUri");
        providerAllowedProperties.add("oracle.jdbc.tenantId");
        providerAllowedProperties.add("oracle.jdbc.clientId");
        providerAllowedProperties.add("oracle.jdbc.clientSecret");
        providerAllowedProperties.add("oracle.jdbc.clientCertificate");
        providerAllowedProperties.add("oracle.jdbc.clientCertificatePassword");
        providerAllowedProperties.add("oracle.jdbc.redirectUri");
    }
}

