/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.parameters.converters;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.jboss.resteasy.reactive.server.core.parameters.converters.TemporalParamConverter;

public class ZonedDateTimeParamConverter
extends TemporalParamConverter<ZonedDateTime> {
    public ZonedDateTimeParamConverter() {
        super(DateTimeFormatter.ISO_ZONED_DATE_TIME);
    }

    public ZonedDateTimeParamConverter(DateTimeFormatter formatter) {
        super(formatter);
    }

    @Override
    protected ZonedDateTime convert(String value) {
        return ZonedDateTime.parse(value);
    }

    @Override
    protected ZonedDateTime convert(String value, DateTimeFormatter formatter) {
        return ZonedDateTime.parse(value, formatter);
    }

    public static class Supplier
    extends TemporalParamConverter.TemporalSupplier<ZonedDateTimeParamConverter> {
        public Supplier() {
        }

        public Supplier(String pattern, String dateTimeFormatterProviderClassName) {
            super(pattern, dateTimeFormatterProviderClassName);
        }

        @Override
        protected ZonedDateTimeParamConverter createConverter(DateTimeFormatter dateTimeFormatter) {
            return new ZonedDateTimeParamConverter(dateTimeFormatter);
        }

        @Override
        public String getClassName() {
            return ZonedDateTimeParamConverter.class.getName();
        }
    }
}

