/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.infinispan.commons.configuration.io.xml.MXParser;
import org.infinispan.commons.configuration.io.xml.XmlPullParser;
import org.infinispan.commons.configuration.io.xml.XmlPullParserException;

public final class MavenSettings {
    private static MavenSettings mavenSettings;
    private Path settingsPath;
    private Path localRepository = null;
    private final List<String> remoteRepositories = new LinkedList<String>();
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();
    private final List<String> activeProfileNames = new LinkedList<String>();
    private final List<Proxy> proxies = new ArrayList<Proxy>();

    MavenSettings() {
        this.configureDefaults();
    }

    public static MavenSettings init() throws IOException {
        return MavenSettings.init(null);
    }

    public static MavenSettings init(Path settingsPath) throws IOException {
        String mavenHome;
        if (mavenSettings != null && Objects.equals(MavenSettings.mavenSettings.settingsPath, settingsPath)) {
            return mavenSettings;
        }
        mavenSettings = new MavenSettings();
        Path m2 = Paths.get(System.getProperty("user.home"), ".m2");
        if (settingsPath == null) {
            settingsPath = m2.resolve("settings.xml");
        }
        if (Files.notExists(settingsPath, new LinkOption[0]) && (mavenHome = System.getenv("M2_HOME")) != null) {
            settingsPath = Paths.get(mavenHome, "conf", "settings.xml");
        }
        MavenSettings.mavenSettings.settingsPath = settingsPath;
        if (Files.exists(settingsPath, new LinkOption[0])) {
            MavenSettings.parseSettingsXml(settingsPath, mavenSettings);
        }
        if (mavenSettings.getLocalRepository() == null) {
            Path repository = m2.resolve("repository");
            mavenSettings.setLocalRepository(repository);
        }
        mavenSettings.resolveActiveSettings();
        return mavenSettings;
    }

    static MavenSettings parseSettingsXml(Path settings, MavenSettings mavenSettings) throws IOException {
        try {
            int eventType;
            MXParser reader = new MXParser();
            reader.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", false);
            InputStream source = Files.newInputStream(settings, StandardOpenOption.READ);
            reader.setInput(source, null);
            while ((eventType = reader.next()) != 1) {
                switch (eventType) {
                    case 2: {
                        switch (reader.getName()) {
                            case "settings": {
                                MavenSettings.parseSettings(reader, mavenSettings);
                            }
                        }
                    }
                }
            }
            return mavenSettings;
        }
        catch (XmlPullParserException e) {
            throw new IOException("Could not parse maven settings.xml");
        }
    }

    static void parseSettings(XmlPullParser reader, MavenSettings mavenSettings) throws XmlPullParserException, IOException {
        int eventType;
        block34: while ((eventType = reader.nextTag()) != 1) {
            switch (eventType) {
                case 3: {
                    return;
                }
                case 2: {
                    switch (reader.getName()) {
                        case "localRepository": {
                            String localRepository = reader.nextText();
                            boolean localRepositoryNotDefinedViaProperty = mavenSettings.getLocalRepository() == null;
                            if (!localRepositoryNotDefinedViaProperty || localRepository == null || localRepository.trim().isEmpty()) continue block34;
                            mavenSettings.setLocalRepository(Paths.get(MavenSettings.interpolateVariables(localRepository), new String[0]));
                            continue block34;
                        }
                        case "proxies": {
                            while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
                                switch (reader.getName()) {
                                    case "proxy": {
                                        MavenSettings.parseProxy(reader, mavenSettings);
                                    }
                                }
                            }
                            continue block34;
                        }
                        case "profiles": {
                            while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
                                switch (reader.getName()) {
                                    case "profile": {
                                        MavenSettings.parseProfile(reader, mavenSettings);
                                    }
                                }
                            }
                            continue block34;
                        }
                        case "activeProfiles": {
                            while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
                                switch (reader.getName()) {
                                    case "activeProfile": {
                                        mavenSettings.addActiveProfile(reader.nextText());
                                    }
                                }
                            }
                            continue block34;
                        }
                    }
                    MavenSettings.skip(reader);
                    continue block34;
                }
            }
            throw new IOException("Unexpected content");
        }
        throw new IOException("Unexpected end of document");
    }

    static void parseProxy(XmlPullParser reader, MavenSettings mavenSettings) throws XmlPullParserException, IOException {
        int eventType;
        Proxy proxy = new Proxy();
        block20: while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
            switch (reader.getName()) {
                case "id": {
                    proxy.setId(reader.nextText());
                    continue block20;
                }
                case "active": {
                    proxy.setActive(Boolean.parseBoolean(reader.nextText()));
                    continue block20;
                }
                case "protocol": {
                    proxy.setProtocol(reader.nextText());
                    continue block20;
                }
                case "host": {
                    proxy.setHost(reader.nextText());
                    continue block20;
                }
                case "port": {
                    proxy.setPort(Integer.parseInt(reader.nextText()));
                    continue block20;
                }
                case "username": {
                    proxy.setUsername(reader.nextText());
                    continue block20;
                }
                case "password": {
                    proxy.setPassword(reader.nextText());
                    continue block20;
                }
                case "nonProxyHosts": {
                    proxy.setNonProxyHosts(reader.nextText());
                    continue block20;
                }
            }
            MavenSettings.skip(reader);
        }
        mavenSettings.addProxy(proxy);
    }

    static void parseProfile(XmlPullParser reader, MavenSettings mavenSettings) throws XmlPullParserException, IOException {
        int eventType;
        Profile profile = new Profile();
        block14: while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
            switch (reader.getName()) {
                case "id": {
                    profile.setId(reader.nextText());
                    continue block14;
                }
                case "repositories": {
                    while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
                        switch (reader.getName()) {
                            case "repository": {
                                MavenSettings.parseRepository(reader, profile);
                            }
                        }
                    }
                    continue block14;
                }
            }
            MavenSettings.skip(reader);
        }
        mavenSettings.addProfile(profile);
    }

    static void parseRepository(XmlPullParser reader, Profile profile) throws XmlPullParserException, IOException {
        int eventType;
        block6: while ((eventType = reader.nextTag()) != 1 && eventType == 2) {
            switch (reader.getName()) {
                case "url": {
                    profile.addRepository(reader.nextText());
                    continue block6;
                }
            }
            MavenSettings.skip(reader);
        }
    }

    static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        if (parser.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (parser.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void configureDefaults() {
        String remoteRepository;
        this.remoteRepositories.add("https://repo1.maven.org/maven2/");
        String localRepositoryPath = System.getProperty("local.maven.repo.path");
        if (localRepositoryPath != null && !localRepositoryPath.trim().isEmpty()) {
            System.out.println("Please use 'maven.repo.local' instead of 'local.maven.repo.path'");
            this.localRepository = Paths.get(localRepositoryPath.split(File.pathSeparator)[0], new String[0]);
        }
        if ((localRepositoryPath = System.getProperty("maven.repo.local")) != null && !localRepositoryPath.trim().isEmpty()) {
            this.localRepository = Paths.get(localRepositoryPath, new String[0]);
        }
        if ((remoteRepository = System.getProperty("remote.maven.repo")) != null) {
            for (String string : remoteRepository.split(",")) {
                void var6_6;
                if (!string.endsWith("/")) {
                    String string2 = string + "/";
                }
                this.remoteRepositories.add((String)var6_6);
            }
        }
    }

    public void setLocalRepository(Path localRepository) {
        this.localRepository = localRepository;
    }

    public Path getLocalRepository() {
        return this.localRepository;
    }

    public List<String> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void addProfile(Profile profile) {
        this.profiles.put(profile.getId(), profile);
    }

    public void addActiveProfile(String profileName) {
        this.activeProfileNames.add(profileName);
    }

    public void addProxy(Proxy proxy) {
        this.proxies.add(proxy);
    }

    public List<Proxy> getProxies() {
        return this.proxies;
    }

    public Proxy getProxyFor(URL url) {
        for (Proxy proxy : this.proxies) {
            if (!proxy.canProxyFor(url)) continue;
            return proxy;
        }
        return null;
    }

    public URLConnection openConnection(URL url) throws IOException {
        Proxy proxy = this.getProxyFor(url);
        URLConnection conn = null;
        if (proxy != null) {
            conn = url.openConnection(proxy.getProxy());
            proxy.authenticate(conn);
        } else {
            conn = url.openConnection();
        }
        return conn;
    }

    void resolveActiveSettings() {
        for (String name : this.activeProfileNames) {
            Profile p = this.profiles.get(name);
            if (p == null) continue;
            this.remoteRepositories.addAll(p.getRepositories());
        }
    }

    static String interpolateVariables(String in) {
        StringBuilder out = new StringBuilder();
        int cur = 0;
        int startLoc = -1;
        while ((startLoc = in.indexOf("${", cur)) >= 0) {
            String value;
            out.append(in.substring(cur, startLoc));
            int endLoc = in.indexOf("}", startLoc);
            if (endLoc > 0) {
                String name = in.substring(startLoc + 2, endLoc);
                value = null;
                value = name.startsWith("env.") ? System.getenv(name.substring(4)) : System.getProperty(name);
                if (value == null) {
                    value = "";
                }
            } else {
                out.append(in.substring(startLoc));
                cur = in.length();
                break;
            }
            out.append(value);
            cur = endLoc + 1;
        }
        out.append(in.substring(cur));
        return out.toString();
    }

    static final class Proxy {
        private String id;
        private boolean active = true;
        private String protocol = "http";
        private String host;
        private int port;
        private String username;
        private String password;
        private Set<NonProxyHost> nonProxyHosts = new HashSet<NonProxyHost>();
        private AtomicReference<java.net.Proxy> netProxy = new AtomicReference();

        Proxy() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setNonProxyHosts(String nonProxyHosts) {
            String[] specs = nonProxyHosts.split("\\|");
            this.nonProxyHosts.clear();
            for (String spec : specs) {
                this.nonProxyHosts.add(new NonProxyHost(spec));
            }
        }

        public boolean canProxyFor(URL url) {
            for (NonProxyHost nonProxyHost : this.nonProxyHosts) {
                if (!nonProxyHost.matches(url)) continue;
                return false;
            }
            return true;
        }

        public java.net.Proxy getProxy() {
            return this.netProxy.updateAndGet(proxy -> {
                if (proxy == null) {
                    proxy = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.getHost(), this.getPort()));
                }
                return proxy;
            });
        }

        public String getCredentialsBase64() {
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString((this.username + ":" + this.password).getBytes());
        }

        public void authenticate(URLConnection conn) {
            if (this.username == null && this.password == null) {
                return;
            }
            String authz = "Basic " + this.getCredentialsBase64();
            conn.addRequestProperty("Proxy-Authorization", authz);
        }
    }

    static final class Profile {
        private String id;
        final List<String> repositories = new LinkedList<String>();

        Profile() {
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void addRepository(String url) {
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            this.repositories.add((String)url);
        }

        public List<String> getRepositories() {
            return this.repositories;
        }
    }

    static final class NonProxyHost {
        private final Pattern pattern;

        NonProxyHost(String spec) {
            spec = ((String)spec).replace(".", "\\.");
            spec = ((String)spec).replace("*", ".*");
            spec = "^" + (String)spec + "$";
            this.pattern = Pattern.compile((String)spec);
        }

        boolean matches(URL url) {
            return this.pattern.matcher(url.getHost()).matches();
        }
    }
}

