/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.message.server;

import java.util.Objects;
import org.mariadb.jdbc.client.Column;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.message.ServerMessage;
import org.mariadb.jdbc.util.CharsetEncodingLength;

public class ColumnDefinitionPacket
implements Column,
ServerMessage {
    private final ReadableByteBuf buf;
    protected final int charset;
    protected final long columnLength;
    protected final DataType dataType;
    protected final byte decimals;
    private final int flags;
    private final int[] stringPos;
    protected final String extTypeName;
    protected final String extTypeFormat;
    private boolean useAliasAsName;

    public ColumnDefinitionPacket(ReadableByteBuf buf, int charset, long columnLength, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        this.buf = buf;
        this.charset = charset;
        this.columnLength = columnLength;
        this.dataType = dataType;
        this.decimals = decimals;
        this.flags = flags;
        this.stringPos = stringPos;
        this.extTypeName = extTypeName;
        this.extTypeFormat = extTypeFormat;
    }

    @Override
    public String getSchema() {
        this.buf.pos(this.stringPos[0]);
        return this.buf.readString(this.buf.readIntLengthEncodedNotNull());
    }

    @Override
    public String getTableAlias() {
        this.buf.pos(this.stringPos[1]);
        return this.buf.readString(this.buf.readIntLengthEncodedNotNull());
    }

    @Override
    public String getTable() {
        this.buf.pos(this.stringPos[this.useAliasAsName ? 1 : 2]);
        return this.buf.readString(this.buf.readIntLengthEncodedNotNull());
    }

    @Override
    public String getColumnAlias() {
        this.buf.pos(this.stringPos[3]);
        return this.buf.readString(this.buf.readIntLengthEncodedNotNull());
    }

    @Override
    public String getColumnName() {
        this.buf.pos(this.stringPos[4]);
        return this.buf.readString(this.buf.readIntLengthEncodedNotNull());
    }

    @Override
    public long getColumnLength() {
        return this.columnLength;
    }

    @Override
    public DataType getType() {
        return this.dataType;
    }

    @Override
    public byte getDecimals() {
        return this.decimals;
    }

    @Override
    public boolean isSigned() {
        return (this.flags & 0x20) == 0;
    }

    @Override
    public int getDisplaySize() {
        Integer maxWidth;
        if (!(this.isBinary() || this.dataType != DataType.VARCHAR && this.dataType != DataType.JSON && this.dataType != DataType.ENUM && this.dataType != DataType.SET && this.dataType != DataType.VARSTRING && this.dataType != DataType.STRING && this.dataType != DataType.BLOB && this.dataType != DataType.TINYBLOB && this.dataType != DataType.MEDIUMBLOB && this.dataType != DataType.LONGBLOB || (maxWidth = CharsetEncodingLength.maxCharlen.get(this.charset)) == null)) {
            return (int)(this.columnLength / (long)maxWidth.intValue());
        }
        return (int)this.columnLength;
    }

    @Override
    public boolean isPrimaryKey() {
        return (this.flags & 2) > 0;
    }

    @Override
    public boolean isAutoIncrement() {
        return (this.flags & 0x200) > 0;
    }

    @Override
    public boolean hasDefault() {
        return (this.flags & 0x1000) == 0;
    }

    @Override
    public boolean isBinary() {
        return this.charset == 63;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public String getExtTypeName() {
        return this.extTypeName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDefinitionPacket that = (ColumnDefinitionPacket)o;
        return this.charset == that.charset && this.columnLength == that.columnLength && this.dataType == that.dataType && this.decimals == that.decimals && this.flags == that.flags;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.charset, this.columnLength, this.dataType, this.decimals, this.flags});
    }

    @Override
    public void useAliasAsName() {
        this.useAliasAsName = true;
    }
}

