/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.function.Supplier;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.ByteCopyingBinder;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DirectPathBufferMarshaler;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4C8Oall;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CPreparedStatement;
import oracle.jdbc.driver.T4CRowidAccessor;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;

class T4CDirectPathPreparedStatement
extends T4CPreparedStatement {
    private int directPathCursor;
    static final int DPPSTMT_STATUS_UNKNOWN = 0;
    static final int DPPSTMT_STATUS_PREPARED = 1;
    static final int DPPSTMT_STATUS_LOAD_STREAM = 2;
    static final int DPPSTMT_STATUS_FINISH = 3;
    static final int DPPSTMT_STATUS_ABORT = 4;
    static final int DPPSTMT_STATUS_CLOSED = 5;
    private int directPathStatus;
    private final String schemaName;
    private final String tableName;
    private final String[] colNames;
    private final String partitionName;
    Properties dpStmtProps;
    private int rowInError;
    private boolean codePointCountingEnabled;
    private int[] maxCodePointCounts;
    private static final int DTYBRI_SIZE = 10;
    private static final String IS_DTYBRI_QUERY = "SELECT COUNT(*) FROM SYS.ALL_TAB_COLUMNS WHERE OWNER = ? AND TABLE_NAME = ? AND COLUMN_NAME = ? AND DATA_TYPE='ROWID'";
    private static final int QUERY_BIND_POS_SCHEMA = 1;
    private static final int QUERY_BIND_POS_TABLE = 2;
    private static final int QUERY_BIND_POS_COLUMN = 3;
    private int sdbaOfBits;
    private int sdbaBits;
    private int dbabBits;

    T4CDirectPathPreparedStatement(PhysicalConnection connection, String schemaName, String tableName, String[] colNames, String partitionName, OracleResultSet.ResultSetType resultSetType, @Blind(value=PropertiesBlinder.class) Properties dpStmtProps, String sql) throws SQLException {
        super(connection, sql, resultSetType);
        if (!this.bindUseDBA) {
            throw new IllegalStateException("Dynamic byte array storage of bind values must be enabled for direct path loads. (The oracle.jdbc.bindUseDBA connection property cannot be false)");
        }
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.colNames = colNames;
        this.partitionName = partitionName;
        this.dpStmtProps = dpStmtProps;
        this.directPathStatus = 0;
        this.rowInError = 0;
    }

    @Override
    public void registerReturnParameter(int paramIndex, int externalType) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public void registerReturnParameter(int paramIndex, int externalType, int maxSize) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public void registerReturnParameter(int paramIndex, int externalType, String typeName) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public ResultSet getReturnResultSet() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
    }

    static String getSQLStatement(String schemaName, String tableName, String[] colNames, String partitionName, PhysicalConnection conn) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        if (schemaName != null && schemaName.length() != 0) {
            sql.append(conn.enquoteIdentifier(schemaName, true));
            sql.append(".");
        }
        sql.append(conn.enquoteIdentifier(tableName, true));
        sql.append("(");
        boolean firstCol = true;
        for (String colName : colNames) {
            if (!firstCol) {
                sql.append(",");
            } else {
                firstCol = false;
            }
            sql.append(conn.enquoteIdentifier(colName, true));
        }
        sql.append(")");
        sql.append(" VALUES ");
        sql.append("(");
        for (int iCol = 0; iCol < colNames.length; ++iCol) {
            if (iCol != 0) {
                sql.append(",");
            }
            sql.append("?");
        }
        sql.append(")");
        if (partitionName != null) {
            sql.append("/* Partition Name:");
            sql.append(partitionName);
            sql.append(" */");
        }
        return sql.toString();
    }

    @Override
    public boolean execute() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.checkForDirectPathReprepare();
            boolean bl = super.execute();
            return bl;
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.checkForDirectPathReprepare();
            long l = super.executeLargeUpdate();
            return l;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.checkForDirectPathReprepare();
            int[] nArray = super.executeBatch();
            return nArray;
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.checkForDirectPathReprepare();
            long[] lArray = super.executeLargeBatch();
            return lArray;
        }
    }

    @Override
    void doOall8(T4C8Oall all8, boolean doParse, boolean doExecute, boolean doFetch, boolean doDescribe, boolean doDefine) throws SQLException, IOException {
        int number_of_bound_rows = 0;
        int number_of_bind_positions = 0;
        int[] errorOffsets = new int[2];
        if (this.bindIndicators != null) {
            number_of_bound_rows = ((this.bindIndicators[this.bindIndicatorSubRange + 3] & 0xFFFF) << 16) + (this.bindIndicators[this.bindIndicatorSubRange + 4] & 0xFFFF);
            number_of_bind_positions = this.bindIndicators[this.bindIndicatorSubRange + 0] & 0xFFFF;
        }
        this.rowInError = 0;
        this.validateBindLengths();
        this.validateStreamBindLengths();
        DirectPathBufferMarshaler.BufferPlanner bufferPlanner = DirectPathBufferMarshaler.createBufferPlanner(number_of_bound_rows, number_of_bind_positions, this.bindData, this.bindDataOffsets, this.bindDataLengths, this.parameterStream, this.accessors, this.t4Connection);
        try {
            this.t4Connection.directPathLoadStream(bufferPlanner, this.directPathCursor, errorOffsets);
        }
        catch (SQLException sqe) {
            this.rowInError = bufferPlanner.getRowByOffset(errorOffsets[0], errorOffsets[1]);
            throw sqe;
        }
        this.setDirectPathStatus(2);
    }

    @Override
    public void close() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.isDirectPathUncommitted()) {
                this.t4Connection.directPathAbort();
            }
            super.close();
            this.setDirectPathStatus(5);
            this.t4Connection.clearDirectPathState();
        }
    }

    @Override
    public void closeWithKey(String key) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.isDirectPathUncommitted()) {
                this.t4Connection.directPathAbort();
            }
            super.closeWithKey(key);
            this.setDirectPathStatus(5);
            this.t4Connection.clearDirectPathState();
        }
    }

    @Override
    public void setBlob(int paramIndex, Blob lob) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setBlob(int paramIndex, InputStream lob) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setBlob(int paramIndex, InputStream lob, long length) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setBLOB(int paramIndex, BLOB lob) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setBytesForBlob(int paramIndex, byte[] lob) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setClob(int paramIndex, Clob lob) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setClob(int paramIndex, Reader lob) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setClob(int paramIndex, Reader lob, long length) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setNClob(int paramIndex, NClob lob) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setNClob(int paramIndex, Reader lob) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setNClob(int paramIndex, Reader lob, long length) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setCLOB(int paramIndex, CLOB lob) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setStringForClob(int paramIndex, String lob) throws SQLException {
        throw this.lobBindsNotSupported();
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.requireSupportedType(sqlType);
        super.setNull(paramIndex, sqlType);
    }

    @Override
    public void setNull(int paramIndex, int sqlType) throws SQLException {
        this.requireSupportedType(sqlType);
        super.setNull(paramIndex, sqlType);
    }

    @Override
    void setObjectCritical(int paramIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.requireSupportedType(targetSqlType);
        super.setObjectCritical(paramIndex, x, targetSqlType, scale);
    }

    @Override
    void setBinaryStreamContentsForBlobCritical(int paramIndex, InputStream inputStream, long length, boolean isLengthSpecified) throws SQLException {
        this.bindInputStream(paramIndex, isLengthSpecified ? LengthLimiter.limitInputStream(inputStream, length) : inputStream);
    }

    @Override
    void setReaderContentsForClobCritical(int paramIndex, Reader reader, long length, boolean isLengthSpecified) throws SQLException {
        int index = paramIndex - 1;
        this.bindInputStream(paramIndex, this.connection.conversion.ConvertStream(isLengthSpecified ? LengthLimiter.limitReader(reader, length) : reader, this.getConversionCodeForCharacterStream(index), 0, this.currentRowFormOfUse[index]));
    }

    @Override
    void setStringForClobCritical(int paramIndex, String string) throws SQLException {
        this.setReaderContentsForClobCritical(paramIndex, new StringReader(string), 0L, false);
    }

    @Override
    void setAsciiStreamContentsForClobCritical(int paramIndex, InputStream asciiStream, long length, boolean isLengthSpecified) throws SQLException {
        this.setReaderContentsForClobCritical(paramIndex, new InputStreamReader(isLengthSpecified ? LengthLimiter.limitInputStream(asciiStream, length) : asciiStream, StandardCharsets.US_ASCII), length, false);
    }

    @Override
    void basicBindAsciiStream(int paramIndex, InputStream asciiStream, int length) throws SQLException {
        this.setAsciiStreamContentsForClobCritical(paramIndex, asciiStream, length, length != 0);
    }

    private void bindInputStream(int paramIndex, InputStream inputStream) {
        int index = paramIndex - 1;
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.currentRowBinders[index] = this.theLongRawStreamBinder;
            if (this.parameterStream == null) {
                this.parameterStream = new InputStream[this.numberOfBindRowsAllocated][this.numberOfBindPositions];
            }
            this.parameterStream[this.currentRank][index] = inputStream;
            this.currentRowByteLens[index] = 0;
            this.currentRowCharLens[index] = 0;
        }
    }

    private void requireSupportedType(int sqlType) throws SQLException {
        switch (sqlType) {
            case 2004: 
            case 2005: 
            case 2011: {
                throw this.lobBindsNotSupported();
            }
        }
    }

    void setDirectPathCursor(int directPathCursor) {
        this.directPathCursor = directPathCursor;
    }

    int getDirectPathCursor() {
        return this.directPathCursor;
    }

    int getDirectPathStatus() {
        return this.directPathStatus;
    }

    boolean isDirectPathUncommitted() {
        return this.directPathStatus == 1 || this.directPathStatus == 2;
    }

    boolean isDirectPathCommitted() {
        return this.directPathStatus == 3 || this.directPathStatus == 4;
    }

    boolean isDirectPathClosed() {
        return this.directPathStatus == 5;
    }

    void setDirectPathStatus(int directPathStatus) {
        this.directPathStatus = directPathStatus;
    }

    void checkForDirectPathReprepare() throws SQLException {
        try {
            if (this.isDirectPathCommitted()) {
                this.t4Connection.odpp.doODPP(this.schemaName, this.tableName, this.colNames, this.partitionName, this.dpStmtProps);
                int directPathCursor = (int)this.t4Connection.odpp.getO4Value(3);
                this.setDirectPathCursor(directPathCursor);
                this.setDirectPathStatus(1);
            }
        }
        catch (IOException ex) {
            ((T4CConnection)this.connection).handleIOException(ex);
            throw (SQLException)DatabaseError.createSqlException(ex).fillInStackTrace();
        }
    }

    @Override
    protected String getBatchUpdateErrorMessage() {
        if (this.rowInError > 0) {
            return " Row number " + this.rowInError + " causes batch load failure.";
        }
        return super.getBatchUpdateErrorMessage();
    }

    @Override
    void setupBindBuffers(int firstRow, int rowCount) throws SQLException {
        this.updateCodePointCounts(firstRow, rowCount);
        super.setupBindBuffers(firstRow, rowCount);
    }

    @Override
    final int getConversionCodeForCharacterStream(int index) {
        return this.bindRequiresUTF16(index) ? 14 : 16;
    }

    @Override
    void adjustCharLensForSetCHAR(int index, byte[] b) {
        this.currentRowCharLens[index] = 0;
        this.currentRowByteLens[index] = b.length;
    }

    void updateAccessors(Accessor[] describedAccessors) throws SQLException {
        assert (describedAccessors != null) : "describedAccessors is null";
        this.accessors = describedAccessors;
        this.initCodePointCounting();
        this.initRowIDAccessors();
    }

    @Override
    final CharacterSet getCharacterSetForBind(int index, short formOfUse) {
        DBConversion conversion = this.connection.conversion;
        return this.bindRequiresUTF16(index) ? CharacterSet.make(2000) : (2 == this.accessors[index].describeFormOfUse ? conversion.serverNCharSet : conversion.serverCharSet);
    }

    @Override
    protected Binder createRowidBinder(byte[] rowidBytes) throws SQLException {
        if (rowidBytes == null || rowidBytes.length == 0) {
            return this.createRowidNullBinder();
        }
        return new DirectPathRowIDBinder(rowidBytes);
    }

    private boolean bindRequiresUTF16(int pos) {
        Accessor acc = this.accessors[pos];
        DBConversion conversion = this.connection.conversion;
        if (112 != acc.describeType) {
            return false;
        }
        if (2 == acc.describeFormOfUse) {
            return !conversion.isServerNCharSetFixedWidth;
        }
        return conversion.isServerCSMultiByte && !conversion.isServerCharSetFixedWidth;
    }

    private boolean isCharacterSetFixedWidth(int pos) {
        Accessor acc = this.accessors[pos];
        DBConversion conversion = this.connection.conversion;
        if (this.bindRequiresUTF16(pos)) {
            return true;
        }
        if (2 == acc.describeFormOfUse) {
            return conversion.isServerNCharSetFixedWidth;
        }
        return !conversion.isServerCSMultiByte || conversion.isServerCharSetFixedWidth;
    }

    private final void initCodePointCounting() {
        this.codePointCountingEnabled = false;
        for (int i = 0; i < this.accessors.length; ++i) {
            if (!this.accessors[i].isLengthSemanticChar() || this.isCharacterSetFixedWidth(i)) continue;
            this.codePointCountingEnabled = true;
            break;
        }
        this.maxCodePointCounts = (int[])(this.codePointCountingEnabled ? new int[this.numberOfBindPositions] : null);
    }

    private void updateCodePointCounts(int rowOffset, int rowCount) {
        if (!this.codePointCountingEnabled) {
            return;
        }
        int endRow = rowOffset + rowCount;
        for (int pos = 0; pos < this.numberOfBindPositions; ++pos) {
            int max = 0;
            for (int row = rowOffset; row < endRow; ++row) {
                String bindVal = this.getStringBinderVal(row, pos);
                if (bindVal == null) {
                    max = Integer.MAX_VALUE;
                    break;
                }
                int count = bindVal.codePointCount(0, bindVal.length());
                if (count <= max) continue;
                max = count;
            }
            this.maxCodePointCounts[pos] = max;
        }
    }

    private int getMaxCodePointCount(int pos) {
        return this.codePointCountingEnabled ? this.maxCodePointCounts[pos] : Integer.MAX_VALUE;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateBindLengths() throws SQLException {
        int pos = 0;
        while (true) {
            block13: {
                if (pos >= this.numberOfBindPositions) {
                    return;
                }
                Accessor acc = this.accessors[pos];
                switch (acc.describeType) {
                    case 8: {
                        if (this.maxRawBytesSql > Integer.MAX_VALUE) {
                            break;
                        }
                        break block13;
                    }
                    case 24: {
                        if (this.maxRawBytesSql > Integer.MAX_VALUE) {
                            break;
                        }
                        break block13;
                    }
                    case 112: 
                    case 113: {
                        break block13;
                    }
                }
                int maxBytes = acc.describeMaxLength;
                if (!acc.isLengthSemanticChar() || this.isCharacterSetFixedWidth(pos)) {
                    this.validateByteLengths(pos, maxBytes);
                } else {
                    int maxChars = acc.describeMaxLengthChars;
                    if (maxChars >= this.getMaxCodePointCount(pos)) {
                        this.validateByteLengths(pos, maxBytes);
                    } else {
                        this.validateByteAndCodePointLengths(pos, maxBytes, maxChars, this.getCharacterSetForBind(pos, (short)0));
                    }
                }
            }
            ++pos;
        }
    }

    private void validateByteLengths(int pos, int max) throws SQLException {
        int nBinds = this.numberOfBindPositions * this.numberOfBoundRows;
        for (int index = pos; index < nBinds; index += this.numberOfBindPositions) {
            int nBytes = this.bindDataLengths[index];
            if (nBytes <= max) continue;
            throw T4CDirectPathPreparedStatement.newBindLengthException(index / this.numberOfBindPositions + 1, pos + 1, nBytes, max, "BYTE");
        }
    }

    private void validateStreamBindLengths() {
        if (this.parameterStream == null) {
            return;
        }
        for (int row = 0; row < this.parameterStream.length; ++row) {
            InputStream[] parameterRow = this.parameterStream[row];
            if (parameterRow == null) continue;
            for (int pos = 0; pos < parameterRow.length; ++pos) {
                int maxLength;
                InputStream parameter = parameterRow[pos];
                if (parameter == null || (maxLength = T4CDirectPathPreparedStatement.getMaxByteLength(this.accessors[pos])) < 1) continue;
                int messageRow = row + 1;
                int messagePos = row + 1;
                parameterRow[pos] = LengthLimiter.limitInputStream(parameter, maxLength, () -> new StreamLengthException(T4CDirectPathPreparedStatement.createBindLengthMessage(messageRow, messagePos, maxLength + 1, maxLength, "BYTE")));
            }
        }
    }

    private static int getMaxByteLength(Accessor accessor) {
        switch (accessor.describeType) {
            case 8: {
                return Integer.MAX_VALUE;
            }
            case 24: {
                return Integer.MAX_VALUE;
            }
            case 112: 
            case 113: {
                return -1;
            }
        }
        return accessor.describeMaxLength;
    }

    private void validateByteAndCodePointLengths(int pos, int maxBytes, int maxChars, CharacterSet encoder) throws SQLException {
        int nBinds = this.numberOfBindPositions * this.numberOfBoundRows;
        for (int index = pos; index < nBinds; index += this.numberOfBindPositions) {
            long offset;
            int nCodePoints;
            int nBytes = this.bindDataLengths[index];
            if (nBytes > maxBytes) {
                throw T4CDirectPathPreparedStatement.newBindLengthException(index / this.numberOfBindPositions + 1, pos + 1, nBytes, maxBytes, "BYTE");
            }
            if (nBytes <= maxChars || (nCodePoints = this.getCodePointCount(offset = this.bindDataOffsets[index], nBytes, encoder)) <= maxChars) continue;
            throw T4CDirectPathPreparedStatement.newBindLengthException(index / this.numberOfBindPositions + 1, pos + 1, nCodePoints, maxChars, "CHAR");
        }
    }

    private int getCodePointCount(long offset, int nBytes, CharacterSet encoder) {
        String decoded;
        switch (encoder.getOracleId()) {
            case 873: {
                return this.getAL32UTF8CodePointCount(offset, nBytes);
            }
            case 871: {
                return this.getUTF8CodePointCount(offset, nBytes);
            }
        }
        try {
            decoded = this.bindData.getString(offset, nBytes, encoder);
        }
        catch (SQLException decodeErr) {
            byte[] encoded = this.bindData.get(offset, nBytes);
            decoded = encoder.toStringWithReplacement(encoded, 0, encoded.length);
        }
        return decoded.codePointCount(0, decoded.length());
    }

    private int getAL32UTF8CodePointCount(long offset, int nBytes) {
        byte[] buf = this.connection.getByteBuffer(nBytes);
        this.bindData.get(offset, buf, 0, nBytes);
        int nCodePoints = 0;
        for (int pos = 0; pos < nBytes; ++pos) {
            ++nCodePoints;
            byte leadingByte = buf[pos];
            if (0 == (0x80 & leadingByte)) continue;
            if (192 == (0xE0 & leadingByte)) {
                ++pos;
                continue;
            }
            if (224 == (0xF0 & leadingByte)) {
                pos += 2;
                continue;
            }
            if (240 == (0xF8 & leadingByte)) {
                pos += 3;
                continue;
            }
            assert (false) : "Detected invalid AL32UTF8 code point at buffer position " + (offset + (long)pos) + " with a leading byte of: 0x" + Integer.toHexString(Byte.toUnsignedInt(leadingByte));
        }
        this.connection.cacheBuffer(buf);
        return nCodePoints;
    }

    private int getUTF8CodePointCount(long offset, int nBytes) {
        byte[] buf = this.connection.getByteBuffer(nBytes);
        this.bindData.get(offset, buf, 0, nBytes);
        int nCodePoints = 0;
        for (int pos = 0; pos < nBytes; ++pos) {
            ++nCodePoints;
            byte leadingByte = buf[pos];
            if (0 == (0x80 & leadingByte)) continue;
            if (192 == (0xE0 & leadingByte)) {
                ++pos;
                continue;
            }
            if (237 == (0xFF & leadingByte)) {
                if (pos + 1 >= nBytes) continue;
                int next4Bits = 0xF & buf[pos + 1] >> 2;
                if (8 == next4Bits) {
                    --nCodePoints;
                }
                pos += 2;
                continue;
            }
            if (224 == (0xF0 & leadingByte)) {
                pos += 2;
                continue;
            }
            assert (false) : "Detected invalid UTF8 code point at buffer position " + (offset + (long)pos) + " with a leading byte of: 0x" + Integer.toHexString(Byte.toUnsignedInt(leadingByte));
        }
        this.connection.cacheBuffer(buf);
        return nCodePoints;
    }

    private static SQLException newBindLengthException(int row, int pos, int length, int max, String semantic) {
        return DatabaseError.createSqlException(72, T4CDirectPathPreparedStatement.createBindLengthMessage(row, pos, length, max, semantic));
    }

    private static String createBindLengthMessage(int row, int pos, int length, int max, String semantic) {
        return "Maximum Length: " + max + " " + semantic + ". Bind at row " + row + ", position " + pos + ": " + length + " " + semantic;
    }

    void setSDBAOfBits(int sdbaOfBits) {
        this.sdbaOfBits = sdbaOfBits;
    }

    void setSDBABits(int sdbaBits) {
        this.sdbaBits = sdbaBits;
    }

    void setDBABBits(int dbabBits) {
        this.dbabBits = dbabBits;
    }

    private void initRowIDAccessors() throws SQLException {
        for (Accessor acc : this.accessors) {
            if (acc.describeType != 208 || acc.describeMaxLength != 10 || !this.columnIsRowID(acc.columnName)) continue;
            acc.describeType = 104;
        }
    }

    private boolean columnIsRowID(String columnName) throws SQLException {
        try (PreparedStatement ps = this.t4Connection.prepareStatement(IS_DTYBRI_QUERY);){
            ps.setString(1, this.schemaName.toUpperCase());
            ps.setString(2, this.tableName.toUpperCase());
            ps.setString(3, columnName.toUpperCase());
            ResultSet rs = ps.executeQuery();
            rs.next();
            boolean bl = 0 != rs.getInt(1);
            return bl;
        }
    }

    private SQLException lobBindsNotSupported() {
        return (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "BLOB, CLOB, and NCLOB bind values are not supported with Direct Path").fillInStackTrace();
    }

    static class StreamLengthException
    extends IOException {
        StreamLengthException(String message) {
            super(message);
        }
    }

    private static class LengthLimiter {
        final long limit;
        long count = 0L;

        LengthLimiter(long limit) {
            this.limit = limit;
        }

        long remaining() {
            return this.limit - this.count;
        }

        int readOne(int readResult) {
            if (readResult != -1) {
                ++this.count;
            }
            return readResult;
        }

        int readMany(int readResult) {
            if (readResult != -1) {
                this.count += (long)readResult;
            }
            return readResult;
        }

        private static InputStream limitInputStream(InputStream delegate, long limit) {
            return LengthLimiter.limitInputStream(delegate, limit, null);
        }

        private static InputStream limitInputStream(final InputStream delegate, final long limit, final Supplier<StreamLengthException> errorSupplier) {
            return new InputStream(){
                LengthLimiter limiter;
                {
                    this.limiter = new LengthLimiter(limit);
                }

                @Override
                public int read() throws IOException {
                    return this.limiter.remaining() > 0L ? this.limiter.readOne(delegate.read()) : this.terminate();
                }

                @Override
                public int read(byte[] dst) throws IOException {
                    return this.read(dst, 0, dst.length);
                }

                @Override
                public int read(byte[] dst, int offset, int length) throws IOException {
                    long remaining = this.limiter.remaining();
                    return remaining > 0L ? this.limiter.readMany(delegate.read(dst, offset, (int)Math.min((long)length, remaining))) : this.terminate();
                }

                @Override
                public int available() throws IOException {
                    return delegate.available();
                }

                @Override
                public void close() throws IOException {
                    delegate.close();
                }

                int terminate() throws StreamLengthException, IOException {
                    if (errorSupplier != null && delegate.read() != -1) {
                        throw (StreamLengthException)errorSupplier.get();
                    }
                    return -1;
                }
            };
        }

        private static Reader limitReader(Reader delegate, long limit) {
            return LengthLimiter.limitReader(delegate, limit, null);
        }

        private static Reader limitReader(final Reader delegate, final long limit, final Supplier<StreamLengthException> errorSupplier) {
            return new Reader(){
                LengthLimiter limiter;
                {
                    this.limiter = new LengthLimiter(limit);
                }

                @Override
                public int read() throws IOException {
                    return this.limiter.remaining() > 0L ? this.limiter.readOne(delegate.read()) : this.terminate();
                }

                @Override
                public int read(char[] dst) throws IOException {
                    return this.read(dst, 0, dst.length);
                }

                @Override
                public int read(char[] dst, int offset, int length) throws IOException {
                    long remaining = this.limiter.remaining();
                    return remaining > 0L ? this.limiter.readMany(delegate.read(dst, offset, (int)Math.min((long)length, remaining))) : this.terminate();
                }

                @Override
                public boolean ready() throws IOException {
                    return delegate.ready();
                }

                @Override
                public void close() throws IOException {
                    delegate.close();
                }

                int terminate() throws StreamLengthException, IOException {
                    if (errorSupplier != null && delegate.read() != -1) {
                        throw (StreamLengthException)errorSupplier.get();
                    }
                    return -1;
                }
            };
        }
    }

    private class DirectPathRowIDBinder
    extends Binder {
        private Binder copyingBinder;
        private final long[] riddef;

        private DirectPathRowIDBinder(byte[] rowIDChars) throws SQLException {
            this.riddef = T4CRowidAccessor.isRestricted(rowIDChars) ? T4CRowidAccessor.rcToRowid(rowIDChars, 0, rowIDChars.length) : T4CRowidAccessor.stringToRowid(rowIDChars, 0, rowIDChars.length);
            this.type = (short)104;
            this.bytelen = 10;
        }

        @Override
        Binder copyingBinder() {
            if (this.copyingBinder == null) {
                this.copyingBinder = new ByteCopyingBinder(){};
                this.copyingBinder.type = this.type;
                this.copyingBinder.bytelen = this.bytelen;
            }
            return this.copyingBinder;
        }

        @Override
        long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
            int len;
            long pos;
            assert (bindUseDBA) : "bindUseDBA is false";
            bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = pos;
            byte[] encoding = 104 == T4CDirectPathPreparedStatement.this.accessors[bindPosition].describeType ? T4CRowidAccessor.rowidToDTYBRI(this.riddef, T4CDirectPathPreparedStatement.this.sdbaOfBits, T4CDirectPathPreparedStatement.this.sdbaBits, T4CDirectPathPreparedStatement.this.dbabBits) : T4CRowidAccessor.rowidToDTYBURI(this.riddef);
            bindData.put(encoding);
            bindDataLengths[bindDataIndex] = len = encoding.length;
            stmt.lastBoundDataLengths[bindPosition] = len;
            bindIndicators[lenoffset] = (short)len;
            if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
                if (bindIndicators[indoffset] == -1) {
                    return CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length);
                }
                return CRC64.updateChecksum(localCheckSum, encoding, 0, len);
            }
            return localCheckSum;
        }
    }
}

