/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.sifs.configuration;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.configuration.parsing.Attribute;

public class IndexConfiguration {
    public static final AttributeDefinition<String> INDEX_LOCATION = AttributeDefinition.builder((Enum)Attribute.PATH, null, String.class).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Integer> INDEX_QUEUE_LENGTH = AttributeDefinition.builder((Enum)Attribute.INDEX_QUEUE_LENGTH, (Object)1000).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Integer> INDEX_SEGMENTS = AttributeDefinition.builder((Enum)Attribute.SEGMENTS, (Object)3).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Integer> MIN_NODE_SIZE = AttributeDefinition.builder((Enum)Attribute.MIN_NODE_SIZE, (Object)0).immutable().autoPersist(false).build();
    public static final AttributeDefinition<Integer> MAX_NODE_SIZE = AttributeDefinition.builder((Enum)Attribute.MAX_NODE_SIZE, (Object)4096).immutable().autoPersist(false).build();
    private final AttributeSet attributes;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(IndexConfiguration.class, new AttributeDefinition[]{INDEX_LOCATION, INDEX_QUEUE_LENGTH, INDEX_SEGMENTS, MIN_NODE_SIZE, MAX_NODE_SIZE});
    }

    public IndexConfiguration(AttributeSet attributes) {
        this.attributes = attributes;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public String indexLocation() {
        return (String)this.attributes.attribute(INDEX_LOCATION).get();
    }

    public void setLocation(String location) {
        this.attributes.attribute(INDEX_LOCATION).set((Object)location);
    }

    public int indexSegments() {
        return (Integer)this.attributes.attribute(INDEX_SEGMENTS).get();
    }

    public int minNodeSize() {
        return (Integer)this.attributes.attribute(MIN_NODE_SIZE).get();
    }

    public int maxNodeSize() {
        return (Integer)this.attributes.attribute(MAX_NODE_SIZE).get();
    }

    public int indexQueueLength() {
        return (Integer)this.attributes.attribute(INDEX_QUEUE_LENGTH).get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexConfiguration that = (IndexConfiguration)o;
        return this.attributes.equals((Object)that.attributes);
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        return "IndexConfiguration{attributes=" + String.valueOf(this.attributes) + "}";
    }
}

