/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.profile;

import java.util.Properties;
import org.keycloak.common.Profile;
import org.keycloak.common.profile.ProfileConfigResolver;
import org.keycloak.common.profile.ProfileException;

public class PropertiesProfileConfigResolver
implements ProfileConfigResolver {
    private Properties properties;

    public PropertiesProfileConfigResolver(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Profile.ProfileName getProfileName() {
        String profile = this.properties.getProperty("keycloak.profile");
        return profile != null ? Profile.ProfileName.valueOf(profile.toUpperCase()) : null;
    }

    @Override
    public ProfileConfigResolver.FeatureConfig getFeatureConfig(Profile.Feature feature) {
        String config = this.properties.getProperty("keycloak.profile.feature." + feature.name().toLowerCase());
        if (config != null) {
            switch (config) {
                case "enabled": {
                    return ProfileConfigResolver.FeatureConfig.ENABLED;
                }
                case "disabled": {
                    return ProfileConfigResolver.FeatureConfig.DISABLED;
                }
            }
            throw new ProfileException("Invalid config value '" + config + "' for feature " + feature.getKey());
        }
        return ProfileConfigResolver.FeatureConfig.UNCONFIGURED;
    }
}

