/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.legacy.database;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.io.File;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.ServerStartupError;
import org.keycloak.common.Profile;
import org.keycloak.common.Version;
import org.keycloak.connections.jpa.DefaultJpaConnectionProvider;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.connections.jpa.updater.JpaUpdaterProvider;
import org.keycloak.connections.jpa.util.JpaUtils;
import org.keycloak.migration.MigrationModelManager;
import org.keycloak.migration.ModelVersion;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.locking.GlobalLockProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ServerInfoAwareProviderFactory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.storage.database.jpa.AbstractJpaConnectionProviderFactory;

public class LegacyJpaConnectionProviderFactory
extends AbstractJpaConnectionProviderFactory
implements ServerInfoAwareProviderFactory,
EnvironmentDependentProviderFactory {
    public static final String QUERY_PROPERTY_PREFIX = "kc.query.";
    private static final Logger logger = Logger.getLogger(LegacyJpaConnectionProviderFactory.class);
    private static final String SQL_GET_LATEST_VERSION = "SELECT ID, VERSION FROM %sMIGRATION_MODEL ORDER BY UPDATE_TIME DESC";
    private Map<String, String> operationalInfo;

    public JpaConnectionProvider create(KeycloakSession session) {
        logger.trace((Object)"Create QuarkusJpaConnectionProvider");
        return new DefaultJpaConnectionProvider(this.createEntityManager(this.entityManagerFactory, session));
    }

    public String getId() {
        return "legacy";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSpecificNamedQueries(KeycloakSession session) {
        EntityManager em = this.createEntityManager(this.entityManagerFactory, session);
        try {
            Map unitProperties = this.entityManagerFactory.getProperties();
            for (Map.Entry entry : unitProperties.entrySet()) {
                if (!((String)entry.getKey()).startsWith(QUERY_PROPERTY_PREFIX)) continue;
                JpaUtils.configureNamedQuery((String)((String)entry.getKey()).substring(QUERY_PROPERTY_PREFIX.length()), (String)entry.getValue().toString(), (EntityManager)em);
            }
        }
        finally {
            JpaUtils.closeEntityManager((EntityManager)em);
        }
    }

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        boolean schemaChanged;
        super.postInit(factory);
        String id = null;
        String version = null;
        String schema = this.getSchema();
        try (Connection connection = this.getConnection();
             KeycloakSession session = factory.create();){
            try (Statement statement = connection.createStatement();
                 ResultSet rs = statement.executeQuery(String.format(SQL_GET_LATEST_VERSION, this.getSchema(schema)));){
                if (rs.next()) {
                    id = rs.getString(1);
                    version = rs.getString(2);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.createOperationalInfo(connection);
            this.addSpecificNamedQueries(session);
            schemaChanged = this.createOrUpdateSchema(schema, version, connection, session);
        }
        catch (SQLException cause) {
            throw new RuntimeException("Failed to update database.", cause);
        }
        if (schemaChanged || Environment.isImportExportMode()) {
            KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, this::initSchema);
        } else {
            Version.RESOURCES_VERSION = id;
        }
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name("initializeEmpty").type("boolean").helpText("Initialize database if empty. If set to false the database has to be manually initialized. If you want to manually initialize the database set migrationStrategy to manual which will create a file with SQL commands to initialize the database.").defaultValue((Object)true).add().property().name("migrationStrategy").type("string").helpText("Strategy to use to migrate database. Valid values are update, manual and validate. Update will automatically migrate the database schema. Manual will export the required changes to a file with SQL commands that you can manually execute on the database. Validate will simply check if the database is up-to-date.").options(new String[]{"update", "manual", "validate"}).defaultValue((Object)"update").add().property().name("migrationExport").type("string").helpText("Path for where to write manual database initialization/migration file.").add().build();
    }

    @Override
    protected EntityManagerFactory getEntityManagerFactory() {
        InjectableInstance instance = Arc.container().select(EntityManagerFactory.class, new Annotation[0]);
        if (instance.isResolvable()) {
            return (EntityManagerFactory)instance.get();
        }
        return this.getEntityManagerFactory("keycloak-default").orElseThrow(() -> new IllegalStateException("Failed to resolve the default entity manager factory"));
    }

    public Map<String, String> getOperationalInfo() {
        return this.operationalInfo;
    }

    public int order() {
        return 100;
    }

    private MigrationStrategy getMigrationStrategy() {
        String migrationStrategy = this.config.get("migrationStrategy");
        if (migrationStrategy == null) {
            migrationStrategy = this.config.get("databaseSchema");
        }
        if (migrationStrategy != null) {
            return MigrationStrategy.valueOf(migrationStrategy.toUpperCase());
        }
        return MigrationStrategy.UPDATE;
    }

    private void initSchema(KeycloakSession session) {
        if (!(Config.getProvider((String)"realm") != null && !"jpa".equals(Config.getProvider((String)"realm")) || Config.getProvider((String)"client") != null && !"jpa".equals(Config.getProvider((String)"client")) || Config.getProvider((String)"clientScope") != null && !"jpa".equals(Config.getProvider((String)"clientScope")))) {
            logger.debug((Object)"Calling migrateModel");
            this.migrateModel(session);
        }
    }

    private void migrateModel(KeycloakSession session) {
        MigrationModelManager.migrate((KeycloakSession)session);
    }

    private String getSchema(String schema) {
        return schema == null ? "" : schema + ".";
    }

    private File getDatabaseUpdateFile() {
        String databaseUpdateFile = this.config.get("migrationExport", "keycloak-database-update.sql");
        return new File(databaseUpdateFile);
    }

    private void createOperationalInfo(Connection connection) {
        try {
            this.operationalInfo = new LinkedHashMap<String, String>();
            DatabaseMetaData md = connection.getMetaData();
            this.operationalInfo.put("databaseUrl", md.getURL());
            this.operationalInfo.put("databaseUser", md.getUserName());
            this.operationalInfo.put("databaseProduct", md.getDatabaseProductName() + " " + md.getDatabaseProductVersion());
            this.operationalInfo.put("databaseDriver", md.getDriverName() + " " + md.getDriverVersion());
            logger.debugf("Database info: %s", (Object)this.operationalInfo.toString());
        }
        catch (SQLException e) {
            logger.warn((Object)("Unable to prepare operational info due database exception: " + e.getMessage()));
        }
    }

    private boolean createOrUpdateSchema(String schema, String version, Connection connection, KeycloakSession session) {
        MigrationStrategy strategy = this.getMigrationStrategy();
        boolean initializeEmpty = this.config.getBoolean("initializeEmpty", Boolean.valueOf(true));
        File databaseUpdateFile = this.getDatabaseUpdateFile();
        JpaUpdaterProvider updater = (JpaUpdaterProvider)session.getProvider(JpaUpdaterProvider.class);
        boolean requiresMigration = version == null || !version.equals(new ModelVersion(Version.VERSION).toString());
        session.setAttribute("VERIFY_AND_RUN_MASTER_CHANGELOG", (Object)requiresMigration);
        JpaUpdaterProvider.Status status = updater.validate(connection, schema);
        if (status == JpaUpdaterProvider.Status.VALID) {
            logger.debug((Object)"Database is up-to-date");
        } else if (status == JpaUpdaterProvider.Status.EMPTY) {
            if (initializeEmpty) {
                this.update(connection, schema, session, updater);
            } else {
                switch (strategy) {
                    case UPDATE: {
                        this.update(connection, schema, session, updater);
                        break;
                    }
                    case MANUAL: {
                        this.export(connection, schema, databaseUpdateFile, session, updater);
                        throw new ServerStartupError("Database not initialized, please initialize database with " + databaseUpdateFile.getAbsolutePath(), false);
                    }
                    case VALIDATE: {
                        throw new ServerStartupError("Database not initialized, please enable database initialization", false);
                    }
                }
            }
        } else {
            switch (strategy) {
                case UPDATE: {
                    this.update(connection, schema, session, updater);
                    break;
                }
                case MANUAL: {
                    this.export(connection, schema, databaseUpdateFile, session, updater);
                    throw new ServerStartupError("Database not up-to-date, please migrate database with " + databaseUpdateFile.getAbsolutePath(), false);
                }
                case VALIDATE: {
                    throw new ServerStartupError("Database not up-to-date, please enable database migration", false);
                }
            }
        }
        return requiresMigration;
    }

    private void update(Connection connection, String schema, KeycloakSession session, JpaUpdaterProvider updater) {
        GlobalLockProvider globalLock = (GlobalLockProvider)session.getProvider(GlobalLockProvider.class);
        globalLock.withLock("database", innerSession -> {
            updater.update(connection, schema);
            return null;
        });
    }

    private void export(Connection connection, String schema, File databaseUpdateFile, KeycloakSession session, JpaUpdaterProvider updater) {
        GlobalLockProvider globalLock = (GlobalLockProvider)session.getProvider(GlobalLockProvider.class);
        globalLock.withLock("database", innerSession -> {
            updater.export(connection, schema, databaseUpdateFile);
            return null;
        });
    }

    public boolean isSupported() {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }

    static enum MigrationStrategy {
        UPDATE,
        VALIDATE,
        MANUAL;

    }
}

