/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch.impl;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.impl.DefaultConsistentHash;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.marshall.core.Ids;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;

public class SyncReplicatedConsistentHashFactory
implements ConsistentHashFactory<ReplicatedConsistentHash> {
    private static final SyncConsistentHashFactory syncCHF = new SyncConsistentHashFactory();

    @Override
    public ReplicatedConsistentHash create(int numOwners, int numSegments, List<Address> members, Map<Address, Float> capacityFactors) {
        ConsistentHash dch = syncCHF.create(1, numSegments, (List)members, (Map)capacityFactors);
        List<Address> membersWithoutState = SyncReplicatedConsistentHashFactory.computeMembersWithoutState(members, null, capacityFactors);
        return this.replicatedFromDefault((DefaultConsistentHash)dch, membersWithoutState);
    }

    @Override
    public ReplicatedConsistentHash fromPersistentState(ScopedPersistentState state) {
        String consistentHashClass = state.getProperty("consistentHash");
        if (!ReplicatedConsistentHash.class.getName().equals(consistentHashClass)) {
            throw Log.CONTAINER.persistentConsistentHashMismatch(this.getClass().getName(), consistentHashClass);
        }
        return new ReplicatedConsistentHash(state);
    }

    private ReplicatedConsistentHash replicatedFromDefault(DefaultConsistentHash dch, List<Address> membersWithoutState) {
        int numSegments = dch.getNumSegments();
        List<Address> members = dch.getMembers();
        int[] primaryOwners = new int[numSegments];
        for (int segment = 0; segment < numSegments; ++segment) {
            primaryOwners[segment] = members.indexOf(dch.locatePrimaryOwnerForSegment(segment));
        }
        return new ReplicatedConsistentHash(members, dch.getCapacityFactors(), membersWithoutState, primaryOwners);
    }

    @Override
    public ReplicatedConsistentHash updateMembers(ReplicatedConsistentHash baseCH, List<Address> newMembers, Map<Address, Float> actualCapacityFactors) {
        DefaultConsistentHash baseDCH = this.defaultFromReplicated(baseCH);
        DefaultConsistentHash dch = syncCHF.updateMembers(baseDCH, newMembers, actualCapacityFactors);
        List<Address> membersWithoutState = SyncReplicatedConsistentHashFactory.computeMembersWithoutState(newMembers, baseCH.getMembers(), actualCapacityFactors);
        return this.replicatedFromDefault(dch, membersWithoutState);
    }

    private DefaultConsistentHash defaultFromReplicated(ReplicatedConsistentHash baseCH) {
        int numSegments = baseCH.getNumSegments();
        List[] baseSegmentOwners = new List[numSegments];
        for (int segment = 0; segment < numSegments; ++segment) {
            baseSegmentOwners[segment] = Collections.singletonList(baseCH.locatePrimaryOwnerForSegment(segment));
        }
        return new DefaultConsistentHash(1, numSegments, baseCH.getMembers(), baseCH.getCapacityFactors(), baseSegmentOwners);
    }

    @Override
    public ReplicatedConsistentHash rebalance(ReplicatedConsistentHash baseCH) {
        return this.create(baseCH.getNumOwners(), baseCH.getNumSegments(), (List)baseCH.getMembers(), (Map)baseCH.getCapacityFactors());
    }

    @Override
    public ReplicatedConsistentHash union(ReplicatedConsistentHash ch1, ReplicatedConsistentHash ch2) {
        return ch1.union(ch2);
    }

    static List<Address> computeMembersWithoutState(List<Address> newMembers, List<Address> oldMembers, Map<Address, Float> capacityFactors) {
        List<Address> membersWithoutState = Collections.emptyList();
        if (capacityFactors != null) {
            boolean hasNodeWithCapacity = false;
            for (Address a : newMembers) {
                float capacityFactor = capacityFactors.get(a).floatValue();
                if (capacityFactor != 0.0f && capacityFactor != 1.0f) {
                    throw new IllegalArgumentException("Invalid replicated cache capacity factor for node " + String.valueOf(a));
                }
                if (capacityFactor == 0.0f || oldMembers != null && !oldMembers.contains(a)) {
                    if (membersWithoutState.isEmpty()) {
                        membersWithoutState = new ArrayList<Address>();
                    }
                    membersWithoutState.add(a);
                    continue;
                }
                hasNodeWithCapacity = true;
            }
            if (!hasNodeWithCapacity) {
                throw new IllegalArgumentException("There must be at least one node with a non-zero capacity factor");
            }
        }
        return membersWithoutState;
    }

    public static class Externalizer
    extends AbstractExternalizer<SyncReplicatedConsistentHashFactory> {
        public void writeObject(ObjectOutput output, SyncReplicatedConsistentHashFactory chf) {
        }

        public SyncReplicatedConsistentHashFactory readObject(ObjectInput unmarshaller) {
            return new SyncReplicatedConsistentHashFactory();
        }

        public Integer getId() {
            return Ids.SYNC_REPLICATED_CONSISTENT_HASH_FACTORY;
        }

        public Set<Class<? extends SyncReplicatedConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(SyncReplicatedConsistentHashFactory.class);
        }
    }
}

