/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.attribute;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.attribute.ExchangeAttributeBuilder;
import io.undertow.attribute.ReadOnlyAttributeException;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;

public class CookieAttribute
implements ExchangeAttribute {
    private final String cookieName;

    public CookieAttribute(String cookieName) {
        this.cookieName = cookieName;
    }

    @Override
    public String readAttribute(HttpServerExchange exchange) {
        Cookie cookie = exchange.getRequestCookies().get(this.cookieName);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    @Override
    public void writeAttribute(HttpServerExchange exchange, String newValue) throws ReadOnlyAttributeException {
        exchange.setResponseCookie(new CookieImpl(this.cookieName, newValue));
    }

    public static final class Builder
    implements ExchangeAttributeBuilder {
        @Override
        public String name() {
            return "Cookie";
        }

        @Override
        public ExchangeAttribute build(String token) {
            if (token.startsWith("%{c,") && token.endsWith("}")) {
                String cookieName = token.substring(4, token.length() - 1);
                return new CookieAttribute(cookieName);
            }
            return null;
        }

        @Override
        public int priority() {
            return 0;
        }
    }
}

