/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class AttackDetectionResource {
    protected static final Logger logger = Logger.getLogger(AttackDetectionResource.class);
    protected final AdminPermissionEvaluator auth;
    protected final RealmModel realm;
    private final AdminEventBuilder adminEvent;
    protected final KeycloakSession session;
    protected final ClientConnection connection;
    protected final HttpHeaders headers;

    public AttackDetectionResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.auth = auth;
        this.realm = session.getContext().getRealm();
        this.connection = session.getContext().getConnection();
        this.adminEvent = adminEvent.realm(this.realm).resource(ResourceType.USER_LOGIN_FAILURE);
        this.headers = session.getContext().getRequestHeaders();
    }

    @GET
    @Path(value="brute-force/users/{userId}")
    @NoCache
    @Produces(value={"application/json"})
    @Tag(name="Attack Detection")
    @Operation(summary="Get status of a username in brute force detection")
    public Map<String, Object> bruteForceUserStatus(@PathParam(value="userId") String userId) {
        UserModel user = this.session.users().getUserById(this.realm, userId);
        if (user == null) {
            this.auth.users().requireView();
        } else {
            this.auth.users().requireView(user);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("disabled", false);
        data.put("numFailures", 0);
        data.put("lastFailure", 0);
        data.put("lastIPFailure", "n/a");
        if (!this.realm.isBruteForceProtected()) {
            return data;
        }
        UserLoginFailureModel model = this.session.loginFailures().getUserLoginFailure(this.realm, userId);
        if (model == null) {
            return data;
        }
        boolean disabled = user == null ? Time.currentTime() < model.getFailedLoginNotBefore() : ((BruteForceProtector)this.session.getProvider(BruteForceProtector.class)).isTemporarilyDisabled(this.session, this.realm, user);
        if (disabled) {
            data.put("disabled", true);
        }
        data.put("numFailures", model.getNumFailures());
        data.put("lastFailure", model.getLastFailure());
        data.put("lastIPFailure", model.getLastIPFailure());
        return data;
    }

    @Path(value="brute-force/users/{userId}")
    @DELETE
    @Tag(name="Attack Detection")
    @Operation(summary="Clear any user login failures for the user This can release temporary disabled user")
    public void clearBruteForceForUser(@PathParam(value="userId") String userId) {
        UserModel user = this.session.users().getUserById(this.realm, userId);
        if (user == null) {
            this.auth.users().requireManage();
        } else {
            this.auth.users().requireManage(user);
        }
        UserLoginFailureModel model = this.session.loginFailures().getUserLoginFailure(this.realm, userId);
        if (model != null) {
            this.session.loginFailures().removeUserLoginFailure(this.realm, userId);
            this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
        }
    }

    @Path(value="brute-force/users")
    @DELETE
    @Tag(name="Attack Detection")
    @Operation(summary="Clear any user login failures for all users This can release temporary disabled users")
    public void clearAllBruteForce() {
        this.auth.users().requireManage();
        this.session.loginFailures().removeAllUserLoginFailures(this.realm);
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }
}

