/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import com.oracle.svm.core.annotate.AlwaysInline;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.logmanager.CopyOnWriteMap;
import org.jboss.logmanager.EmbeddedConfigurator;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.Logger;
import org.wildfly.common.lock.SpinLock;

final class LoggerNode {
    private final LogContext context;
    private final LoggerNode parent;
    private final String fullName;
    private final ConcurrentMap<String, LoggerNode> children;
    private final AtomicReference<Handler[]> handlersRef = new AtomicReference();
    private volatile boolean useParentHandlers = true;
    private volatile Filter filter;
    private volatile boolean useParentFilter = false;
    private volatile Level level;
    private volatile int effectiveLevel;
    private final int effectiveMinLevel;
    private volatile boolean hasLogger;
    private final SpinLock attachmentLock = new SpinLock();
    private Object[] attArray = new Object[1];

    LoggerNode(LogContext context) {
        EmbeddedConfigurator configurator = LogContext.CONFIGURATOR;
        this.parent = null;
        this.fullName = "";
        Level minLevel = configurator.getMinimumLevelOf(this.fullName);
        this.effectiveMinLevel = minLevel == null ? Logger.INFO_INT : minLevel.intValue();
        Level confLevel = configurator.getLevelOf(this.fullName);
        this.level = confLevel == null ? Level.INFO : confLevel;
        this.effectiveLevel = Math.max(this.effectiveMinLevel, this.level.intValue());
        this.handlersRef.set(configurator.getHandlersOf(this.fullName));
        this.context = context;
        this.children = new CopyOnWriteMap<String, LoggerNode>();
    }

    private LoggerNode(LogContext context, LoggerNode parent, String nodeName) {
        EmbeddedConfigurator configurator = LogContext.CONFIGURATOR;
        nodeName = nodeName.trim();
        if (nodeName.length() == 0 && parent == null) {
            throw new IllegalArgumentException("nodeName is empty, or just whitespace and has no parent");
        }
        this.parent = parent;
        this.fullName = parent.parent == null ? (nodeName.isEmpty() ? "." : nodeName) : parent.fullName + "." + nodeName;
        Level minLevel = configurator.getMinimumLevelOf(this.fullName);
        this.effectiveMinLevel = minLevel == null ? parent.effectiveMinLevel : minLevel.intValue();
        this.level = configurator.getLevelOf(this.fullName);
        this.effectiveLevel = Math.max(this.effectiveMinLevel, this.level == null ? parent.effectiveLevel : this.level.intValue());
        this.handlersRef.set(configurator.getHandlersOf(this.fullName));
        this.context = context;
        this.children = new CopyOnWriteMap<String, LoggerNode>();
    }

    LoggerNode getOrCreate(String name) {
        LoggerNode appearingNode;
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null && (appearingNode = this.children.putIfAbsent(nextName, nextNode = new LoggerNode(this.context, this, nextName))) != null) {
            nextNode = appearingNode;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getOrCreate(name.substring(i + 1));
    }

    LoggerNode getIfExists(String name) {
        if (name == null || name.length() == 0) {
            return this;
        }
        int i = name.indexOf(46);
        String nextName = i == -1 ? name : name.substring(0, i);
        LoggerNode nextNode = (LoggerNode)this.children.get(nextName);
        if (nextNode == null) {
            return null;
        }
        if (i == -1) {
            return nextNode;
        }
        return nextNode.getIfExists(name.substring(i + 1));
    }

    Logger createLogger() {
        this.hasLogger = true;
        return new Logger(this, this.fullName);
    }

    Collection<LoggerNode> getChildren() {
        return this.children.values();
    }

    LogContext getContext() {
        return this.context;
    }

    void setEffectiveLevel(int newLevel) {
        if (this.level == null) {
            this.effectiveLevel = newLevel;
            for (LoggerNode node : this.children.values()) {
                if (node == null) continue;
                node.setEffectiveLevel(newLevel);
            }
        }
    }

    void setFilter(Filter filter) {
        this.filter = filter;
    }

    Filter getFilter() {
        return this.filter;
    }

    boolean getUseParentFilters() {
        return this.useParentFilter;
    }

    void setUseParentFilters(boolean useParentFilter) {
        this.useParentFilter = useParentFilter;
    }

    @AlwaysInline(value="Fast level checks")
    int getEffectiveLevel() {
        return this.effectiveLevel;
    }

    @AlwaysInline(value="Fast level checks")
    boolean isLoggableLevel(int level) {
        return level != Logger.OFF_INT && level >= this.effectiveMinLevel && level >= this.effectiveLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Handler[] getHandlers() {
        Handler[] handlers = this.handlersRef.get();
        if (handlers == null) {
            LoggerNode loggerNode = this;
            synchronized (loggerNode) {
                handlers = LogContext.CONFIGURATOR.getHandlersOf(this.fullName);
                this.handlersRef.set(handlers);
            }
        }
        return handlers;
    }

    Handler[] clearHandlers() {
        return this.setHandlers(EmbeddedConfigurator.NO_HANDLERS);
    }

    void removeHandler(Handler handler) {
        block0: while (true) {
            Handler[] handlers = this.getHandlers();
            int length = handlers.length;
            for (int i = 0; i < length; ++i) {
                if (handlers[i] != handler) continue;
                Handler[] newHandlers = Arrays.copyOf(handlers, length - 1);
                System.arraycopy(handlers, i + 1, newHandlers, i, length - i - 1);
                if (!this.compareAndSetHandlers(handlers, newHandlers)) continue block0;
                return;
            }
            break;
        }
    }

    void addHandler(Handler handler) {
        Handler[] newVal;
        Handler[] oldVal;
        do {
            oldVal = this.getHandlers();
            int len = oldVal.length;
            newVal = Arrays.copyOf(oldVal, len + 1);
            newVal[len] = handler;
        } while (!this.handlersRef.compareAndSet(oldVal, newVal));
    }

    Handler[] setHandlers(Handler[] handlers) {
        return this.handlersRef.getAndSet(handlers);
    }

    boolean compareAndSetHandlers(Handler[] oldHandlers, Handler[] newHandlers) {
        return this.handlersRef.compareAndSet(oldHandlers, newHandlers);
    }

    boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    void setUseParentHandlers(boolean useParentHandlers) {
        this.useParentHandlers = useParentHandlers;
    }

    void publish(ExtLogRecord record) {
        LoggerNode parent;
        for (Handler handler : this.getHandlers()) {
            try {
                handler.publish(record);
            }
            catch (Exception e) {
                ExtHandler.reportError(handler, "Handler publication threw an exception", e, 1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.useParentHandlers && (parent = this.parent) != null) {
            parent.publish(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLevel(Level newLevel) {
        Object lock;
        LogContext context = this.context;
        Object object = lock = context.treeLock;
        synchronized (object) {
            int newEffectiveLevel;
            int oldEffectiveLevel = this.effectiveLevel;
            if (newLevel != null) {
                this.level = newLevel;
                newEffectiveLevel = newLevel.intValue();
            } else {
                LoggerNode parent = this.parent;
                if (parent == null) {
                    this.level = Level.INFO;
                    newEffectiveLevel = Logger.INFO_INT;
                } else {
                    this.level = null;
                    newEffectiveLevel = parent.effectiveLevel;
                }
            }
            this.effectiveLevel = newEffectiveLevel;
            if (oldEffectiveLevel != newEffectiveLevel) {
                for (LoggerNode node : this.children.values()) {
                    if (node == null) continue;
                    node.setEffectiveLevel(newEffectiveLevel);
                }
            }
        }
    }

    Level getLevel() {
        return this.level;
    }

    Object[] getAttArray() {
        return this.attArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> V getAttachment(Logger.AttachmentKey<V> key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        SpinLock lock = this.attachmentLock;
        lock.lock();
        try {
            Object object = key.getId() >= this.attArray.length ? null : this.attArray[key.getId()];
            return (V)object;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> V attach(Logger.AttachmentKey<V> key, V value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        SpinLock lock = this.attachmentLock;
        lock.lock();
        try {
            this.extend(key);
            V v = this.put(key, value);
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> V attachIfAbsent(Logger.AttachmentKey<V> key, V value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        SpinLock lock = this.attachmentLock;
        lock.lock();
        try {
            this.extend(key);
            V v = this.put(key, value);
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private <V> void extend(Logger.AttachmentKey<V> key) {
        if (key.getId() >= this.attArray.length) {
            this.attArray = Arrays.copyOf(this.attArray, key.getId() + 1);
        }
    }

    private <V> V put(Logger.AttachmentKey<V> key, V value) {
        Object existing = this.attArray[key.getId()];
        this.attArray[key.getId()] = value;
        return (V)existing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> V detach(Logger.AttachmentKey<V> key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        SpinLock lock = this.attachmentLock;
        lock.lock();
        try {
            this.extend(key);
            V v = this.put(key, null);
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    LoggerNode getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLoggable(ExtLogRecord record) {
        Object lock;
        if (!this.useParentFilter) {
            Filter filter = this.filter;
            return filter == null || filter.isLoggable(record);
        }
        LogContext context = this.context;
        Object object = lock = context.treeLock;
        synchronized (object) {
            return LoggerNode.isLoggable(this, record);
        }
    }

    private static boolean isLoggable(LoggerNode loggerNode, ExtLogRecord record) {
        if (loggerNode == null) {
            return true;
        }
        Filter filter = loggerNode.filter;
        return !(filter != null && !filter.isLoggable(record) || loggerNode.useParentFilter && !LoggerNode.isLoggable(loggerNode.getParent(), record));
    }

    public boolean hasLogger() {
        return this.hasLogger;
    }

    public String getFullName() {
        return this.fullName;
    }
}

