/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev.testing;

import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;

public class ContinuousTestingSharedStateManager {
    private static final CopyOnWriteArraySet<Consumer<State>> stateListeners = new CopyOnWriteArraySet();
    public static final State INITIAL_STATE;
    private static volatile State lastState;

    public static void addStateListener(Consumer<State> stateListener) {
        stateListeners.add(stateListener);
        if (lastState != null) {
            stateListener.accept(lastState);
        }
    }

    public static void removeStateListener(Consumer<State> stateListener) {
        stateListeners.remove(stateListener);
    }

    public static void reset() {
        ContinuousTestingSharedStateManager.setLastState(s -> INITIAL_STATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLastState(Function<StateBuilder, State> modifier) {
        Class<ContinuousTestingSharedStateManager> clazz = ContinuousTestingSharedStateManager.class;
        synchronized (ContinuousTestingSharedStateManager.class) {
            StateBuilder stateBuilder = lastState.builder();
            State state = lastState = modifier.apply(stateBuilder);
            // ** MonitorExit[clazz] (shouldn't be in output)
            for (Consumer consumer : stateListeners) {
                consumer.accept(state);
            }
            return;
        }
    }

    public static State getLastState() {
        return lastState;
    }

    public static void setInProgress(boolean inProgress) {
        ContinuousTestingSharedStateManager.setLastState(s -> s.setInProgress(inProgress).build());
    }

    public static void setRunning(boolean running) {
        ContinuousTestingSharedStateManager.setLastState(s -> s.setRunning(running).build());
    }

    public static void setBrokenOnly(boolean brokenOnly) {
        ContinuousTestingSharedStateManager.setLastState(s -> s.setIsBrokenOnly(brokenOnly).build());
    }

    public static void setTestOutput(boolean testOutput) {
        ContinuousTestingSharedStateManager.setLastState(s -> s.setIsTestOutput(testOutput).build());
    }

    public static void setInstrumentationBasedReload(boolean instrumentationBasedReload) {
        ContinuousTestingSharedStateManager.setLastState(s -> s.setIsInstrumentationBasedReload(instrumentationBasedReload).build());
    }

    public static void setLiveReloadEnabled(boolean liveReload) {
        ContinuousTestingSharedStateManager.setLastState(s -> s.setIsLiveReload(liveReload).build());
    }

    static {
        lastState = INITIAL_STATE = new StateBuilder().setLastRun(-1L).setIsLiveReload(true).build();
    }

    public static class State {
        public final long lastRun;
        public final boolean running;
        public final boolean inProgress;
        public final long run;
        public final long passed;
        public final long failed;
        public final long skipped;
        public final long currentPassed;
        public final long currentFailed;
        public final long currentSkipped;
        public final boolean isBrokenOnly;
        public final boolean isTestOutput;
        public final boolean isInstrumentationBasedReload;
        public final boolean isLiveReload;

        public State(StateBuilder builder) {
            this.lastRun = builder.lastRun;
            this.running = builder.running;
            this.inProgress = builder.inProgress;
            this.run = builder.run;
            this.passed = builder.passed;
            this.failed = builder.failed;
            this.skipped = builder.skipped;
            this.currentPassed = builder.currentPassed;
            this.currentFailed = builder.currentFailed;
            this.currentSkipped = builder.currentSkipped;
            this.isBrokenOnly = builder.isBrokenOnly;
            this.isTestOutput = builder.isTestOutput;
            this.isInstrumentationBasedReload = builder.isInstrumentationBasedReload;
            this.isLiveReload = builder.isLiveReload;
        }

        StateBuilder builder() {
            return new StateBuilder(this);
        }

        public String toString() {
            return "State{lastRun=" + this.lastRun + ", running=" + this.running + ", inProgress=" + this.inProgress + ", run=" + this.run + ", passed=" + this.passed + ", failed=" + this.failed + ", skipped=" + this.skipped + ", isBrokenOnly=" + this.isBrokenOnly + ", isTestOutput=" + this.isTestOutput + ", isInstrumentationBasedReload=" + this.isInstrumentationBasedReload + ", isLiveReload=" + this.isLiveReload + "}";
        }
    }

    public static class StateBuilder {
        long lastRun;
        boolean running;
        boolean inProgress;
        long run;
        long passed;
        long failed;
        long skipped;
        long currentPassed;
        long currentFailed;
        long currentSkipped;
        boolean isBrokenOnly;
        boolean isTestOutput;
        boolean isInstrumentationBasedReload;
        boolean isLiveReload;

        public StateBuilder() {
        }

        public StateBuilder(State existing) {
            this.lastRun = existing.lastRun;
            this.running = existing.running;
            this.inProgress = existing.inProgress;
            this.run = existing.run;
            this.passed = existing.passed;
            this.failed = existing.failed;
            this.skipped = existing.skipped;
            this.currentPassed = existing.currentPassed;
            this.currentFailed = existing.currentFailed;
            this.currentSkipped = existing.currentSkipped;
            this.isBrokenOnly = existing.isBrokenOnly;
            this.isTestOutput = existing.isTestOutput;
            this.isInstrumentationBasedReload = existing.isInstrumentationBasedReload;
            this.isLiveReload = existing.isLiveReload;
        }

        public StateBuilder setLastRun(long lastRun) {
            this.lastRun = lastRun;
            return this;
        }

        public StateBuilder setRunning(boolean running) {
            this.running = running;
            return this;
        }

        public StateBuilder setInProgress(boolean inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public StateBuilder setRun(long run) {
            this.run = run;
            return this;
        }

        public StateBuilder setPassed(long passed) {
            this.passed = passed;
            return this;
        }

        public StateBuilder setFailed(long failed) {
            this.failed = failed;
            return this;
        }

        public StateBuilder setSkipped(long skipped) {
            this.skipped = skipped;
            return this;
        }

        public StateBuilder setCurrentPassed(long currentPassed) {
            this.currentPassed = currentPassed;
            return this;
        }

        public StateBuilder setCurrentFailed(long currentFailed) {
            this.currentFailed = currentFailed;
            return this;
        }

        public StateBuilder setCurrentSkipped(long currentSkipped) {
            this.currentSkipped = currentSkipped;
            return this;
        }

        public StateBuilder setIsBrokenOnly(boolean isBrokenOnly) {
            this.isBrokenOnly = isBrokenOnly;
            return this;
        }

        public StateBuilder setIsTestOutput(boolean isTestOutput) {
            this.isTestOutput = isTestOutput;
            return this;
        }

        public StateBuilder setIsInstrumentationBasedReload(boolean isInstrumentationBasedReload) {
            this.isInstrumentationBasedReload = isInstrumentationBasedReload;
            return this;
        }

        public StateBuilder setIsLiveReload(boolean isLiveReload) {
            this.isLiveReload = isLiveReload;
            return this;
        }

        public long getLastRun() {
            return this.lastRun;
        }

        public boolean isRunning() {
            return this.running;
        }

        public boolean isInProgress() {
            return this.inProgress;
        }

        public long getRun() {
            return this.run;
        }

        public long getPassed() {
            return this.passed;
        }

        public long getFailed() {
            return this.failed;
        }

        public long getSkipped() {
            return this.skipped;
        }

        public long getCurrentPassed() {
            return this.currentPassed;
        }

        public long getCurrentFailed() {
            return this.currentFailed;
        }

        public long getCurrentSkipped() {
            return this.currentSkipped;
        }

        public boolean isBrokenOnly() {
            return this.isBrokenOnly;
        }

        public boolean isTestOutput() {
            return this.isTestOutput;
        }

        public boolean isInstrumentationBasedReload() {
            return this.isInstrumentationBasedReload;
        }

        public boolean isLiveReload() {
            return this.isLiveReload;
        }

        public State build() {
            return new State(this);
        }
    }
}

