/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.mapping;

import jakarta.ws.rs.core.MediaType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.jboss.resteasy.reactive.common.model.ResourceExceptionMapper;
import org.jboss.resteasy.reactive.common.util.ServerMediaType;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveSimplifiedResourceInfo;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.spi.EndpointInvoker;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.server.util.ScoreSystem;
import org.jboss.resteasy.reactive.spi.BeanFactory;

public class RuntimeResource {
    private final String httpMethod;
    private final URITemplate path;
    private final URITemplate classPath;
    private final ServerMediaType produces;
    private final List<MediaType> consumes;
    private final EndpointInvoker invoker;
    private final BeanFactory<Object> endpointFactory;
    private final ServerRestHandler[] handlerChain;
    private final String javaMethodName;
    private final Class<?>[] parameterTypes;
    private final Type returnType;
    private final boolean blocking;
    private final boolean runOnVirtualThread;
    private final Class<?> resourceClass;
    private final ResteasyReactiveResourceInfo lazyMethod;
    private final Map<String, Integer> pathParameterIndexes;
    private final Map<ScoreSystem.Category, List<ScoreSystem.Diagnostic>> score;
    private final MediaType streamElementType;
    private final Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> classExceptionMappers;

    public RuntimeResource(String httpMethod, URITemplate path, URITemplate classPath, ServerMediaType produces, List<MediaType> consumes, EndpointInvoker invoker, BeanFactory<Object> endpointFactory, ServerRestHandler[] handlerChain, String javaMethodName, Class<?>[] parameterTypes, Type returnType, boolean blocking, boolean runOnVirtualThread, Class<?> resourceClass, ResteasyReactiveResourceInfo lazyMethod, Map<String, Integer> pathParameterIndexes, Map<ScoreSystem.Category, List<ScoreSystem.Diagnostic>> score, MediaType streamElementType, Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> classExceptionMappers) {
        this.httpMethod = httpMethod;
        this.path = path;
        this.classPath = classPath;
        this.produces = produces;
        this.consumes = consumes;
        this.invoker = invoker;
        this.endpointFactory = endpointFactory;
        this.handlerChain = handlerChain;
        this.javaMethodName = javaMethodName;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.blocking = blocking;
        this.runOnVirtualThread = runOnVirtualThread;
        this.resourceClass = resourceClass;
        this.lazyMethod = lazyMethod;
        this.pathParameterIndexes = pathParameterIndexes;
        this.score = score;
        this.streamElementType = streamElementType;
        this.classExceptionMappers = classExceptionMappers;
    }

    public ServerRestHandler[] getHandlerChain() {
        return this.handlerChain;
    }

    public String getJavaMethodName() {
        return this.javaMethodName;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public URITemplate getPath() {
        return this.path;
    }

    public ServerMediaType getProduces() {
        return this.produces;
    }

    public List<MediaType> getConsumes() {
        return this.consumes;
    }

    public EndpointInvoker getInvoker() {
        return this.invoker;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public boolean isRunOnVirtualThread() {
        return this.runOnVirtualThread;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public BeanFactory<Object> getEndpointFactory() {
        return this.endpointFactory;
    }

    public ResteasyReactiveResourceInfo getLazyMethod() {
        return this.lazyMethod;
    }

    public SimpleResourceInfo getSimplifiedResourceInfo() {
        return new ResteasyReactiveSimplifiedResourceInfo(this.javaMethodName, this.resourceClass, this.parameterTypes);
    }

    public MediaType getStreamElementType() {
        return this.streamElementType;
    }

    public URITemplate getClassPath() {
        return this.classPath;
    }

    public Map<String, Integer> getPathParameterIndexes() {
        return this.pathParameterIndexes;
    }

    public Map<ScoreSystem.Category, List<ScoreSystem.Diagnostic>> getScore() {
        return this.score;
    }

    public Map<Class<? extends Throwable>, ResourceExceptionMapper<? extends Throwable>> getClassExceptionMappers() {
        return this.classExceptionMappers;
    }

    public String toString() {
        return "RuntimeResource{ method: " + this.javaMethodName + ", path: " + this.path + "}";
    }
}

